/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.server.http;

import ai.vespa.util.http.hc5.VespaHttpClientBuilder;
import com.yahoo.container.jdisc.HttpResponse;
import com.yahoo.vespa.config.server.http.HttpFetcher;
import com.yahoo.vespa.config.server.http.InternalServerException;
import com.yahoo.vespa.config.server.http.RequestTimeoutException;
import com.yahoo.vespa.config.server.http.StaticResponse;
import java.io.IOException;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.hc.client5.http.classic.methods.HttpGet;
import org.apache.hc.client5.http.config.RequestConfig;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.CloseableHttpResponse;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.util.Timeout;

public class SimpleHttpFetcher
implements HttpFetcher {
    private static final Logger logger = Logger.getLogger(SimpleHttpFetcher.class.getName());
    private final CloseableHttpClient client = VespaHttpClientBuilder.create().build();

    @Override
    public HttpResponse get(HttpFetcher.Params params, URI url) {
        StaticResponse staticResponse;
        block9: {
            HttpGet request = new HttpGet(url);
            request.addHeader("Connection", (Object)"Close");
            request.setConfig(RequestConfig.custom().setConnectTimeout(Timeout.ofMilliseconds((long)params.readTimeoutMs)).setResponseTimeout(Timeout.ofMilliseconds((long)params.readTimeoutMs)).build());
            CloseableHttpResponse response = this.client.execute((ClassicHttpRequest)request);
            try {
                HttpEntity entity = response.getEntity();
                staticResponse = new StaticResponse(response.getCode(), entity.getContentType(), entity.getContent().readAllBytes());
                if (response == null) break block9;
            }
            catch (Throwable throwable) {
                String message;
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SocketTimeoutException e) {
                    message = "Timed out after " + params.readTimeoutMs + " ms reading response from " + url;
                    logger.log(Level.WARNING, message, e);
                    throw new RequestTimeoutException(message);
                }
                catch (IOException e) {
                    message = "Failed to get response from " + url;
                    logger.log(Level.WARNING, message, e);
                    throw new InternalServerException(message);
                }
            }
            response.close();
        }
        return staticResponse;
    }
}

