/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.server.maintenance;

import com.yahoo.config.FileReference;
import com.yahoo.config.provision.ApplicationId;
import com.yahoo.config.provision.TenantName;
import com.yahoo.config.subscription.ConfigSourceSet;
import com.yahoo.jrt.Supervisor;
import com.yahoo.jrt.Transport;
import com.yahoo.vespa.config.ConnectionPool;
import com.yahoo.vespa.config.server.ApplicationRepository;
import com.yahoo.vespa.config.server.filedistribution.FileDistributionUtil;
import com.yahoo.vespa.config.server.maintenance.ConfigServerMaintainer;
import com.yahoo.vespa.config.server.session.Session;
import com.yahoo.vespa.config.server.session.SessionRepository;
import com.yahoo.vespa.config.server.tenant.Tenant;
import com.yahoo.vespa.curator.Curator;
import com.yahoo.vespa.defaults.Defaults;
import com.yahoo.vespa.filedistribution.FileDistributionConnectionPool;
import com.yahoo.vespa.filedistribution.FileDownloader;
import com.yahoo.vespa.filedistribution.FileReferenceDownload;
import java.io.File;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.Future;
import java.util.logging.Logger;

public class ApplicationPackageMaintainer
extends ConfigServerMaintainer {
    private static final Logger log = Logger.getLogger(ApplicationPackageMaintainer.class.getName());
    private final File downloadDirectory;
    private final Supervisor supervisor = new Supervisor(new Transport("filedistribution-pool")).setDropEmptyBuffers(true);
    private final FileDownloader fileDownloader;

    ApplicationPackageMaintainer(ApplicationRepository applicationRepository, Curator curator, Duration interval) {
        super(applicationRepository, curator, applicationRepository.flagSource(), applicationRepository.clock(), interval, false);
        this.downloadDirectory = new File(Defaults.getDefaults().underVespaHome(applicationRepository.configserverConfig().fileReferencesDir()));
        this.fileDownloader = ApplicationPackageMaintainer.createFileDownloader(applicationRepository, this.downloadDirectory, this.supervisor);
    }

    protected double maintain() {
        int attempts = 0;
        int[] failures = new int[1];
        ArrayList<Runnable> futureDownloads = new ArrayList<Runnable>();
        block3: for (TenantName tenantName : this.applicationRepository.tenantRepository().getAllTenantNames()) {
            block4: for (Session session : this.applicationRepository.tenantRepository().getTenant(tenantName).getSessionRepository().getRemoteSessions()) {
                if (this.shuttingDown()) continue block3;
                switch (session.getStatus()) {
                    case PREPARE: 
                    case ACTIVATE: {
                        break;
                    }
                    default: {
                        continue block4;
                    }
                }
                ApplicationId applicationId = session.getApplicationId();
                log.finest(() -> "Verifying application package for " + applicationId);
                Optional<FileReference> appFileReference = session.getApplicationPackageReference();
                if (!appFileReference.isPresent()) continue;
                long sessionId = session.getSessionId();
                ++attempts;
                if (!FileDistributionUtil.fileReferenceExistsOnDisk(this.downloadDirectory, appFileReference.get())) {
                    log.fine(() -> "Downloading application package with file reference " + appFileReference + " for " + applicationId + " (session " + sessionId + ")");
                    FileReferenceDownload download = new FileReferenceDownload(appFileReference.get(), ((Object)((Object)this)).getClass().getSimpleName(), false);
                    Future futureDownload = this.fileDownloader.getFutureFileOrTimeout(download);
                    futureDownloads.add(() -> {
                        try {
                            if (((Optional)futureDownload.get()).isPresent()) {
                                this.createLocalSessionIfMissing(applicationId, sessionId);
                                return;
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        failures[0] = failures[0] + 1;
                        log.info("Downloading application package (" + appFileReference + ") for " + applicationId + " (session " + sessionId + ") unsuccessful. Can be ignored unless it happens many times over a long period of time, retries is expected");
                    });
                    continue;
                }
                this.createLocalSessionIfMissing(applicationId, sessionId);
            }
        }
        futureDownloads.forEach(Runnable::run);
        return this.asSuccessFactorDeviation(attempts, failures[0]);
    }

    private static FileDownloader createFileDownloader(ApplicationRepository applicationRepository, File downloadDirectory, Supervisor supervisor) {
        List<String> otherConfigServersInCluster = FileDistributionUtil.getOtherConfigServersInCluster(applicationRepository.configserverConfig());
        ConfigSourceSet configSourceSet = new ConfigSourceSet(otherConfigServersInCluster);
        FileDistributionConnectionPool connectionPool = new FileDistributionConnectionPool(configSourceSet, supervisor);
        return new FileDownloader((ConnectionPool)connectionPool, supervisor, downloadDirectory, Duration.ofSeconds(60L));
    }

    public void awaitShutdown() {
        this.supervisor.transport().shutdown().join();
        this.fileDownloader.close();
        super.awaitShutdown();
    }

    private void createLocalSessionIfMissing(ApplicationId applicationId, long sessionId) {
        Tenant tenant = this.applicationRepository.getTenant(applicationId);
        SessionRepository sessionRepository = tenant.getSessionRepository();
        if (sessionRepository.getLocalSession(sessionId) == null) {
            sessionRepository.createLocalSessionFromDistributedApplicationPackage(sessionId);
        }
    }
}

