/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.server.session;

import com.yahoo.config.provision.ClusterSpec;
import com.yahoo.vespa.config.server.configchange.ConfigChangeActions;
import java.util.List;

public record ActivationTriggers(List<NodeRestart> nodeRestarts, List<ClusterSpec.Id> restartingClusters, List<Reindexing> reindexings) {
    private static final ActivationTriggers empty = new ActivationTriggers(List.of(), List.of(), List.of());

    public static ActivationTriggers empty() {
        return empty;
    }

    public static ActivationTriggers from(ConfigChangeActions configChangeActions, boolean isInternalRedeployment) {
        return new ActivationTriggers(configChangeActions.getRestartActions().useForInternalRestart(isInternalRedeployment).hostnames().stream().map(NodeRestart::new).toList(), configChangeActions.getRestartActions().useForInternalRestart(isInternalRedeployment).getEntries().stream().map(entry -> ClusterSpec.Id.from((String)entry.getClusterName())).toList(), configChangeActions.getReindexActions().getEntries().stream().map(entry -> new Reindexing(entry.getClusterName(), entry.getDocumentType())).toList());
    }

    public record Reindexing(String clusterId, String documentType) {
    }

    public record NodeRestart(String hostname) {
    }
}

