/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.server.application;

import com.yahoo.component.Version;
import com.yahoo.config.provision.ApplicationId;
import com.yahoo.vespa.config.server.NotFoundException;
import com.yahoo.vespa.config.server.application.Application;
import com.yahoo.vespa.config.server.application.ApplicationVersions;
import com.yahoo.vespa.config.server.application.VersionDoesNotExistException;
import java.time.Instant;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public final class ApplicationMapper {
    private final Map<ApplicationId, ApplicationVersions> requestHandlers = new ConcurrentHashMap<ApplicationId, ApplicationVersions>();

    private ApplicationVersions applicationVersions(ApplicationId applicationId) {
        ApplicationVersions versions = this.requestHandlers.get(applicationId);
        if (versions == null) {
            throw new NotFoundException("No such application id: " + applicationId);
        }
        return versions;
    }

    public void register(ApplicationId applicationId, ApplicationVersions applicationVersions) {
        this.requestHandlers.put(applicationId, applicationVersions);
    }

    public void remove(ApplicationId applicationId) {
        this.requestHandlers.remove(applicationId);
    }

    public Application getForVersion(ApplicationId applicationId, Optional<Version> vespaVersion, Instant now) throws VersionDoesNotExistException {
        return this.applicationVersions(applicationId).getForVersionOrLatest(vespaVersion, now);
    }

    public boolean hasApplication(ApplicationId applicationId, Instant now) {
        return this.hasApplicationForVersion(applicationId, Optional.empty(), now);
    }

    public boolean hasApplicationForVersion(ApplicationId applicationId, Optional<Version> vespaVersion, Instant now) {
        try {
            return this.getForVersion(applicationId, vespaVersion, now) != null;
        }
        catch (NotFoundException | VersionDoesNotExistException ex) {
            return false;
        }
    }

    public int numApplications() {
        return this.requestHandlers.size();
    }

    public Set<ApplicationId> listApplicationIds() {
        return Collections.unmodifiableSet(this.requestHandlers.keySet());
    }

    public List<Application> listApplications(ApplicationId applicationId) {
        return this.requestHandlers.get(applicationId).applications();
    }
}

