/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.server.http;

import ai.vespa.util.http.hc5.VespaHttpClientBuilder;
import com.yahoo.config.model.api.HostInfo;
import com.yahoo.config.model.api.container.ContainerServiceType;
import com.yahoo.config.provision.SystemName;
import com.yahoo.config.provision.TenantName;
import com.yahoo.container.jdisc.HttpResponse;
import com.yahoo.container.jdisc.secretstore.SecretStore;
import com.yahoo.slime.Cursor;
import com.yahoo.slime.Slime;
import com.yahoo.slime.SlimeUtils;
import com.yahoo.vespa.config.server.application.Application;
import com.yahoo.vespa.config.server.http.HttpErrorResponse;
import com.yahoo.vespa.config.server.http.ProxyResponse;
import com.yahoo.vespa.config.server.tenant.SecretStoreExternalIdRetriever;
import com.yahoo.yolean.Exceptions;
import java.io.IOException;
import java.net.URI;
import org.apache.hc.client5.http.classic.methods.HttpPost;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.io.entity.ByteArrayEntity;

public class SecretStoreValidator {
    private static final String PROTOCOL = "http://";
    private static final String AWS_PARAMETER_VALIDATION_HANDLER_POSTFIX = ":4080/validate-secret-store";
    private final SecretStore secretStore;
    private final CloseableHttpClient httpClient = VespaHttpClientBuilder.custom().buildClient();

    public SecretStoreValidator(SecretStore secretStore) {
        this.secretStore = secretStore;
    }

    public HttpResponse validateSecretStore(Application application, SystemName system, Slime slime) {
        this.addExternalId(application.getId().tenant(), system, slime);
        URI uri = this.getUri(application);
        return this.postRequest(uri, slime);
    }

    private URI getUri(Application application) {
        String hostname = application.getModel().getHosts().stream().filter(hostInfo -> hostInfo.getServices().stream().filter(service -> ContainerServiceType.CONTAINER.serviceName.equals(service.getServiceType())).count() > 0L).map(HostInfo::getHostname).findFirst().orElseThrow();
        return URI.create(PROTOCOL + hostname + AWS_PARAMETER_VALIDATION_HANDLER_POSTFIX);
    }

    private HttpResponse postRequest(URI uri, Slime slime) {
        HttpPost postRequest = new HttpPost(uri);
        byte[] data = (byte[])Exceptions.uncheck(() -> SlimeUtils.toJsonBytes((Slime)slime));
        ByteArrayEntity entity = new ByteArrayEntity(data, ContentType.DEFAULT_BINARY);
        postRequest.setEntity((HttpEntity)entity);
        try {
            return new ProxyResponse(this.httpClient.execute((ClassicHttpRequest)postRequest));
        }
        catch (IOException e) {
            return HttpErrorResponse.internalServerError(String.format("Failed to post request to %s: %s", uri, Exceptions.toMessageString((Throwable)e)));
        }
    }

    private void addExternalId(TenantName tenantName, SystemName system, Slime slime) {
        Cursor data = slime.get();
        String name = data.field("name").asString();
        String secretName = SecretStoreExternalIdRetriever.secretName(tenantName, system, name);
        data.setString("externalId", this.secretStore.getSecret(secretName));
    }
}

