/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.server.application;

import ai.vespa.http.DomainName;
import ai.vespa.http.HttpURL;
import ai.vespa.util.http.hc5.VespaAsyncHttpClientBuilder;
import com.yahoo.config.model.api.ApplicationClusterEndpoint;
import com.yahoo.config.model.api.ServiceInfo;
import com.yahoo.config.model.api.container.ContainerServiceType;
import com.yahoo.slime.Inspector;
import com.yahoo.slime.SlimeUtils;
import com.yahoo.vespa.config.server.application.ActiveTokenFingerprints;
import com.yahoo.vespa.config.server.modelfactory.ModelResult;
import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Phaser;
import java.util.stream.Collectors;
import org.apache.hc.client5.http.async.methods.SimpleHttpResponse;
import org.apache.hc.client5.http.async.methods.SimpleRequestBuilder;
import org.apache.hc.client5.http.config.ConnectionConfig;
import org.apache.hc.client5.http.config.RequestConfig;
import org.apache.hc.client5.http.impl.async.CloseableHttpAsyncClient;
import org.apache.hc.client5.http.impl.nio.PoolingAsyncClientConnectionManagerBuilder;
import org.apache.hc.core5.concurrent.FutureCallback;
import org.apache.hc.core5.io.CloseMode;
import org.apache.hc.core5.reactor.IOReactorConfig;
import org.apache.hc.core5.util.TimeValue;
import org.apache.hc.core5.util.Timeout;

public class ActiveTokenFingerprintsClient
implements ActiveTokenFingerprints,
AutoCloseable {
    private final CloseableHttpAsyncClient httpClient = ActiveTokenFingerprintsClient.createHttpClient();

    public ActiveTokenFingerprintsClient() {
        this.httpClient.start();
    }

    @Override
    public Map<String, List<ActiveTokenFingerprints.Token>> get(ModelResult application) {
        Set containersWithTokenFilter = application.getModel().applicationClusterInfo().stream().flatMap(cluster -> cluster.endpoints().stream()).filter(endpoint -> endpoint.authMethod() == ApplicationClusterEndpoint.AuthMethod.token).flatMap(endpoint -> endpoint.hostNames().stream()).collect(Collectors.toSet());
        return this.getFingerprints(application.getModel().getHosts().stream().filter(host -> containersWithTokenFilter.contains(host.getHostname())).flatMap(host -> host.getServices().stream()).filter(service -> service.getServiceType().equals(ContainerServiceType.CONTAINER.serviceName) || service.getServiceType().equals(ContainerServiceType.QRSERVER.serviceName)).toList());
    }

    private Map<String, List<ActiveTokenFingerprints.Token>> getFingerprints(List<ServiceInfo> services) {
        ConcurrentHashMap<String, List<ActiveTokenFingerprints.Token>> tokens = new ConcurrentHashMap<String, List<ActiveTokenFingerprints.Token>>();
        Phaser phaser = new Phaser(services.size() + 1);
        for (ServiceInfo service : services) {
            this.getFingerprints(tokens, service, phaser);
        }
        phaser.arriveAndAwaitAdvance();
        return tokens;
    }

    private void getFingerprints(final Map<String, List<ActiveTokenFingerprints.Token>> hostTokens, final ServiceInfo service, final Phaser phaser) {
        URI uri = HttpURL.create((HttpURL.Scheme)HttpURL.Scheme.http, (DomainName)DomainName.of((String)service.getHostName()), (int)service.getPorts().stream().filter(port -> port.getTags().stream().anyMatch("http"::equals)).findAny().get().getPort(), (HttpURL.Path)HttpURL.Path.parse((String)"/data-plane-tokens/v1")).asURI();
        this.httpClient.execute(SimpleRequestBuilder.get((URI)uri).build(), (FutureCallback)new FutureCallback<SimpleHttpResponse>(){

            public void completed(SimpleHttpResponse result) {
                if (result.getCode() == 200) {
                    hostTokens.put(service.getHostName(), ActiveTokenFingerprintsClient.parseTokens(result));
                }
                phaser.arrive();
            }

            public void failed(Exception ex) {
                phaser.arrive();
            }

            public void cancelled() {
                phaser.arrive();
            }
        });
    }

    private static List<ActiveTokenFingerprints.Token> parseTokens(SimpleHttpResponse response) {
        return SlimeUtils.entriesStream((Inspector)SlimeUtils.jsonToSlime((byte[])response.getBodyBytes()).get().field("tokens")).map(entry -> new ActiveTokenFingerprints.Token(entry.field("id").asString(), SlimeUtils.entriesStream((Inspector)entry.field("fingerprints")).map(Inspector::asString).toList())).toList();
    }

    private static CloseableHttpAsyncClient createHttpClient() {
        return VespaAsyncHttpClientBuilder.create(tlsStrategy -> PoolingAsyncClientConnectionManagerBuilder.create().setTlsStrategy(tlsStrategy).setDefaultConnectionConfig(ConnectionConfig.custom().setConnectTimeout(Timeout.ofSeconds((long)2L)).build()).build()).setIOReactorConfig(IOReactorConfig.custom().setSoTimeout(Timeout.ofSeconds((long)2L)).build()).setDefaultRequestConfig(RequestConfig.custom().setConnectionRequestTimeout(Timeout.ofSeconds((long)2L)).setResponseTimeout(Timeout.ofSeconds((long)2L)).build()).setUserAgent("data-plane-token-client").build();
    }

    @Override
    public void close() throws Exception {
        this.httpClient.close(CloseMode.GRACEFUL);
        this.httpClient.awaitShutdown(TimeValue.ofSeconds((long)10L));
    }
}

