/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.server.http;

import ai.vespa.util.http.hc5.VespaHttpClientBuilder;
import com.yahoo.container.jdisc.HttpResponse;
import com.yahoo.vespa.config.server.http.HttpErrorResponse;
import com.yahoo.vespa.config.server.http.ProxyResponse;
import com.yahoo.yolean.Exceptions;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.time.Instant;
import java.util.Optional;
import org.apache.hc.client5.http.classic.methods.HttpGet;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.core5.http.ClassicHttpRequest;

public class LogRetriever {
    private final CloseableHttpClient httpClient = VespaHttpClientBuilder.custom().buildClient();

    public HttpResponse getLogs(String logServerUri, Optional<Instant> deployTime) {
        HttpGet get = new HttpGet(logServerUri);
        try {
            return new ProxyResponse(this.httpClient.execute((ClassicHttpRequest)get));
        }
        catch (IOException e) {
            if (deployTime.isPresent() && Instant.now().isBefore(deployTime.get().plus(Duration.ofMinutes(2L)))) {
                return new HttpResponse(200){

                    public void render(OutputStream outputStream) throws IOException {
                        outputStream.write("".getBytes(StandardCharsets.UTF_8));
                    }
                };
            }
            return HttpErrorResponse.internalServerError("Failed to get logs: " + Exceptions.toMessageString((Throwable)e));
        }
    }
}

