/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.server.application;

import com.yahoo.config.provision.ApplicationId;
import com.yahoo.slime.Cursor;
import com.yahoo.slime.Inspector;
import com.yahoo.slime.Slime;
import com.yahoo.slime.SlimeUtils;
import java.io.IOException;
import java.util.OptionalLong;

public class ApplicationData {
    private static final String APPLICATION_ID_FIELD = "applicationId";
    private static final String ACTIVE_SESSION_FIELD = "activeSession";
    private static final String LAST_DEPLOYED_SESSION_FIELD = "lastDeployedSession";
    private final ApplicationId applicationId;
    private final OptionalLong activeSession;
    private final OptionalLong lastDeployedSession;

    ApplicationData(ApplicationId applicationId, OptionalLong activeSession, OptionalLong lastDeployedSession) {
        this.applicationId = applicationId;
        this.activeSession = activeSession;
        this.lastDeployedSession = lastDeployedSession;
    }

    static ApplicationData fromBytes(byte[] data) {
        return ApplicationData.fromSlime(SlimeUtils.jsonToSlime((byte[])data));
    }

    static ApplicationData fromSlime(Slime slime) {
        Cursor cursor = slime.get();
        return new ApplicationData(ApplicationId.fromSerializedForm((String)cursor.field(APPLICATION_ID_FIELD).asString()), SlimeUtils.optionalLong((Inspector)cursor.field(ACTIVE_SESSION_FIELD)), SlimeUtils.optionalLong((Inspector)cursor.field(LAST_DEPLOYED_SESSION_FIELD)));
    }

    public byte[] toJson() {
        try {
            Slime slime = new Slime();
            this.toSlime(slime.setObject());
            return SlimeUtils.toJsonBytes((Slime)slime);
        }
        catch (IOException e) {
            throw new RuntimeException("Serialization of application data to json failed", e);
        }
    }

    public ApplicationId applicationId() {
        return this.applicationId;
    }

    public OptionalLong activeSession() {
        return this.activeSession;
    }

    public OptionalLong lastDeployedSession() {
        return this.lastDeployedSession;
    }

    public String toString() {
        return "application '" + this.applicationId + "', active session " + this.activeSession + ", last deployed session " + this.lastDeployedSession;
    }

    private void toSlime(Cursor object) {
        object.setString(APPLICATION_ID_FIELD, this.applicationId.serializedForm());
        this.activeSession.ifPresent(session -> object.setLong(ACTIVE_SESSION_FIELD, session));
        this.lastDeployedSession.ifPresent(session -> object.setLong(LAST_DEPLOYED_SESSION_FIELD, session));
    }
}

