/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.server.session;

import com.yahoo.component.Version;
import com.yahoo.config.FileReference;
import com.yahoo.config.model.api.Quota;
import com.yahoo.config.model.api.TenantSecretStore;
import com.yahoo.config.provision.ApplicationId;
import com.yahoo.config.provision.AthenzDomain;
import com.yahoo.config.provision.CloudAccount;
import com.yahoo.config.provision.DataplaneToken;
import com.yahoo.config.provision.DockerImage;
import com.yahoo.vespa.config.server.session.SessionData;
import com.yahoo.vespa.config.server.session.SessionZooKeeperClient;
import com.yahoo.vespa.flags.BooleanFlag;
import java.security.cert.X509Certificate;
import java.util.List;
import java.util.Optional;

public class SessionSerializer {
    void write(SessionZooKeeperClient zooKeeperClient, ApplicationId applicationId, Optional<FileReference> fileReference, Optional<DockerImage> dockerImageRepository, Version vespaVersion, Optional<AthenzDomain> athenzDomain, Optional<Quota> quota, List<TenantSecretStore> tenantSecretStores, List<X509Certificate> operatorCertificates, Optional<CloudAccount> cloudAccount, List<DataplaneToken> dataplaneTokens, BooleanFlag writeSessionData) {
        zooKeeperClient.writeApplicationId(applicationId);
        zooKeeperClient.writeApplicationPackageReference(fileReference);
        zooKeeperClient.writeVespaVersion(vespaVersion);
        zooKeeperClient.writeDockerImageRepository(dockerImageRepository);
        zooKeeperClient.writeAthenzDomain(athenzDomain);
        zooKeeperClient.writeQuota(quota);
        zooKeeperClient.writeTenantSecretStores(tenantSecretStores);
        zooKeeperClient.writeOperatorCertificates(operatorCertificates);
        zooKeeperClient.writeCloudAccount(cloudAccount);
        zooKeeperClient.writeDataplaneTokens(dataplaneTokens);
        if (writeSessionData.value()) {
            zooKeeperClient.writeSessionData(new SessionData(applicationId, fileReference, vespaVersion, dockerImageRepository, athenzDomain, quota, tenantSecretStores, operatorCertificates, cloudAccount, dataplaneTokens));
        }
    }
}

