/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.server.filedistribution;

import com.yahoo.cloud.config.ConfigserverConfig;
import com.yahoo.component.annotation.Inject;
import com.yahoo.config.application.api.FileRegistry;
import com.yahoo.config.model.api.FileDistribution;
import com.yahoo.jrt.Supervisor;
import com.yahoo.jrt.Transport;
import com.yahoo.vespa.config.server.filedistribution.AddFileInterface;
import com.yahoo.vespa.config.server.filedistribution.ApplicationFileManager;
import com.yahoo.vespa.config.server.filedistribution.FileDBRegistry;
import com.yahoo.vespa.config.server.filedistribution.FileDirectory;
import com.yahoo.vespa.config.server.filedistribution.FileDistributionImpl;
import com.yahoo.vespa.defaults.Defaults;
import java.io.File;

public class FileDistributionFactory
implements AutoCloseable {
    protected final ConfigserverConfig configserverConfig;
    private final Supervisor supervisor = new Supervisor(new Transport("filedistribution"));

    @Inject
    public FileDistributionFactory(ConfigserverConfig configserverConfig) {
        this.configserverConfig = configserverConfig;
    }

    public FileRegistry createFileRegistry(File applicationPackage) {
        return new FileDBRegistry(this.createFileManager(applicationPackage));
    }

    public FileDistribution createFileDistribution() {
        return new FileDistributionImpl(this.supervisor);
    }

    public AddFileInterface createFileManager(File applicationDir) {
        return new ApplicationFileManager(applicationDir, new FileDirectory(this.getFileReferencesDir()), this.configserverConfig.hostedVespa());
    }

    protected File getFileReferencesDir() {
        return new File(Defaults.getDefaults().underVespaHome(this.configserverConfig.fileReferencesDir()));
    }

    @Override
    public void close() {
        this.supervisor.transport().shutdown().join();
    }
}

