/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.server.session;

import com.yahoo.text.Utf8;
import com.yahoo.vespa.config.server.monitoring.MetricUpdater;
import com.yahoo.vespa.config.server.session.Session;
import com.yahoo.vespa.config.server.session.SessionRepository;
import com.yahoo.vespa.curator.Curator;
import java.util.concurrent.Executor;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.curator.framework.recipes.cache.ChildData;

public class SessionStateWatcher {
    private static final Logger log = Logger.getLogger(SessionStateWatcher.class.getName());
    private final Curator.FileCache fileCache;
    private final long sessionId;
    private final MetricUpdater metrics;
    private final Executor zkWatcherExecutor;
    private final SessionRepository sessionRepository;

    SessionStateWatcher(Curator.FileCache fileCache, long sessionId, MetricUpdater metrics, Executor zkWatcherExecutor, SessionRepository sessionRepository) {
        this.fileCache = fileCache;
        this.sessionId = sessionId;
        this.metrics = metrics;
        this.fileCache.addListener(this::nodeChanged);
        this.fileCache.start();
        this.zkWatcherExecutor = zkWatcherExecutor;
        this.sessionRepository = sessionRepository;
    }

    private synchronized void sessionStatusChanged(Session.Status newStatus) {
        switch (newStatus) {
            case NEW: 
            case UNKNOWN: {
                break;
            }
            case DELETE: 
            case DEACTIVATE: {
                this.sessionRepository.deactivateAndUpdateCache(this.sessionId);
                break;
            }
            case PREPARE: {
                this.sessionRepository.prepareRemoteSession(this.sessionId);
                break;
            }
            case ACTIVATE: {
                this.sessionRepository.activate(this.sessionId);
                break;
            }
            default: {
                throw new IllegalStateException("Unknown status " + newStatus);
            }
        }
    }

    public long getSessionId() {
        return this.sessionId;
    }

    public void close() {
        try {
            this.fileCache.close();
        }
        catch (Exception e) {
            log.log(Level.WARNING, "Exception when closing watcher", e);
        }
    }

    private void nodeChanged() {
        this.zkWatcherExecutor.execute(() -> {
            Session.Status newStatus = Session.Status.UNKNOWN;
            try {
                ChildData node = this.fileCache.getCurrentData();
                if (node != null) {
                    String debugMessage;
                    newStatus = Session.Status.parse(Utf8.toString((byte[])node.getData()));
                    String string = debugMessage = log.isLoggable(Level.FINE) ? "Session " + this.sessionId + " changed status to " + newStatus.name() : null;
                    if (debugMessage != null) {
                        log.fine(debugMessage);
                    }
                    this.sessionStatusChanged(newStatus);
                    if (debugMessage != null) {
                        log.fine(debugMessage + ": Done");
                    }
                }
            }
            catch (Exception e) {
                log.log(Level.WARNING, "Error handling session change to " + newStatus.name() + " for session " + this.getSessionId(), e);
                this.metrics.incSessionChangeErrors();
            }
        });
    }
}

