/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.server.application;

import ai.vespa.http.DomainName;
import ai.vespa.http.HttpURL;
import com.yahoo.component.annotation.Inject;
import com.yahoo.config.model.api.HostInfo;
import com.yahoo.config.model.api.PortInfo;
import com.yahoo.config.model.api.ServiceInfo;
import com.yahoo.container.jdisc.HttpResponse;
import com.yahoo.vespa.config.server.application.Application;
import com.yahoo.vespa.config.server.http.HttpFetcher;
import com.yahoo.vespa.config.server.http.NotFoundException;
import com.yahoo.vespa.config.server.http.SimpleHttpFetcher;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.logging.Logger;

public class HttpProxy {
    private static final Logger logger = Logger.getLogger(HttpProxy.class.getName());
    private final HttpFetcher fetcher;

    @Inject
    public HttpProxy() {
        this(new SimpleHttpFetcher());
    }

    public HttpProxy(HttpFetcher fetcher) {
        this.fetcher = fetcher;
    }

    public HttpResponse get(Application application, String hostName, String serviceType, HttpURL.Path path, HttpURL.Query query) {
        return this.get(application, hostName, serviceType, path, query, null);
    }

    public HttpResponse get(Application application, String hostName, String serviceType, HttpURL.Path path, HttpURL.Query query, HttpURL forwardedUrl) {
        HostInfo host = application.getModel().getHosts().stream().filter(hostInfo -> hostInfo.getHostname().equals(hostName)).findFirst().orElseThrow(() -> new NotFoundException("Failed to find host " + hostName));
        ServiceInfo service = host.getServices().stream().filter(serviceInfo -> serviceType.equals(serviceInfo.getServiceType())).findFirst().orElseThrow(() -> new NotFoundException("Failed to find any service of type " + serviceType + " on host " + hostName));
        PortInfo port = service.getPorts().stream().filter(portInfo -> portInfo.getTags().containsAll(List.of("http", "state"))).findFirst().orElseThrow(() -> new NotFoundException("Failed to find HTTP state port"));
        HttpURL url = HttpURL.create((HttpURL.Scheme)HttpURL.Scheme.http, (DomainName)DomainName.of((String)host.getHostname()), (int)port.getPort(), (HttpURL.Path)path, (HttpURL.Query)query);
        HttpResponse response = this.fetcher.get(new HttpFetcher.Params(29000), url.asURI());
        return forwardedUrl == null ? response : new UrlRewritingProxyResponse(response, url, forwardedUrl);
    }

    static class UrlRewritingProxyResponse
    extends HttpResponse {
        final HttpResponse wrapped;
        final String patten;
        final String replacement;

        public UrlRewritingProxyResponse(HttpResponse wrapped, HttpURL requestUrl, HttpURL forwardedUrl) {
            super(wrapped.getStatus());
            this.wrapped = wrapped;
            this.patten = requestUrl.withPath(requestUrl.path().withoutTrailingSlash()).withQuery(HttpURL.Query.empty()).asURI().toString();
            this.replacement = forwardedUrl.withPath(forwardedUrl.path().withoutTrailingSlash()).withQuery(HttpURL.Query.empty()).asURI().toString();
        }

        public void render(OutputStream outputStream) throws IOException {
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            this.wrapped.render((OutputStream)buffer);
            outputStream.write(buffer.toString(Charset.forName(this.wrapped.getCharacterEncoding())).replace(this.patten, this.replacement).getBytes(StandardCharsets.UTF_8));
        }

        public String getContentType() {
            return this.wrapped.getContentType();
        }
    }
}

