/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.server.deploy;

import com.yahoo.concurrent.UncheckedTimeoutException;
import com.yahoo.config.FileReference;
import com.yahoo.config.application.api.DeployLogger;
import com.yahoo.config.provision.ActivationContext;
import com.yahoo.config.provision.ApplicationId;
import com.yahoo.config.provision.ApplicationLockException;
import com.yahoo.config.provision.ApplicationTransaction;
import com.yahoo.config.provision.HostFilter;
import com.yahoo.config.provision.ProvisionLock;
import com.yahoo.config.provision.Provisioner;
import com.yahoo.config.provision.TransientException;
import com.yahoo.transaction.NestedTransaction;
import com.yahoo.vespa.config.server.ApplicationRepository;
import com.yahoo.vespa.config.server.TimeoutBudget;
import com.yahoo.vespa.config.server.application.Application;
import com.yahoo.vespa.config.server.application.ConfigConvergenceChecker;
import com.yahoo.vespa.config.server.application.ConfigNotConvergedException;
import com.yahoo.vespa.config.server.configchange.ConfigChangeActions;
import com.yahoo.vespa.config.server.configchange.ReindexActions;
import com.yahoo.vespa.config.server.configchange.RestartActions;
import com.yahoo.vespa.config.server.session.PrepareParams;
import com.yahoo.vespa.config.server.session.Session;
import com.yahoo.vespa.config.server.session.SessionRepository;
import com.yahoo.vespa.config.server.tenant.Tenant;
import com.yahoo.yolean.concurrent.Memoized;
import java.time.Clock;
import java.time.Duration;
import java.util.Collection;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;

public class Deployment
implements com.yahoo.config.provision.Deployment {
    private static final Logger log = Logger.getLogger(Deployment.class.getName());
    private static final Duration durationBetweenResourceReadyChecks = Duration.ofSeconds(60L);
    private final Session session;
    private final ApplicationRepository applicationRepository;
    private final Supplier<PrepareParams> params;
    private final Optional<Provisioner> provisioner;
    private final Tenant tenant;
    private final DeployLogger deployLogger;
    private final Clock clock;
    private final boolean internalRedeploy;
    private boolean prepared;
    private ConfigChangeActions configChangeActions;

    private Deployment(Session session, ApplicationRepository applicationRepository, Supplier<PrepareParams> params, Optional<Provisioner> provisioner, Tenant tenant, DeployLogger deployLogger, Clock clock, boolean internalRedeploy, boolean prepared) {
        this.session = session;
        this.applicationRepository = applicationRepository;
        this.params = params;
        this.provisioner = provisioner;
        this.tenant = tenant;
        this.deployLogger = deployLogger;
        this.clock = clock;
        this.internalRedeploy = internalRedeploy;
        this.prepared = prepared;
    }

    public static Deployment unprepared(Session session, ApplicationRepository applicationRepository, Optional<Provisioner> provisioner, Tenant tenant, PrepareParams params, DeployLogger logger, Clock clock) {
        return new Deployment(session, applicationRepository, () -> params, provisioner, tenant, logger, clock, false, false);
    }

    public static Deployment unprepared(Session session, ApplicationRepository applicationRepository, Optional<Provisioner> provisioner, Tenant tenant, DeployLogger logger, Duration timeout, Clock clock, boolean validate, boolean isBootstrap) {
        Supplier<PrepareParams> params = Deployment.createPrepareParams(clock, timeout, session, isBootstrap, !validate, false, true);
        return new Deployment(session, applicationRepository, params, provisioner, tenant, logger, clock, true, false);
    }

    public static Deployment prepared(Session session, ApplicationRepository applicationRepository, Optional<Provisioner> provisioner, Tenant tenant, DeployLogger logger, Duration timeout, Clock clock, boolean isBootstrap, boolean force) {
        Supplier<PrepareParams> params = Deployment.createPrepareParams(clock, timeout, session, isBootstrap, false, force, false);
        return new Deployment(session, applicationRepository, params, provisioner, tenant, logger, clock, false, true);
    }

    public void prepare() {
        if (this.prepared) {
            return;
        }
        PrepareParams params = this.params.get();
        try (ApplicationRepository.ActionTimer timer = this.applicationRepository.timerFor(params.getApplicationId(), "deployment.prepareMillis");){
            this.configChangeActions = this.sessionRepository().prepareLocalSession(this.session, this.deployLogger, params, this.clock.instant());
            this.prepared = true;
        }
        catch (Exception e) {
            log.log(Level.FINE, "Preparing session " + this.session.getSessionId() + " failed, deleting it");
            this.deleteSession();
            throw e;
        }
    }

    public long activate() {
        this.prepare();
        this.validateSessionStatus(this.session);
        PrepareParams params = this.params.get();
        Deployment.waitForResourcesOrTimeout(params, this.session, this.provisioner);
        ApplicationId applicationId = this.session.getApplicationId();
        try (ApplicationRepository.ActionTimer timer = this.applicationRepository.timerFor(applicationId, "deployment.activateMillis");){
            TimeoutBudget timeoutBudget = params.getTimeoutBudget();
            timeoutBudget.assertNotTimedOut(() -> "Timeout exceeded when trying to activate '" + applicationId + "'");
            try {
                ApplicationRepository.Activation activation = this.applicationRepository.activate(this.session, applicationId, this.tenant, params.force());
                this.waitForActivation(applicationId, timeoutBudget, activation);
            }
            catch (Exception e) {
                log.log(Level.FINE, "Activating session " + this.session.getSessionId() + " failed, deleting it");
                this.deleteSession();
                throw e;
            }
            this.restartServicesIfNeeded(applicationId);
            this.storeReindexing(applicationId, this.session.getMetaData().getGeneration());
            long l = this.session.getMetaData().getGeneration();
            return l;
        }
    }

    private void waitForActivation(ApplicationId applicationId, TimeoutBudget timeoutBudget, ApplicationRepository.Activation activation) {
        activation.awaitCompletion(timeoutBudget.timeLeft());
        Set<FileReference> fileReferences = this.applicationRepository.getFileReferences(applicationId);
        String fileReferencesText = fileReferences.size() > 10 ? " " + fileReferences.size() + " file references" : "File references: " + fileReferences;
        log.log(Level.INFO, this.session.logPre() + "Session " + this.session.getSessionId() + " activated successfully using " + this.provisioner.map(provisioner -> provisioner.getClass().getSimpleName()).orElse("no host provisioner") + ". Config generation " + this.session.getMetaData().getGeneration() + activation.sourceSessionId().stream().mapToObj(id -> ". Based on session " + id).findFirst().orElse("") + ". " + fileReferencesText);
    }

    private void deleteSession() {
        this.sessionRepository().deleteLocalSession(this.session.getSessionId());
    }

    private SessionRepository sessionRepository() {
        return this.tenant.getSessionRepository();
    }

    private void restartServicesIfNeeded(ApplicationId applicationId) {
        if (this.provisioner.isEmpty() || this.configChangeActions == null) {
            return;
        }
        RestartActions restartActions = this.configChangeActions.getRestartActions().useForInternalRestart(this.internalRedeploy);
        if (restartActions.isEmpty()) {
            return;
        }
        this.waitForConfigToConverge(applicationId);
        Set<String> hostnames = restartActions.hostnames();
        this.provisioner.get().restart(applicationId, HostFilter.from(hostnames));
        this.deployLogger.log(Level.INFO, String.format("Scheduled service restart of %d nodes: %s", hostnames.size(), hostnames.stream().sorted().collect(Collectors.joining(", "))));
        log.info(String.format("%sScheduled service restart of %d nodes: %s", this.session.logPre(), hostnames.size(), restartActions.format()));
        this.configChangeActions = this.configChangeActions.withRestartActions(new RestartActions());
    }

    private void waitForConfigToConverge(ApplicationId applicationId) {
        this.deployLogger.log(Level.INFO, "Wait for all services to use new config generation before restarting");
        while (true) {
            try {
                this.params.get().getTimeoutBudget().assertNotTimedOut(() -> "Timeout exceeded while waiting for config convergence for " + applicationId);
            }
            catch (UncheckedTimeoutException e) {
                throw new ConfigNotConvergedException(e);
            }
            ConfigConvergenceChecker convergenceChecker = this.applicationRepository.configConvergenceChecker();
            Application app = this.applicationRepository.getActiveApplication(applicationId);
            ConfigConvergenceChecker.ServiceListResponse response = convergenceChecker.checkConvergenceUnlessDeferringChangesUntilRestart(app);
            if (response.converged) {
                this.deployLogger.log(Level.INFO, "Services converged on new config generation " + response.currentGeneration);
                return;
            }
            this.deployLogger.log(Level.INFO, "Services did not converge on new config generation " + response.wantedGeneration + ", current generation: " + response.currentGeneration + ", will retry");
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException interruptedException) {
            }
        }
    }

    private void storeReindexing(ApplicationId applicationId, long requiredSession) {
        this.applicationRepository.modifyReindexing(applicationId, reindexing -> {
            if (this.configChangeActions != null) {
                for (ReindexActions.Entry entry : this.configChangeActions.getReindexActions().getEntries()) {
                    reindexing = reindexing.withPending(entry.getClusterName(), entry.getDocumentType(), requiredSession);
                }
            }
            return reindexing;
        });
    }

    public void restart(HostFilter filter) {
        this.provisioner.get().restart(this.session.getApplicationId(), filter);
    }

    public Session session() {
        return this.session;
    }

    public ConfigChangeActions configChangeActions() {
        if (this.configChangeActions != null) {
            return this.configChangeActions;
        }
        throw new IllegalArgumentException("No config change actions: " + (this.prepared ? "was already prepared" : "not yet prepared"));
    }

    private void validateSessionStatus(Session session) {
        long sessionId = session.getSessionId();
        if (Session.Status.NEW.equals((Object)session.getStatus())) {
            throw new IllegalArgumentException(session.logPre() + "Session " + sessionId + " is not prepared");
        }
        if (Session.Status.ACTIVATE.equals((Object)session.getStatus())) {
            throw new IllegalArgumentException(session.logPre() + "Session " + sessionId + " is already active");
        }
    }

    private static Supplier<PrepareParams> createPrepareParams(Clock clock, Duration timeout, Session session, boolean isBootstrap, boolean ignoreValidationErrors, boolean force, boolean waitForResourcesInPrepare) {
        return new Memoized(() -> {
            TimeoutBudget timeoutBudget = new TimeoutBudget(clock, timeout);
            PrepareParams.Builder params = new PrepareParams.Builder().applicationId(session.getApplicationId()).vespaVersion(session.getVespaVersion().toString()).timeoutBudget(timeoutBudget).ignoreValidationErrors(ignoreValidationErrors).isBootstrap(isBootstrap).force(force).waitForResourcesInPrepare(waitForResourcesInPrepare).tenantSecretStores(session.getTenantSecretStores());
            session.getDockerImageRepository().ifPresent(params::dockerImageRepository);
            session.getAthenzDomain().ifPresent(params::athenzDomain);
            session.getCloudAccount().ifPresent(params::cloudAccount);
            return params.build();
        });
    }

    private static void waitForResourcesOrTimeout(PrepareParams params, Session session, Optional<Provisioner> provisioner) {
        if (!params.waitForResourcesInPrepare() || provisioner.isEmpty()) {
            return;
        }
        Set preparedHosts = session.getAllocatedHosts().getHosts();
        ActivationContext context = new ActivationContext(session.getSessionId());
        AtomicReference<Throwable> lastException = new AtomicReference<Throwable>();
        while (true) {
            params.getTimeoutBudget().assertNotTimedOut(() -> "Timeout exceeded while waiting for application resources of '" + session.getApplicationId() + "'" + Optional.ofNullable((Exception)lastException.get()).map(e -> ". Last exception: " + e.getMessage()).orElse(""));
            try (ProvisionLock lock = provisioner.get().lock(session.getApplicationId());){
                ApplicationTransaction transaction = new ApplicationTransaction(lock, new NestedTransaction());
                provisioner.get().activate((Collection)preparedHosts, context, transaction);
                return;
            }
            catch (ApplicationLockException | TransientException e) {
                lastException.set(e);
                try {
                    Thread.sleep(durationBetweenResourceReadyChecks.toMillis());
                }
                catch (InterruptedException e1) {
                    throw new RuntimeException(e1);
                }
            }
        }
    }
}

