/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.server.maintenance;

import com.yahoo.cloud.config.ConfigserverConfig;
import com.yahoo.vespa.config.server.ApplicationRepository;
import com.yahoo.vespa.config.server.filedistribution.FileDirectory;
import com.yahoo.vespa.config.server.maintenance.ConfigServerMaintainer;
import com.yahoo.vespa.curator.Curator;
import com.yahoo.vespa.flags.FlagSource;
import java.time.Duration;

public class FileDistributionMaintainer
extends ConfigServerMaintainer {
    private final FileDirectory fileDirectory;
    private final Duration maxUnusedFileReferenceAge;

    FileDistributionMaintainer(ApplicationRepository applicationRepository, Curator curator, Duration interval, FlagSource flagSource, FileDirectory fileDirectory) {
        super(applicationRepository, curator, flagSource, applicationRepository.clock(), interval, false);
        ConfigserverConfig configserverConfig = applicationRepository.configserverConfig();
        this.maxUnusedFileReferenceAge = Duration.ofMinutes(configserverConfig.keepUnusedFileReferencesMinutes());
        this.fileDirectory = fileDirectory;
    }

    protected double maintain() {
        this.applicationRepository.deleteUnusedFileDistributionReferences(this.fileDirectory, this.maxUnusedFileReferenceAge);
        return 1.0;
    }
}

