/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.server.filedistribution;

import com.yahoo.cloud.config.ConfigserverConfig;
import com.yahoo.component.annotation.Inject;
import com.yahoo.concurrent.DaemonThreadFactory;
import com.yahoo.config.FileReference;
import com.yahoo.config.subscription.ConfigSourceSet;
import com.yahoo.jrt.Int32Value;
import com.yahoo.jrt.Request;
import com.yahoo.jrt.StringValue;
import com.yahoo.jrt.Supervisor;
import com.yahoo.jrt.Transport;
import com.yahoo.jrt.Value;
import com.yahoo.vespa.config.ConnectionPool;
import com.yahoo.vespa.config.server.filedistribution.FileDirectory;
import com.yahoo.vespa.config.server.filedistribution.FileDistributionUtil;
import com.yahoo.vespa.defaults.Defaults;
import com.yahoo.vespa.filedistribution.EmptyFileReferenceData;
import com.yahoo.vespa.filedistribution.FileDistributionConnectionPool;
import com.yahoo.vespa.filedistribution.FileDownloader;
import com.yahoo.vespa.filedistribution.FileReferenceCompressor;
import com.yahoo.vespa.filedistribution.FileReferenceData;
import com.yahoo.vespa.filedistribution.FileReferenceDownload;
import com.yahoo.vespa.filedistribution.LazyFileReferenceData;
import com.yahoo.vespa.filedistribution.LazyTemporaryStorageFileReferenceData;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.time.Duration;
import java.time.Instant;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.logging.Level;
import java.util.logging.Logger;

public class FileServer {
    private static final Logger log = Logger.getLogger(FileServer.class.getName());
    private static final Duration timeout = Duration.ofSeconds(10L);
    private final FileDirectory root;
    private final ExecutorService executor;
    private final FileDownloader downloader;

    @Inject
    public FileServer(ConfigserverConfig configserverConfig) {
        this(new File(Defaults.getDefaults().underVespaHome(configserverConfig.fileReferencesDir())), FileServer.createFileDownloader(FileDistributionUtil.getOtherConfigServersInCluster(configserverConfig)));
    }

    public FileServer(File rootDir) {
        this(rootDir, FileServer.createFileDownloader(List.of()));
    }

    public FileServer(File rootDir, FileDownloader fileDownloader) {
        this.downloader = fileDownloader;
        this.root = new FileDirectory(rootDir);
        this.executor = Executors.newFixedThreadPool(Math.max(8, Runtime.getRuntime().availableProcessors()), (ThreadFactory)new DaemonThreadFactory("file-server-"));
    }

    boolean hasFile(String fileReference) {
        return this.hasFile(new FileReference(fileReference));
    }

    private boolean hasFile(FileReference reference) {
        try {
            return this.root.getFile(reference).exists();
        }
        catch (IllegalArgumentException e) {
            log.log(Level.FINE, () -> "Failed locating " + reference + ": " + e.getMessage());
            return false;
        }
    }

    FileDirectory getRootDir() {
        return this.root;
    }

    void startFileServing(FileReference fileReference, Receiver target) {
        if (this.root.getFile(fileReference).exists()) {
            this.serveFile(fileReference, target);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void serveFile(FileReference reference, Receiver target) {
        File file = this.root.getFile(reference);
        log.log(Level.FINE, () -> "Start serving " + reference + " with file '" + file.getAbsolutePath() + "'");
        try (FileReferenceData fileData = EmptyFileReferenceData.empty((FileReference)reference, (String)file.getName());){
            fileData = this.readFileReferenceData(reference);
            target.receive(fileData, new ReplayStatus(0, "OK"));
            log.log(Level.FINE, () -> "Done serving " + reference.value() + " with file '" + file.getAbsolutePath() + "'");
        }
    }

    private FileReferenceData readFileReferenceData(FileReference reference) throws IOException {
        File file = this.root.getFile(reference);
        if (file.isDirectory()) {
            Path tempFile = Files.createTempFile("filereferencedata", reference.value(), new FileAttribute[0]);
            File compressedFile = new FileReferenceCompressor(FileReferenceData.Type.compressed).compress(file.getParentFile(), tempFile.toFile());
            return new LazyTemporaryStorageFileReferenceData(reference, file.getName(), FileReferenceData.Type.compressed, compressedFile);
        }
        return new LazyFileReferenceData(reference, file.getName(), FileReferenceData.Type.file, file);
    }

    public void serveFile(FileReference fileReference, boolean downloadFromOtherSourceIfNotFound, Request request, Receiver receiver) {
        if (this.executor instanceof ThreadPoolExecutor) {
            log.log(Level.FINE, () -> "Active threads: " + ((ThreadPoolExecutor)this.executor).getActiveCount());
        }
        log.log(Level.FINE, () -> "Received request for file reference '" + fileReference + "' from " + request.target());
        Instant deadline = Instant.now().plus(timeout);
        String client = request.target().toString();
        this.executor.execute(() -> {
            FileApiErrorCodes result = this.serveFileInternal(fileReference, downloadFromOtherSourceIfNotFound, client, receiver, deadline);
            request.returnValues().add((Value)new Int32Value(result.getCode())).add((Value)new StringValue(result.getDescription()));
            request.returnRequest();
        });
    }

    private FileApiErrorCodes serveFileInternal(FileReference fileReference, boolean downloadFromOtherSourceIfNotFound, String client, Receiver receiver, Instant deadline) {
        boolean fileExists;
        if (Instant.now().isAfter(deadline)) {
            log.log(Level.INFO, () -> "Deadline exceeded for request for file reference '" + fileReference + "' from " + client);
            return FileApiErrorCodes.TIMEOUT;
        }
        try {
            FileReferenceDownload fileReferenceDownload = new FileReferenceDownload(fileReference, client, downloadFromOtherSourceIfNotFound);
            fileExists = this.hasFileDownloadIfNeeded(fileReferenceDownload);
            if (fileExists) {
                this.startFileServing(fileReference, receiver);
            }
        }
        catch (IllegalArgumentException e) {
            fileExists = false;
            log.warning("Failed serving file reference '" + fileReference + "', request from " + client + " failed with: " + e.getMessage());
        }
        return fileExists ? FileApiErrorCodes.OK : FileApiErrorCodes.NOT_FOUND;
    }

    boolean hasFileDownloadIfNeeded(FileReferenceDownload fileReferenceDownload) {
        FileReference fileReference = fileReferenceDownload.fileReference();
        if (this.hasFile(fileReference)) {
            return true;
        }
        if (fileReferenceDownload.downloadFromOtherSourceIfNotFound()) {
            log.log(Level.FINE, "File not found, downloading from another source");
            FileReferenceDownload newDownload = new FileReferenceDownload(fileReference, fileReferenceDownload.client(), false);
            boolean fileExists = this.downloader.getFile(newDownload).isPresent();
            if (!fileExists) {
                log.log(Level.INFO, "Failed downloading '" + fileReferenceDownload + "'");
            }
            return fileExists;
        }
        log.log(Level.FINE, "File not found, will not download from another source");
        return false;
    }

    public FileDownloader downloader() {
        return this.downloader;
    }

    public void close() {
        this.downloader.close();
        this.executor.shutdown();
    }

    private static FileDownloader createFileDownloader(List<String> configServers) {
        Supervisor supervisor = new Supervisor(new Transport("filedistribution-pool")).setDropEmptyBuffers(true);
        return new FileDownloader(configServers.isEmpty() ? FileDownloader.emptyConnectionPool() : FileServer.createConnectionPool(configServers, supervisor), supervisor, timeout);
    }

    private static ConnectionPool createConnectionPool(List<String> configServers, Supervisor supervisor) {
        ConfigSourceSet configSourceSet = new ConfigSourceSet(configServers);
        if (configServers.size() == 0) {
            return FileDownloader.emptyConnectionPool();
        }
        return new FileDistributionConnectionPool(configSourceSet, supervisor);
    }

    public static interface Receiver {
        public void receive(FileReferenceData var1, ReplayStatus var2);
    }

    public static class ReplayStatus {
        private final int code;
        private final String description;

        ReplayStatus(int code, String description) {
            this.code = code;
            this.description = description;
        }

        public boolean ok() {
            return this.code == 0;
        }

        public int getCode() {
            return this.code;
        }

        public String getDescription() {
            return this.description;
        }
    }

    private static enum FileApiErrorCodes {
        OK(0, "OK"),
        NOT_FOUND(1, "File reference not found"),
        TIMEOUT(2, "Timeout");

        private final int code;
        private final String description;

        private FileApiErrorCodes(int code, String description) {
            this.code = code;
            this.description = description;
        }

        int getCode() {
            return this.code;
        }

        String getDescription() {
            return this.description;
        }
    }
}

