/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.server.host;

import com.google.common.collect.Collections2;
import com.yahoo.config.provision.ApplicationId;
import com.yahoo.config.provision.TenantName;
import com.yahoo.vespa.config.server.host.HostValidator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;

public class HostRegistry
implements HostValidator {
    private static final Logger log = Logger.getLogger(HostRegistry.class.getName());
    private final Map<String, ApplicationId> host2KeyMap = new ConcurrentHashMap<String, ApplicationId>();

    public ApplicationId getKeyForHost(String hostName) {
        return this.host2KeyMap.get(hostName);
    }

    public synchronized void update(ApplicationId key, Collection<String> newHosts) {
        this.verifyHosts(key, newHosts);
        Collection<String> currentHosts = this.getHostsForKey(key);
        log.log(Level.FINE, () -> "Setting hosts for key '" + key + "', newHosts: " + newHosts + ", currentHosts: " + currentHosts);
        Collection<String> removedHosts = HostRegistry.getRemovedHosts(newHosts, currentHosts);
        this.removeHosts(removedHosts);
        this.addHosts(key, newHosts);
    }

    @Override
    public synchronized void verifyHosts(ApplicationId applicationId, Collection<String> newHosts) {
        for (String host : newHosts) {
            if (!this.hostAlreadyTaken(host, applicationId)) continue;
            throw new IllegalArgumentException("'" + applicationId + "' tried to allocate host '" + host + "', but the host is already taken by '" + this.host2KeyMap.get(host) + "'");
        }
    }

    public synchronized void removeHostsForKey(ApplicationId key) {
        this.host2KeyMap.entrySet().removeIf(entry -> ((ApplicationId)entry.getValue()).equals((Object)key));
    }

    public synchronized void removeHostsForKey(TenantName key) {
        this.host2KeyMap.entrySet().removeIf(entry -> ((ApplicationId)entry.getValue()).tenant().equals((Object)key));
    }

    public synchronized Collection<String> getAllHosts() {
        return Collections.unmodifiableCollection(new ArrayList<String>(this.host2KeyMap.keySet()));
    }

    public synchronized Collection<String> getHostsForKey(ApplicationId key) {
        return this.host2KeyMap.entrySet().stream().filter(entry -> ((ApplicationId)entry.getValue()).equals((Object)key)).map(Map.Entry::getKey).collect(Collectors.toSet());
    }

    private boolean hostAlreadyTaken(String host, ApplicationId key) {
        return this.host2KeyMap.containsKey(host) && !key.equals((Object)this.host2KeyMap.get(host));
    }

    private static Collection<String> getRemovedHosts(Collection<String> newHosts, Collection<String> previousHosts) {
        return Collections2.filter(previousHosts, host -> !newHosts.contains(host));
    }

    private void removeHosts(Collection<String> removedHosts) {
        for (String host : removedHosts) {
            log.log(Level.FINE, () -> "Removing " + host);
            this.host2KeyMap.remove(host);
        }
    }

    private void addHosts(ApplicationId key, Collection<String> newHosts) {
        for (String host : newHosts) {
            log.log(Level.FINE, () -> "Adding " + host);
            this.host2KeyMap.put(host, key);
        }
    }
}

