/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.server.version;

import com.yahoo.cloud.config.ConfigserverConfig;
import com.yahoo.component.Version;
import com.yahoo.component.annotation.Inject;
import com.yahoo.io.IOUtils;
import com.yahoo.path.Path;
import com.yahoo.text.Utf8;
import com.yahoo.vespa.curator.Curator;
import com.yahoo.vespa.defaults.Defaults;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.util.Optional;

public class VersionState {
    static final Path versionPath = Path.fromString((String)"/config/v2/vespa_version");
    private final File versionFile;
    private final Curator curator;

    @Inject
    public VersionState(ConfigserverConfig config, Curator curator) {
        this(new File(Defaults.getDefaults().underVespaHome(config.configServerDBDir()), "vespa_version"), curator);
    }

    public VersionState(File versionFile, Curator curator) {
        this.versionFile = versionFile;
        this.curator = curator;
    }

    public boolean isUpgraded() {
        return this.currentVersion().compareTo(this.storedVersion()) > 0;
    }

    public void saveNewVersion() {
        this.saveNewVersion(this.currentVersion().toFullString());
    }

    public void saveNewVersion(String vespaVersion) {
        this.curator.set(versionPath, Utf8.toBytes((String)vespaVersion));
        try (FileWriter writer = new FileWriter(this.versionFile);){
            writer.write(vespaVersion);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public Version storedVersion() {
        Version version;
        Optional version2 = this.curator.getData(versionPath);
        if (version2.isPresent()) {
            try {
                return Version.fromString((String)Utf8.toString((byte[])((byte[])version2.get())));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        FileReader reader = new FileReader(this.versionFile);
        try {
            version = Version.fromString((String)IOUtils.readAll((Reader)reader));
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                return new Version(0, 0, 0);
            }
        }
        reader.close();
        return version;
    }

    public Version currentVersion() {
        return new Version(8, 120, 11);
    }

    File versionFile() {
        return this.versionFile;
    }

    public String toString() {
        return String.format("Current version:%s, stored version:%s", this.currentVersion(), this.storedVersion());
    }
}

