/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.server.rpc;

import com.yahoo.cloud.config.SentinelConfig;
import com.yahoo.collections.Pair;
import com.yahoo.component.Version;
import com.yahoo.config.ConfigInstance;
import com.yahoo.config.provision.TenantName;
import com.yahoo.container.di.config.ApplicationBundlesConfig;
import com.yahoo.jrt.Request;
import com.yahoo.net.HostName;
import com.yahoo.vespa.config.ConfigPayload;
import com.yahoo.vespa.config.PayloadChecksums;
import com.yahoo.vespa.config.UnknownConfigIdException;
import com.yahoo.vespa.config.protocol.ConfigResponse;
import com.yahoo.vespa.config.protocol.JRTServerConfigRequest;
import com.yahoo.vespa.config.protocol.Payload;
import com.yahoo.vespa.config.protocol.SlimeConfigResponse;
import com.yahoo.vespa.config.protocol.Trace;
import com.yahoo.vespa.config.protocol.VespaVersion;
import com.yahoo.vespa.config.server.GetConfigContext;
import com.yahoo.vespa.config.server.UnknownConfigDefinitionException;
import com.yahoo.vespa.config.server.rpc.RpcServer;
import com.yahoo.vespa.config.server.tenant.TenantRepository;
import java.util.Optional;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

class GetConfigProcessor
implements Runnable {
    private static final Logger log = Logger.getLogger(GetConfigProcessor.class.getName());
    private static final String localHostName = HostName.getLocalhost();
    private static final PayloadChecksums emptyApplicationBundlesConfigChecksums = PayloadChecksums.fromPayload((Payload)Payload.from((ConfigPayload)ConfigPayload.fromInstance((ConfigInstance)new ApplicationBundlesConfig.Builder().build())));
    private final JRTServerConfigRequest request;
    private final boolean forceResponse;
    private final RpcServer rpcServer;
    private String logPre = "";

    GetConfigProcessor(RpcServer rpcServer, JRTServerConfigRequest request, boolean forceResponse) {
        this.rpcServer = rpcServer;
        this.request = request;
        this.forceResponse = forceResponse;
    }

    private void respond(JRTServerConfigRequest request) {
        Request req = request.getRequest();
        if (req.isError()) {
            Level logLevel = Set.of(Integer.valueOf(100300), Integer.valueOf(100005)).contains(req.errorCode()) ? Level.FINE : Level.INFO;
            log.log(logLevel, () -> this.logPre + req.errorMessage());
        }
        this.rpcServer.respond(request);
    }

    private void handleError(JRTServerConfigRequest request, int errorCode, String message) {
        String target = "(unknown)";
        try {
            target = request.getRequest().target().toString();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        request.addErrorResponse(errorCode, this.logPre + "Failed request (" + message + ") from " + target);
        this.respond(request);
    }

    public Pair<GetConfigContext, Long> getConfig(JRTServerConfigRequest request) {
        ConfigResponse config;
        if (!request.validateParameters()) {
            log.log(Level.WARNING, "Parameters for request " + request + " did not validate: " + request.errorCode() + " : " + request.errorMessage());
            this.respond(request);
            return null;
        }
        Trace trace = request.getRequestTrace();
        this.debugLog(trace, "GetConfigProcessor.run() on " + localHostName);
        Optional<TenantName> tenant = this.rpcServer.resolveTenant(request, trace);
        if (this.rpcServer.canReturnEmptySentinelConfig() && this.rpcServer.allTenantsLoaded() && tenant.isEmpty() && this.isSentinelConfigRequest(request)) {
            this.returnEmpty(request);
            return null;
        }
        GetConfigContext context = this.rpcServer.createGetConfigContext(tenant, request, trace);
        if (context == null || !context.requestHandler().hasApplication(context.applicationId(), Optional.empty())) {
            this.handleError(request, 100300, "No application exists");
            return null;
        }
        this.logPre = TenantRepository.logPre(context.applicationId());
        Optional<Version> vespaVersion = this.rpcServer.useRequestVersion() ? request.getVespaVersion().map(VespaVersion::toString).map(Version::fromString) : Optional.empty();
        this.debugLog(trace, "Using version " + GetConfigProcessor.printableVespaVersion(vespaVersion));
        if (!context.requestHandler().hasApplication(context.applicationId(), vespaVersion)) {
            this.handleError(request, 100005, "Unknown Vespa version in request: " + GetConfigProcessor.printableVespaVersion(vespaVersion));
            return null;
        }
        try {
            config = this.rpcServer.resolveConfig(request, context, vespaVersion);
        }
        catch (UnknownConfigDefinitionException e) {
            this.handleError(request, 100001, "Unknown config definition " + request.getConfigKey());
            return null;
        }
        catch (UnknownConfigIdException e) {
            this.handleError(request, 100102, "Illegal config id " + request.getConfigKey().getConfigId());
            return null;
        }
        catch (Throwable e) {
            log.log(Level.SEVERE, "Unexpected error handling config request", e);
            this.handleError(request, 100200, "Internal error " + e.getMessage());
            return null;
        }
        if (config != null && (!config.getPayloadChecksums().matches(request.getRequestConfigChecksums()) || config.hasNewerGeneration(request) || this.forceResponse)) {
            if (ApplicationBundlesConfig.class.equals((Object)request.getConfigKey().getConfigClass()) && !context.requestHandler().compatibleWith(vespaVersion, context.applicationId()) && !emptyApplicationBundlesConfigChecksums.matches(config.getPayloadChecksums())) {
                this.handleError(request, 100500, "Version " + GetConfigProcessor.printableVespaVersion(vespaVersion) + " is binary incompatible with the latest deployed version");
                return null;
            }
        } else {
            this.debugLog(trace, "delaying response " + request.getShortDescription());
            return new Pair((Object)context, (Object)(config != null ? config.getGeneration() : 0L));
        }
        request.addOkResponse(request.payloadFromResponse(config), config.getGeneration(), config.applyOnRestart(), config.getPayloadChecksums());
        this.debugLog(trace, "return response: " + request.getShortDescription());
        this.respond(request);
        return null;
    }

    @Override
    public void run() {
        Pair<GetConfigContext, Long> delayed = this.getConfig(this.request);
        if (delayed != null) {
            this.rpcServer.delayResponse(this.request, (GetConfigContext)delayed.getFirst());
            if (this.rpcServer.hasNewerGeneration(((GetConfigContext)delayed.getFirst()).applicationId(), (Long)delayed.getSecond())) {
                this.rpcServer.configActivated(((GetConfigContext)delayed.getFirst()).applicationId());
            }
        }
    }

    private boolean isSentinelConfigRequest(JRTServerConfigRequest request) {
        return request.getConfigKey().getName().equals(SentinelConfig.getDefName()) && request.getConfigKey().getNamespace().equals(SentinelConfig.getDefNamespace());
    }

    private static String printableVespaVersion(Optional<Version> vespaVersion) {
        return vespaVersion.map(Version::toFullString).orElse("LATEST");
    }

    private void returnEmpty(JRTServerConfigRequest request) {
        log.log(Level.FINE, () -> "Returning empty sentinel config for request from " + request.getClientHostName());
        ConfigPayload emptyPayload = ConfigPayload.fromInstance((ConfigInstance)new SentinelConfig.Builder().build());
        SlimeConfigResponse config = SlimeConfigResponse.fromConfigPayload((ConfigPayload)emptyPayload, (long)0L, (boolean)false, (PayloadChecksums)PayloadChecksums.fromPayload((Payload)Payload.from((ConfigPayload)emptyPayload)));
        request.addOkResponse(request.payloadFromResponse((ConfigResponse)config), config.getGeneration(), false, config.getPayloadChecksums());
        this.respond(request);
    }

    static boolean logDebug(Trace trace) {
        return trace.shouldTrace(9) || log.isLoggable(Level.FINE);
    }

    private void debugLog(Trace trace, String message) {
        if (GetConfigProcessor.logDebug(trace)) {
            log.log(Level.FINE, () -> this.logPre + message);
            trace.trace(9, this.logPre + message);
        }
    }
}

