/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.server.http;

import com.yahoo.container.jdisc.HttpResponse;
import com.yahoo.slime.Cursor;
import com.yahoo.slime.JsonFormat;
import com.yahoo.slime.Slime;
import java.io.IOException;
import java.io.OutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;

public class HttpErrorResponse
extends HttpResponse {
    private static final Logger log = Logger.getLogger(HttpErrorResponse.class.getName());
    private final Slime slime = new Slime();

    public HttpErrorResponse(int code, String errorType, String msg) {
        super(code);
        Cursor root = this.slime.setObject();
        root.setString("error-code", errorType);
        root.setString("message", msg);
        if (code != 200) {
            log.log(Level.INFO, "Returning response with response code " + code + ", error-code:" + errorType + ", message=" + msg);
        }
    }

    public static HttpErrorResponse notFoundError(String msg) {
        return new HttpErrorResponse(404, ErrorCode.NOT_FOUND.name(), msg);
    }

    public static HttpErrorResponse internalServerError(String msg) {
        return new HttpErrorResponse(500, ErrorCode.INTERNAL_SERVER_ERROR.name(), msg);
    }

    public static HttpErrorResponse invalidApplicationPackage(String msg) {
        return new HttpErrorResponse(400, ErrorCode.INVALID_APPLICATION_PACKAGE.name(), msg);
    }

    public static HttpErrorResponse nodeAllocationFailure(String msg) {
        return new HttpErrorResponse(400, ErrorCode.NODE_ALLOCATION_FAILURE.name(), msg);
    }

    public static HttpErrorResponse badRequest(String msg) {
        return new HttpErrorResponse(400, ErrorCode.BAD_REQUEST.name(), msg);
    }

    public static HttpErrorResponse conflictWhenActivating(String msg) {
        return new HttpErrorResponse(409, ErrorCode.ACTIVATION_CONFLICT.name(), msg);
    }

    public static HttpErrorResponse methodNotAllowed(String msg) {
        return new HttpErrorResponse(405, ErrorCode.METHOD_NOT_ALLOWED.name(), msg);
    }

    public static HttpResponse unknownVespaVersion(String message) {
        return new HttpErrorResponse(400, ErrorCode.UNKNOWN_VESPA_VERSION.name(), message);
    }

    public static HttpResponse requestTimeout(String message) {
        return new HttpErrorResponse(408, ErrorCode.REQUEST_TIMEOUT.name(), message);
    }

    public static HttpErrorResponse applicationLockFailure(String msg) {
        return new HttpErrorResponse(500, ErrorCode.APPLICATION_LOCK_FAILURE.name(), msg);
    }

    public static HttpErrorResponse parentHostNotReady(String msg) {
        return new HttpErrorResponse(409, ErrorCode.PARENT_HOST_NOT_READY.name(), msg);
    }

    public static HttpErrorResponse certificateNotReady(String msg) {
        return new HttpErrorResponse(409, ErrorCode.CERTIFICATE_NOT_READY.name(), msg);
    }

    public static HttpErrorResponse configNotConverged(String msg) {
        return new HttpErrorResponse(409, ErrorCode.CONFIG_NOT_CONVERGED.name(), msg);
    }

    public static HttpErrorResponse loadBalancerNotReady(String msg) {
        return new HttpErrorResponse(409, ErrorCode.LOAD_BALANCER_NOT_READY.name(), msg);
    }

    public static HttpResponse reindexingStatusUnavailable(String msg) {
        return new HttpErrorResponse(409, ErrorCode.REINDEXING_STATUS_UNAVAILABLE.name(), msg);
    }

    public void render(OutputStream stream) throws IOException {
        new JsonFormat(true).encode(stream, this.slime);
    }

    public String getContentType() {
        return "application/json";
    }

    public static enum ErrorCode {
        APPLICATION_LOCK_FAILURE,
        BAD_REQUEST,
        ACTIVATION_CONFLICT,
        INTERNAL_SERVER_ERROR,
        INVALID_APPLICATION_PACKAGE,
        METHOD_NOT_ALLOWED,
        NOT_FOUND,
        NODE_ALLOCATION_FAILURE,
        REQUEST_TIMEOUT,
        UNKNOWN_VESPA_VERSION,
        PARENT_HOST_NOT_READY,
        CERTIFICATE_NOT_READY,
        LOAD_BALANCER_NOT_READY,
        CONFIG_NOT_CONVERGED,
        REINDEXING_STATUS_UNAVAILABLE;

    }
}

