/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.server.session;

import com.yahoo.cloud.config.ConfigserverConfig;
import com.yahoo.component.Version;
import com.yahoo.component.Vtag;
import com.yahoo.concurrent.UncheckedTimeoutException;
import com.yahoo.config.FileReference;
import com.yahoo.config.application.ValidationProcessor;
import com.yahoo.config.application.XmlPreProcessor;
import com.yahoo.config.application.api.ApplicationMetaData;
import com.yahoo.config.application.api.ApplicationPackage;
import com.yahoo.config.application.api.DeployLogger;
import com.yahoo.config.application.api.DeploymentInstanceSpec;
import com.yahoo.config.application.api.FileRegistry;
import com.yahoo.config.application.api.xml.DeploymentSpecXmlReader;
import com.yahoo.config.model.api.ConfigDefinitionRepo;
import com.yahoo.config.model.api.ContainerEndpoint;
import com.yahoo.config.model.api.EndpointCertificateMetadata;
import com.yahoo.config.model.api.EndpointCertificateSecrets;
import com.yahoo.config.model.api.FileDistribution;
import com.yahoo.config.model.api.Quota;
import com.yahoo.config.model.api.TenantSecretStore;
import com.yahoo.config.provision.AllocatedHosts;
import com.yahoo.config.provision.ApplicationId;
import com.yahoo.config.provision.AthenzDomain;
import com.yahoo.config.provision.CloudAccount;
import com.yahoo.config.provision.DockerImage;
import com.yahoo.config.provision.InstanceName;
import com.yahoo.config.provision.Tags;
import com.yahoo.config.provision.Zone;
import com.yahoo.container.jdisc.secretstore.SecretStore;
import com.yahoo.net.HostName;
import com.yahoo.path.Path;
import com.yahoo.text.XML;
import com.yahoo.vespa.config.server.ConfigServerSpec;
import com.yahoo.vespa.config.server.TimeoutBudget;
import com.yahoo.vespa.config.server.application.ApplicationSet;
import com.yahoo.vespa.config.server.configchange.ConfigChangeActions;
import com.yahoo.vespa.config.server.deploy.ZooKeeperDeployer;
import com.yahoo.vespa.config.server.filedistribution.FileDistributionFactory;
import com.yahoo.vespa.config.server.host.HostValidator;
import com.yahoo.vespa.config.server.http.InvalidApplicationException;
import com.yahoo.vespa.config.server.modelfactory.AllocatedHostsFromAllModels;
import com.yahoo.vespa.config.server.modelfactory.ModelFactoryRegistry;
import com.yahoo.vespa.config.server.modelfactory.PreparedModelsBuilder;
import com.yahoo.vespa.config.server.provision.HostProvisionerProvider;
import com.yahoo.vespa.config.server.session.PrepareParams;
import com.yahoo.vespa.config.server.session.SessionZooKeeperClient;
import com.yahoo.vespa.config.server.tenant.ContainerEndpointsCache;
import com.yahoo.vespa.config.server.tenant.EndpointCertificateMetadataStore;
import com.yahoo.vespa.config.server.tenant.EndpointCertificateRetriever;
import com.yahoo.vespa.config.server.tenant.TenantRepository;
import com.yahoo.vespa.curator.Curator;
import com.yahoo.vespa.flags.FlagSource;
import com.yahoo.vespa.model.application.validation.BundleValidator;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.security.cert.X509Certificate;
import java.time.Instant;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.jar.JarFile;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.zip.ZipException;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.xml.sax.SAXException;

public class SessionPreparer {
    private static final Logger log = Logger.getLogger(SessionPreparer.class.getName());
    private final ModelFactoryRegistry modelFactoryRegistry;
    private final FileDistributionFactory fileDistributionFactory;
    private final HostProvisionerProvider hostProvisionerProvider;
    private final ConfigserverConfig configserverConfig;
    private final ConfigDefinitionRepo configDefinitionRepo;
    private final Curator curator;
    private final Zone zone;
    private final SecretStore secretStore;
    private final FlagSource flagSource;
    private final ExecutorService executor;

    public SessionPreparer(ModelFactoryRegistry modelFactoryRegistry, FileDistributionFactory fileDistributionFactory, ExecutorService executor, HostProvisionerProvider hostProvisionerProvider, ConfigserverConfig configserverConfig, ConfigDefinitionRepo configDefinitionRepo, Curator curator, Zone zone, FlagSource flagSource, SecretStore secretStore) {
        this.modelFactoryRegistry = modelFactoryRegistry;
        this.fileDistributionFactory = fileDistributionFactory;
        this.hostProvisionerProvider = hostProvisionerProvider;
        this.configserverConfig = configserverConfig;
        this.configDefinitionRepo = configDefinitionRepo;
        this.curator = curator;
        this.zone = zone;
        this.secretStore = secretStore;
        this.flagSource = flagSource;
        this.executor = executor;
    }

    ExecutorService getExecutor() {
        return this.executor;
    }

    public PrepareResult prepare(HostValidator<ApplicationId> hostValidator, DeployLogger logger, PrepareParams params, Optional<ApplicationSet> activeApplicationSet, Instant now, File serverDbSessionDir, ApplicationPackage applicationPackage, SessionZooKeeperClient sessionZooKeeperClient) {
        ApplicationId applicationId = params.getApplicationId();
        Preparation preparation = new Preparation(hostValidator, logger, params, activeApplicationSet, TenantRepository.getTenantPath(applicationId.tenant()), serverDbSessionDir, applicationPackage, sessionZooKeeperClient);
        preparation.preprocess();
        try {
            AllocatedHosts allocatedHosts = preparation.buildModels(now);
            preparation.makeResult(allocatedHosts);
            if (!params.isDryRun()) {
                FileReference fileReference = preparation.startDistributionOfApplicationPackage();
                preparation.writeStateZK(fileReference);
                preparation.writeEndpointCertificateMetadataZK();
                preparation.writeContainerEndpointsZK();
            }
            log.log(Level.FINE, () -> "time used " + params.getTimeoutBudget().timesUsed() + " : " + applicationId);
            return preparation.result();
        }
        catch (IllegalArgumentException e) {
            if (e instanceof InvalidApplicationException) {
                throw e;
            }
            throw new InvalidApplicationException("Invalid application package", e);
        }
    }

    private void writeStateToZooKeeper(SessionZooKeeperClient zooKeeperClient, ApplicationPackage applicationPackage, ApplicationId applicationId, FileReference fileReference, Optional<DockerImage> dockerImageRepository, Version vespaVersion, DeployLogger deployLogger, Map<Version, FileRegistry> fileRegistryMap, AllocatedHosts allocatedHosts, Optional<AthenzDomain> athenzDomain, Optional<Quota> quota, List<TenantSecretStore> tenantSecretStores, List<X509Certificate> operatorCertificates, Optional<CloudAccount> cloudAccount) {
        ZooKeeperDeployer zkDeployer = zooKeeperClient.createDeployer(deployLogger);
        try {
            zkDeployer.deploy(applicationPackage, fileRegistryMap, allocatedHosts);
            zooKeeperClient.writeApplicationId(applicationId);
            zooKeeperClient.writeApplicationPackageReference(Optional.of(fileReference));
            zooKeeperClient.writeVespaVersion(vespaVersion);
            zooKeeperClient.writeDockerImageRepository(dockerImageRepository);
            zooKeeperClient.writeAthenzDomain(athenzDomain);
            zooKeeperClient.writeQuota(quota);
            zooKeeperClient.writeTenantSecretStores(tenantSecretStores);
            zooKeeperClient.writeOperatorCertificates(operatorCertificates);
            zooKeeperClient.writeCloudAccount(cloudAccount);
        }
        catch (IOException | RuntimeException e) {
            zkDeployer.cleanup();
            throw new RuntimeException("Error preparing session", e);
        }
    }

    private class Preparation {
        final DeployLogger logger;
        final PrepareParams params;
        final ApplicationId applicationId;
        final Optional<DockerImage> dockerImageRepository;
        final Version vespaVersion;
        final ContainerEndpointsCache containerEndpointsCache;
        final List<ContainerEndpoint> containerEndpoints;
        private final EndpointCertificateMetadataStore endpointCertificateMetadataStore;
        private final Optional<EndpointCertificateMetadata> endpointCertificateMetadata;
        private final Optional<AthenzDomain> athenzDomain;
        private final ApplicationPackage applicationPackage;
        private final SessionZooKeeperClient sessionZooKeeperClient;
        private ApplicationPackage preprocessedApplicationPackage;
        private List<PreparedModelsBuilder.PreparedModelResult> modelResultList;
        private PrepareResult prepareResult;
        private final PreparedModelsBuilder preparedModelsBuilder;
        private final FileRegistry fileRegistry;

        Preparation(HostValidator<ApplicationId> hostValidator, DeployLogger logger, PrepareParams params, Optional<ApplicationSet> currentActiveApplicationSet, Path tenantPath, File serverDbSessionDir, ApplicationPackage applicationPackage, SessionZooKeeperClient sessionZooKeeperClient) {
            this.logger = logger;
            this.params = params;
            this.applicationPackage = applicationPackage;
            this.sessionZooKeeperClient = sessionZooKeeperClient;
            this.applicationId = params.getApplicationId();
            this.dockerImageRepository = params.dockerImageRepository();
            this.vespaVersion = params.vespaVersion().orElse(Vtag.currentVersion);
            this.containerEndpointsCache = new ContainerEndpointsCache(tenantPath, SessionPreparer.this.curator);
            this.endpointCertificateMetadataStore = new EndpointCertificateMetadataStore(SessionPreparer.this.curator, tenantPath);
            EndpointCertificateRetriever endpointCertificateRetriever = new EndpointCertificateRetriever(SessionPreparer.this.secretStore);
            this.endpointCertificateMetadata = params.endpointCertificateMetadata();
            Optional<EndpointCertificateSecrets> endpointCertificateSecrets = this.endpointCertificateMetadata.or(() -> this.endpointCertificateMetadataStore.readEndpointCertificateMetadata(this.applicationId)).flatMap(endpointCertificateRetriever::readEndpointCertificateSecrets);
            this.containerEndpoints = this.readEndpointsIfNull(params.containerEndpoints());
            this.athenzDomain = params.athenzDomain();
            this.fileRegistry = SessionPreparer.this.fileDistributionFactory.createFileRegistry(serverDbSessionDir);
            this.preparedModelsBuilder = new PreparedModelsBuilder(SessionPreparer.this.modelFactoryRegistry, SessionPreparer.this.flagSource, SessionPreparer.this.secretStore, this.containerEndpoints, endpointCertificateSecrets, SessionPreparer.this.configDefinitionRepo, this.fileRegistry, SessionPreparer.this.executor, SessionPreparer.this.hostProvisionerProvider, SessionPreparer.this.curator, hostValidator, logger, params, currentActiveApplicationSet, SessionPreparer.this.configserverConfig, SessionPreparer.this.zone);
        }

        void checkTimeout(String step) {
            TimeoutBudget timeoutBudget = this.params.getTimeoutBudget();
            if (!timeoutBudget.hasTimeLeft(step)) {
                String used = timeoutBudget.timesUsed();
                throw new UncheckedTimeoutException("prepare timed out " + used + " after " + step + " step (timeout " + timeoutBudget.timeout() + "): " + this.applicationId);
            }
        }

        FileReference startDistributionOfApplicationPackage() {
            FileReference fileReference = this.fileRegistry.addApplicationPackage();
            FileDistribution fileDistribution = SessionPreparer.this.fileDistributionFactory.createFileDistribution();
            log.log(Level.FINE, () -> "Ask other config servers to download application package for " + this.applicationId + " (" + fileReference + ")");
            ConfigServerSpec.fromConfig(SessionPreparer.this.configserverConfig).stream().filter(spec -> !spec.getHostName().equals(HostName.getLocalhost())).forEach(spec -> fileDistribution.startDownload(spec.getHostName(), spec.getConfigServerPort(), Set.of(fileReference)));
            this.checkTimeout("startDistributionOfApplicationPackage");
            return fileReference;
        }

        void preprocess() {
            try {
                this.validateXmlFeatures(this.applicationPackage, this.logger);
                this.preprocessedApplicationPackage = this.applicationPackage.preprocess(SessionPreparer.this.zone, this.logger);
            }
            catch (IOException | RuntimeException e) {
                throw new IllegalArgumentException("Error preprocessing application package for " + this.applicationId + ", session " + this.sessionZooKeeperClient.sessionId(), e);
            }
            this.checkTimeout("preprocess");
        }

        private void validateXmlFeatures(ApplicationPackage applicationPackage, DeployLogger logger) {
            Stream<java.nio.file.Path> paths;
            File applicationPackageDir = applicationPackage.getFileReference(Path.fromString((String)"."));
            File servicesXml = applicationPackage.getFileReference(Path.fromString((String)"services.xml"));
            File hostsXml = applicationPackage.getFileReference(Path.fromString((String)"hosts.xml"));
            ApplicationMetaData meta = applicationPackage.getMetaData();
            InstanceName instance = meta.getApplicationId().instance();
            Tags tags = applicationPackage.getDeployment().map(arg_0 -> ((DeploymentSpecXmlReader)new DeploymentSpecXmlReader(false)).read(arg_0)).flatMap(spec -> spec.instance(instance)).map(DeploymentInstanceSpec::tags).orElse(Tags.empty());
            if (servicesXml.exists()) {
                this.vespaPreprocess(applicationPackageDir.getAbsoluteFile(), servicesXml, meta, tags);
            }
            if (hostsXml.exists()) {
                this.vespaPreprocess(applicationPackageDir.getAbsoluteFile(), hostsXml, meta, tags);
            }
            if (SessionPreparer.this.zone.system().isPublic()) {
                try {
                    paths = Files.find(applicationPackageDir.getAbsoluteFile().toPath(), Integer.MAX_VALUE, (path, attr) -> attr.isRegularFile() && path.getFileName().toString().matches(".*\\.[Xx][Mm][Ll]"), new FileVisitOption[0]);
                    try {
                        paths.filter(p -> !p.equals(servicesXml.getAbsoluteFile().toPath()) && !p.equals(hostsXml.getAbsoluteFile().toPath())).forEach(xmlPath -> {
                            try {
                                new ValidationProcessor().process(XML.getDocument((File)xmlPath.toFile()));
                            }
                            catch (IOException | TransformerException e) {
                                throw new RuntimeException(e);
                            }
                        });
                    }
                    finally {
                        if (paths != null) {
                            paths.close();
                        }
                    }
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            try {
                paths = Files.find(applicationPackageDir.getAbsoluteFile().toPath(), Integer.MAX_VALUE, (path, attr) -> attr.isRegularFile() && path.getFileName().toString().matches(".*\\.[Jj][Aa][Rr]"), new FileVisitOption[0]);
                try {
                    paths.forEach(jarPath -> {
                        try {
                            new BundleValidator().getPomXmlContent(logger, new JarFile(jarPath.toFile())).ifPresent(pom -> {
                                try {
                                    new ValidationProcessor().process(pom);
                                }
                                catch (IOException | TransformerException e) {
                                    throw new RuntimeException(e);
                                }
                            });
                        }
                        catch (ZipException zipException) {
                        }
                        catch (IOException e) {
                            throw new RuntimeException(e);
                        }
                    });
                }
                finally {
                    if (paths != null) {
                        paths.close();
                    }
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        void vespaPreprocess(File appDir, File inputXml, ApplicationMetaData metaData, Tags tags) {
            try {
                InstanceName instance = metaData.getApplicationId().instance();
                new XmlPreProcessor(appDir, inputXml, instance, SessionPreparer.this.zone.environment(), SessionPreparer.this.zone.region(), tags).run();
            }
            catch (IOException | ParserConfigurationException | TransformerException | SAXException e) {
                throw new RuntimeException(e);
            }
        }

        AllocatedHosts buildModels(Instant now) {
            AllocatedHostsFromAllModels allocatedHosts = new AllocatedHostsFromAllModels();
            this.modelResultList = this.preparedModelsBuilder.buildModels(this.applicationId, this.dockerImageRepository, this.vespaVersion, this.preprocessedApplicationPackage, allocatedHosts, now);
            this.checkTimeout("build models");
            return allocatedHosts.toAllocatedHosts();
        }

        void makeResult(AllocatedHosts allocatedHosts) {
            this.prepareResult = new PrepareResult(allocatedHosts, this.modelResultList);
            this.checkTimeout("making result from models");
        }

        void writeStateZK(FileReference filereference) {
            log.log(Level.FINE, "Writing application package state to zookeeper");
            SessionPreparer.this.writeStateToZooKeeper(this.sessionZooKeeperClient, this.preprocessedApplicationPackage, this.applicationId, filereference, this.dockerImageRepository, this.vespaVersion, this.logger, this.prepareResult.getFileRegistries(), this.prepareResult.allocatedHosts(), this.athenzDomain, this.params.quota(), this.params.tenantSecretStores(), this.params.operatorCertificates(), this.params.cloudAccount());
            this.checkTimeout("write state to zookeeper");
        }

        void writeEndpointCertificateMetadataZK() {
            this.endpointCertificateMetadata.ifPresent(metadata -> this.endpointCertificateMetadataStore.writeEndpointCertificateMetadata(this.applicationId, (EndpointCertificateMetadata)metadata));
            this.checkTimeout("write endpoint certificate metadata to zookeeper");
        }

        void writeContainerEndpointsZK() {
            this.containerEndpointsCache.write(this.applicationId, this.containerEndpoints);
            this.checkTimeout("write container endpoints to zookeeper");
        }

        PrepareResult result() {
            return this.prepareResult;
        }

        private List<ContainerEndpoint> readEndpointsIfNull(List<ContainerEndpoint> endpoints) {
            if (endpoints == null) {
                endpoints = this.containerEndpointsCache.read(this.applicationId);
            }
            return List.copyOf(endpoints);
        }
    }

    static class PrepareResult {
        private final AllocatedHosts allocatedHosts;
        private final List<PreparedModelsBuilder.PreparedModelResult> results;

        public PrepareResult(AllocatedHosts allocatedHosts, List<PreparedModelsBuilder.PreparedModelResult> results) {
            this.allocatedHosts = allocatedHosts;
            this.results = List.copyOf(results);
        }

        public List<PreparedModelsBuilder.PreparedModelResult> asList() {
            return this.results;
        }

        public AllocatedHosts allocatedHosts() {
            return this.allocatedHosts;
        }

        public Map<Version, FileRegistry> getFileRegistries() {
            return this.results.stream().collect(Collectors.toMap(prepareResult -> prepareResult.version, prepareResult -> prepareResult.fileRegistry));
        }

        public ConfigChangeActions getConfigChangeActions() {
            return new ConfigChangeActions(this.results.stream().map(result -> result.actions).flatMap(Collection::stream).toList());
        }
    }

    private static final class ReconciliatedHostAllocations {
        public ReconciliatedHostAllocations(List<PreparedModelsBuilder.PreparedModelResult> results) {
        }
    }
}

