/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.server.metrics;

import ai.vespa.util.http.hc5.VespaHttpClientBuilder;
import com.yahoo.concurrent.DaemonThreadFactory;
import com.yahoo.metrics.ContainerMetrics;
import com.yahoo.slime.Cursor;
import com.yahoo.slime.Inspector;
import com.yahoo.slime.Slime;
import com.yahoo.slime.SlimeUtils;
import com.yahoo.vespa.config.server.metrics.ClusterInfo;
import com.yahoo.vespa.config.server.metrics.DeploymentMetricsAggregator;
import com.yahoo.yolean.Exceptions;
import java.io.IOException;
import java.net.URI;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.OptionalDouble;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.hc.client5.http.classic.methods.HttpGet;
import org.apache.hc.client5.http.config.RequestConfig;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.CloseableHttpResponse;
import org.apache.hc.client5.http.impl.io.PoolingHttpClientConnectionManager;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.io.entity.EntityUtils;
import org.apache.hc.core5.util.TimeValue;
import org.apache.hc.core5.util.Timeout;

public class ClusterDeploymentMetricsRetriever {
    private static final Logger log = Logger.getLogger(ClusterDeploymentMetricsRetriever.class.getName());
    private static final String VESPA_CONTAINER = "vespa.container";
    private static final String VESPA_QRSERVER = "vespa.qrserver";
    private static final String VESPA_DISTRIBUTOR = "vespa.distributor";
    private static final String VESPA_CONTAINER_CLUSTERCONTROLLER = "vespa.container-clustercontroller";
    private static final List<String> WANTED_METRIC_SERVICES = List.of("vespa.container", "vespa.qrserver", "vespa.distributor", "vespa.container-clustercontroller");
    private static final ExecutorService executor = Executors.newFixedThreadPool(10, (ThreadFactory)new DaemonThreadFactory("cluster-deployment-metrics-retriever-"));
    private static final CloseableHttpClient httpClient = VespaHttpClientBuilder.create(registry -> new PoolingHttpClientConnectionManager(registry, null, null, TimeValue.ofMinutes((long)1L))).setDefaultRequestConfig(RequestConfig.custom().setConnectionRequestTimeout(Timeout.ofSeconds((long)60L)).setConnectTimeout(Timeout.ofSeconds((long)10L)).setResponseTimeout(Timeout.ofSeconds((long)10L)).build()).build();

    public Map<ClusterInfo, DeploymentMetricsAggregator> requestMetricsGroupedByCluster(Collection<URI> hosts) {
        ConcurrentHashMap<ClusterInfo, DeploymentMetricsAggregator> clusterMetricsMap = new ConcurrentHashMap<ClusterInfo, DeploymentMetricsAggregator>();
        long startTime = System.currentTimeMillis();
        List<Callable> jobs = hosts.stream().map(hostUri -> () -> {
            try {
                ClusterDeploymentMetricsRetriever.getHostMetrics(hostUri, clusterMetricsMap);
            }
            catch (Exception e) {
                log.log(Level.FINE, e, () -> "Failed to download metrics: " + e.getMessage());
            }
            return null;
        }).toList();
        try {
            executor.invokeAll(jobs, 1L, TimeUnit.MINUTES);
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Failed to retrieve metrics in time: " + e.getMessage(), e);
        }
        log.log(Level.FINE, () -> String.format("Metric retrieval for %d nodes took %d milliseconds", hosts.size(), System.currentTimeMillis() - startTime));
        return clusterMetricsMap;
    }

    private static void getHostMetrics(URI hostURI, Map<ClusterInfo, DeploymentMetricsAggregator> clusterMetricsMap) {
        Slime responseBody = ClusterDeploymentMetricsRetriever.doMetricsRequest(hostURI);
        Cursor error = responseBody.get().field("error_message");
        if (error.valid()) {
            log.info("Failed to retrieve metrics from " + hostURI + ": " + error.asString());
        }
        Cursor services = responseBody.get().field("services");
        services.traverse((i, servicesInspector) -> ClusterDeploymentMetricsRetriever.parseService(servicesInspector, clusterMetricsMap));
    }

    private static void parseService(Inspector service, Map<ClusterInfo, DeploymentMetricsAggregator> clusterMetricsMap) {
        String serviceName = service.field("name").asString();
        if (!WANTED_METRIC_SERVICES.contains(serviceName)) {
            return;
        }
        service.field("metrics").traverse((i, metric) -> ClusterDeploymentMetricsRetriever.addMetricsToAggregator(serviceName, metric, clusterMetricsMap));
    }

    private static void addMetricsToAggregator(String serviceName, Inspector metric, Map<ClusterInfo, DeploymentMetricsAggregator> clusterMetricsMap) {
        Inspector values = metric.field("values");
        ClusterInfo clusterInfo = ClusterDeploymentMetricsRetriever.getClusterInfoFromDimensions(metric.field("dimensions"));
        Supplier<DeploymentMetricsAggregator> aggregator = () -> clusterMetricsMap.computeIfAbsent(clusterInfo, c -> new DeploymentMetricsAggregator());
        switch (serviceName) {
            case "vespa.container": {
                ClusterDeploymentMetricsRetriever.optionalDouble(values.field("query_latency.sum")).ifPresent(qlSum -> ((DeploymentMetricsAggregator)aggregator.get()).addContainerLatency(qlSum, values.field("query_latency.count").asDouble()));
                ClusterDeploymentMetricsRetriever.optionalDouble(values.field("feed.latency.sum")).ifPresent(flSum -> ((DeploymentMetricsAggregator)aggregator.get()).addFeedLatency(flSum, values.field("feed.latency.count").asDouble()));
                break;
            }
            case "vespa.qrserver": {
                ClusterDeploymentMetricsRetriever.optionalDouble(values.field("query_latency.sum")).ifPresent(qlSum -> ((DeploymentMetricsAggregator)aggregator.get()).addQrLatency(qlSum, values.field("query_latency.count").asDouble()));
                break;
            }
            case "vespa.distributor": {
                ClusterDeploymentMetricsRetriever.optionalDouble(values.field("vds.distributor.docsstored.average")).ifPresent(docCount -> ((DeploymentMetricsAggregator)aggregator.get()).addDocumentCount(docCount));
                break;
            }
            case "vespa.container-clustercontroller": {
                ClusterDeploymentMetricsRetriever.optionalDouble(values.field(ContainerMetrics.CLUSTER_CONTROLLER_RESOURCE_USAGE_MAX_MEMORY_UTILIZATION.max())).ifPresent(memoryUtil -> ((DeploymentMetricsAggregator)aggregator.get()).addMemoryUsage(memoryUtil, values.field(ContainerMetrics.CLUSTER_CONTROLLER_RESOURCE_USAGE_MEMORY_LIMIT.last()).asDouble()).addDiskUsage(values.field(ContainerMetrics.CLUSTER_CONTROLLER_RESOURCE_USAGE_MAX_DISK_UTILIZATION.max()).asDouble(), values.field(ContainerMetrics.CLUSTER_CONTROLLER_RESOURCE_USAGE_DISK_LIMIT.last()).asDouble()));
            }
        }
    }

    private static ClusterInfo getClusterInfoFromDimensions(Inspector dimensions) {
        return new ClusterInfo(dimensions.field("clusterid").asString(), dimensions.field("clustertype").asString());
    }

    private static Slime doMetricsRequest(URI hostURI) {
        Slime slime;
        block8: {
            HttpGet get = new HttpGet(hostURI);
            CloseableHttpResponse response = httpClient.execute((ClassicHttpRequest)get);
            try {
                byte[] body = EntityUtils.toByteArray((HttpEntity)response.getEntity());
                slime = SlimeUtils.jsonToSlime((byte[])body);
                if (response == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    log.info("Was unable to fetch metrics from " + hostURI + " : " + Exceptions.toMessageString((Throwable)e));
                    return new Slime();
                }
            }
            response.close();
        }
        return slime;
    }

    private static OptionalDouble optionalDouble(Inspector field) {
        return field.valid() ? OptionalDouble.of(field.asDouble()) : OptionalDouble.empty();
    }
}

