/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.server.application;

import com.yahoo.component.Version;
import com.yahoo.config.model.api.HostInfo;
import com.yahoo.config.provision.ApplicationId;
import com.yahoo.vespa.config.server.application.Application;
import com.yahoo.vespa.config.server.application.VersionDoesNotExistException;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;

public final class ApplicationSet {
    private final Version latestVersion;
    private final ApplicationId applicationId;
    private final long generation;
    private final HashMap<Version, Application> applications = new HashMap();

    private ApplicationSet(List<Application> applications) {
        if (applications.isEmpty()) {
            throw new IllegalArgumentException("application list cannot be empty");
        }
        Application firstApp = applications.get(0);
        this.applicationId = firstApp.getId();
        this.generation = firstApp.getApplicationGeneration();
        for (Application application : applications) {
            this.applications.put(application.getVespaVersion(), application);
            ApplicationId applicationId = application.getId();
            if (!applicationId.equals((Object)this.applicationId)) {
                throw new IllegalArgumentException("Trying to create set with different application ids (" + application + " and " + this.applicationId + ")");
            }
            if (application.getApplicationGeneration().equals(this.generation)) continue;
            throw new IllegalArgumentException("Trying to create set with different generations (" + this.generation + " and " + this.generation + ")");
        }
        this.latestVersion = (Version)this.applications.keySet().stream().max(Version::compareTo).get();
    }

    public Application getForVersionOrLatest(Optional<Version> optionalVersion, Instant now) {
        Version version = optionalVersion.orElse(this.latestVersion);
        return this.resolveForVersion(version, now).orElseThrow(() -> new VersionDoesNotExistException(this.applicationId + " has no model for Vespa version " + version));
    }

    private Optional<Application> resolveForVersion(Version vespaVersion, Instant now) {
        Application application = this.applications.get(vespaVersion);
        if (application != null) {
            return Optional.of(application);
        }
        Application latest = this.applications.get(this.latestVersion);
        if (latest.getModel().allowModelVersionMismatch(now)) {
            return Optional.of(latest);
        }
        return Optional.empty();
    }

    public Optional<Application> get(Version version) {
        return Optional.ofNullable(this.applications.get(version));
    }

    public ApplicationId getId() {
        return this.applicationId;
    }

    public static ApplicationSet fromList(List<Application> applications) {
        return new ApplicationSet(applications);
    }

    public static ApplicationSet from(Application application) {
        return ApplicationSet.fromList(List.of(application));
    }

    public Collection<String> getAllHosts() {
        return this.applications.values().stream().flatMap(app -> app.getModel().getHosts().stream().map(HostInfo::getHostname)).toList();
    }

    public void updateHostMetrics() {
        for (Application application : this.applications.values()) {
            application.updateHostMetrics(application.getModel().getHosts().size());
        }
    }

    public long getApplicationGeneration() {
        return this.generation;
    }

    List<Application> getAllApplications() {
        return new ArrayList<Application>(this.applications.values());
    }

    public List<Version> getAllVersions(ApplicationId applicationId) {
        return this.applications.values().stream().filter(application -> application.getId().equals((Object)applicationId)).map(Application::getVespaVersion).sorted().toList();
    }
}

