/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.server.deploy;

import com.yahoo.component.Version;
import com.yahoo.config.application.api.ApplicationFile;
import com.yahoo.config.application.api.ApplicationMetaData;
import com.yahoo.config.application.api.ApplicationPackage;
import com.yahoo.config.application.api.DeployLogger;
import com.yahoo.config.application.api.FileRegistry;
import com.yahoo.config.application.api.UnparsedConfigDefinition;
import com.yahoo.config.model.application.provider.PreGeneratedFileRegistry;
import com.yahoo.config.provision.AllocatedHosts;
import com.yahoo.config.provision.serialization.AllocatedHostsSerializer;
import com.yahoo.io.reader.NamedReader;
import com.yahoo.log.LogLevel;
import com.yahoo.path.Path;
import com.yahoo.text.Utf8;
import com.yahoo.vespa.config.ConfigDefinitionKey;
import com.yahoo.vespa.config.server.zookeeper.ConfigCurator;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.IOUtils;

public class ZooKeeperClient {
    private final ConfigCurator configCurator;
    private final DeployLogger logger;
    private final boolean logFine;
    private final Path rootPath;
    static final ApplicationFile.PathFilter xmlFilter = new ApplicationFile.PathFilter(){

        public boolean accept(Path path) {
            return path.getName().endsWith(".xml");
        }
    };

    public ZooKeeperClient(ConfigCurator configCurator, DeployLogger logger, boolean logFine, Path rootPath) {
        this.configCurator = configCurator;
        this.logger = logger;
        this.logFine = logFine;
        this.rootPath = rootPath;
    }

    void setupZooKeeper() {
        int retries = 5;
        try {
            while (retries > 0) {
                try {
                    this.logFine("Setting up ZooKeeper nodes for this application");
                    this.createZooKeeperNodes();
                    break;
                }
                catch (RuntimeException e) {
                    this.logger.log(LogLevel.FINE, "ZK init failed, retrying: " + e);
                    if (--retries == 0) {
                        throw e;
                    }
                    Thread.sleep(100L);
                }
            }
        }
        catch (Exception e) {
            throw new IllegalStateException("Unable to initialize vespa model writing to config server(s) " + System.getProperty("configsources") + "\nPlease ensure that cloudconfig_server is started on the config server node(s), and check the vespa log for configserver errors. ", e);
        }
    }

    private void createZooKeeperNodes() {
        if (!this.configCurator.exists(this.rootPath.getAbsolute())) {
            this.configCurator.createNode(this.rootPath.getAbsolute());
        }
        for (String subPath : Arrays.asList("/defconfigs", "/userdefconfigs", "/userapp", "fileregistry")) {
            this.configCurator.createNode(this.getZooKeeperAppPath(null).getAbsolute(), subPath.replaceFirst("/", ""));
        }
    }

    void write(ApplicationPackage app) {
        this.logFine("Feeding application config into ZooKeeper");
        try {
            this.logFine("zk operations: " + this.configCurator.getNumberOfOperations());
            this.logFine("Feeding user def files into ZooKeeper");
            this.writeUserDefs(app);
            this.logFine("zk operations: " + this.configCurator.getNumberOfOperations());
            this.logFine("Feeding application package into ZooKeeper");
            this.writeSomeOf(app);
            this.writeSearchDefinitions(app);
            this.writeUserIncludeDirs(app, app.getUserIncludeDirs());
            this.logFine("zk operations: " + this.configCurator.getNumberOfOperations());
            this.logFine("zk read operations: " + this.configCurator.getNumberOfReadOperations());
            this.logFine("zk write operations: " + this.configCurator.getNumberOfWriteOperations());
            this.logFine("Feeding sd from docproc bundle into ZooKeeper");
            this.logFine("zk operations: " + this.configCurator.getNumberOfOperations());
            this.logFine("Write application metadata into ZooKeeper");
            this.write(app.getMetaData());
            this.logFine("zk operations: " + this.configCurator.getNumberOfOperations());
        }
        catch (Exception e) {
            throw new IllegalStateException("Unable to write vespa model to config server(s) " + System.getProperty("configsources") + "\nPlease ensure that cloudconfig_server is started on the config server node(s), and check the vespa log for configserver errors. ", e);
        }
    }

    private void writeSearchDefinitions(ApplicationPackage app) throws IOException {
        Collection sds = app.getSearchDefinitions();
        if (sds.isEmpty()) {
            return;
        }
        Path zkPath = this.getZooKeeperAppPath("/userapp").append(ApplicationPackage.SEARCH_DEFINITIONS_DIR);
        this.configCurator.createNode(zkPath.getAbsolute());
        this.writeDir(app.getFile(ApplicationPackage.SEARCH_DEFINITIONS_DIR), zkPath, false);
        for (NamedReader sd : sds) {
            String name = sd.getName();
            Reader reader = sd.getReader();
            String data = com.yahoo.io.IOUtils.readAll((Reader)reader);
            reader.close();
            this.configCurator.putData(zkPath.getAbsolute(), name, data);
        }
    }

    void writeSomeOf(ApplicationPackage app) throws IOException {
        ApplicationFile.PathFilter srFilter = new ApplicationFile.PathFilter(){

            public boolean accept(Path path) {
                return path.getName().endsWith(".sr");
            }
        };
        this.writeFile(app.getFile(Path.fromString((String)"services.xml")), this.getZooKeeperAppPath("/userapp"));
        this.writeFile(app.getFile(Path.fromString((String)"hosts.xml")), this.getZooKeeperAppPath("/userapp"));
        this.writeFile(app.getFile(Path.fromString((String)ApplicationPackage.DEPLOYMENT_FILE.getName())), this.getZooKeeperAppPath("/userapp"));
        this.writeFile(app.getFile(Path.fromString((String)ApplicationPackage.VALIDATION_OVERRIDES.getName())), this.getZooKeeperAppPath("/userapp"));
        this.writeDir(app.getFile(ApplicationPackage.RULES_DIR), this.getZooKeeperAppPath("/userapp").append(ApplicationPackage.RULES_DIR), srFilter, true);
        this.writeDir(app.getFile(ApplicationPackage.QUERY_PROFILES_DIR), this.getZooKeeperAppPath("/userapp").append(ApplicationPackage.QUERY_PROFILES_DIR), xmlFilter, true);
        this.writeDir(app.getFile(ApplicationPackage.PAGE_TEMPLATES_DIR), this.getZooKeeperAppPath("/userapp").append(ApplicationPackage.PAGE_TEMPLATES_DIR), xmlFilter, true);
        this.writeDir(app.getFile(Path.fromString((String)"search/chains")), this.getZooKeeperAppPath("/userapp").append("search/chains"), xmlFilter, true);
        this.writeDir(app.getFile(Path.fromString((String)"docproc/chains")), this.getZooKeeperAppPath("/userapp").append("docproc/chains"), xmlFilter, true);
        this.writeDir(app.getFile(Path.fromString((String)"routing/tables")), this.getZooKeeperAppPath("/userapp").append("routing/tables"), xmlFilter, true);
        this.writeDir(app.getFile(ApplicationPackage.MODELS_GENERATED_REPLICATED_DIR), this.getZooKeeperAppPath("/userapp").append(ApplicationPackage.MODELS_GENERATED_REPLICATED_DIR), true);
    }

    private void writeDir(ApplicationFile file, Path zooKeeperAppPath, boolean recurse) throws IOException {
        this.writeDir(file, zooKeeperAppPath, new ApplicationFile.PathFilter(){

            public boolean accept(Path path) {
                return true;
            }
        }, recurse);
    }

    private void writeDir(ApplicationFile dir, Path path, ApplicationFile.PathFilter filenameFilter, boolean recurse) throws IOException {
        if (!dir.isDirectory()) {
            this.logger.log(LogLevel.FINE, dir.getPath().getAbsolute() + " is not a directory. Not feeding the files into ZooKeeper.");
            return;
        }
        for (ApplicationFile file : this.listFiles(dir, filenameFilter)) {
            String name = file.getPath().getName();
            if (name.startsWith(".") || "CVS".equals(name)) continue;
            if (file.isDirectory()) {
                this.configCurator.createNode(path.append(name).getAbsolute());
                if (!recurse) continue;
                this.writeDir(file, path.append(name), filenameFilter, recurse);
                continue;
            }
            this.writeFile(file, path);
        }
    }

    private List<ApplicationFile> listFiles(ApplicationFile dir, ApplicationFile.PathFilter filter) {
        List rawList = dir.listFiles();
        ArrayList<ApplicationFile> ret = new ArrayList<ApplicationFile>();
        if (rawList != null) {
            for (ApplicationFile f : rawList) {
                if (f.isDirectory()) {
                    ret.add(f);
                    continue;
                }
                if (!filter.accept(f.getPath())) continue;
                ret.add(f);
            }
        }
        return ret;
    }

    private void writeFile(ApplicationFile file, Path zkPath) throws IOException {
        if (!file.exists()) {
            return;
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try (InputStream inputStream = file.createInputStream();){
            IOUtils.copy((InputStream)inputStream, (OutputStream)baos);
            baos.flush();
            this.configCurator.putData(zkPath.append(file.getPath().getName()).getAbsolute(), baos.toByteArray());
        }
    }

    private void writeUserIncludeDirs(ApplicationPackage applicationPackage, List<String> userIncludeDirs) throws IOException {
        for (String userInclude : userIncludeDirs) {
            ApplicationFile dir = applicationPackage.getFile(Path.fromString((String)userInclude));
            List files = dir.listFiles();
            if (files == null || files.isEmpty()) {
                this.configCurator.createNode(this.getZooKeeperAppPath("/userapp/" + userInclude).getAbsolute());
            }
            this.writeDir(dir, this.getZooKeeperAppPath("/userapp/" + userInclude), xmlFilter, true);
        }
    }

    private void writeUserDefs(ApplicationPackage applicationPackage) {
        Map configDefs = applicationPackage.getAllExistingConfigDefs();
        for (Map.Entry entry : configDefs.entrySet()) {
            ConfigDefinitionKey key = (ConfigDefinitionKey)entry.getKey();
            String contents = ((UnparsedConfigDefinition)entry.getValue()).getUnparsedContent();
            this.writeConfigDefinition(key.getName(), key.getNamespace(), this.getZooKeeperAppPath("/userdefconfigs").getAbsolute(), contents);
            this.writeConfigDefinition(key.getName(), key.getNamespace(), this.getZooKeeperAppPath("/defconfigs").getAbsolute(), contents);
        }
        this.logger.log(LogLevel.FINE, configDefs.size() + " user config definitions");
    }

    private void writeConfigDefinition(String name, String namespace, String path, String data) {
        this.configCurator.putDefData(namespace + "." + name, path, Utf8.toBytes((String)data));
    }

    private void write(Version vespaVersion, FileRegistry fileRegistry) {
        this.logFine("Feeding file registry data into ZooKeeper");
        String exportedRegistry = PreGeneratedFileRegistry.exportRegistry((FileRegistry)fileRegistry);
        this.configCurator.putData(this.getZooKeeperAppPath(null).append("fileregistry").getAbsolute(), vespaVersion.toFullString(), exportedRegistry);
    }

    private void write(ApplicationMetaData metaData) {
        this.configCurator.putData(this.getZooKeeperAppPath("/meta").getAbsolute(), metaData.asJsonString());
    }

    void cleanupZooKeeper() {
        this.logFine("Exception occurred. Cleaning up ZooKeeper");
        try {
            for (String subPath : Arrays.asList("/defconfigs", "/userdefconfigs", "/userapp")) {
                this.configCurator.deleteRecurse(this.getZooKeeperAppPath(null).append(subPath).getAbsolute());
            }
        }
        catch (Exception e) {
            this.logger.log(LogLevel.WARNING, "Could not clean up in zookeeper");
        }
    }

    Path getZooKeeperAppPath(String trailingPath) {
        if (trailingPath != null) {
            return this.rootPath.append(trailingPath);
        }
        return this.rootPath;
    }

    void logFine(String msg) {
        if (this.logFine) {
            this.logger.log(LogLevel.FINE, msg);
        }
    }

    public void write(AllocatedHosts hosts) throws IOException {
        this.configCurator.putData(this.rootPath.append("allocatedHosts").getAbsolute(), AllocatedHostsSerializer.toJson((AllocatedHosts)hosts));
    }

    public void write(Map<Version, FileRegistry> fileRegistryMap) {
        for (Map.Entry<Version, FileRegistry> versionFileRegistryEntry : fileRegistryMap.entrySet()) {
            this.write(versionFileRegistryEntry.getKey(), versionFileRegistryEntry.getValue());
        }
    }
}

