/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.server.deploy;

import com.yahoo.component.Version;
import com.yahoo.config.application.api.DeployLogger;
import com.yahoo.config.provision.HostFilter;
import com.yahoo.config.provision.Provisioner;
import com.yahoo.log.LogLevel;
import com.yahoo.transaction.NestedTransaction;
import com.yahoo.transaction.Transaction;
import com.yahoo.vespa.config.server.ActivationConflictException;
import com.yahoo.vespa.config.server.ApplicationRepository;
import com.yahoo.vespa.config.server.TimeoutBudget;
import com.yahoo.vespa.config.server.http.InternalServerException;
import com.yahoo.vespa.config.server.session.LocalSession;
import com.yahoo.vespa.config.server.session.PrepareParams;
import com.yahoo.vespa.config.server.session.Session;
import com.yahoo.vespa.config.server.session.SilentDeployLogger;
import com.yahoo.vespa.config.server.tenant.Tenant;
import com.yahoo.vespa.curator.Lock;
import java.time.Clock;
import java.time.Duration;
import java.util.Collection;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Deployment
implements com.yahoo.config.provision.Deployment {
    private static final Logger log = Logger.getLogger(Deployment.class.getName());
    private final LocalSession session;
    private final ApplicationRepository applicationRepository;
    private final Optional<Provisioner> hostProvisioner;
    private final Tenant tenant;
    private final Duration timeout;
    private final Clock clock;
    private final DeployLogger logger = new SilentDeployLogger();
    private final Version version;
    private final boolean isBootstrap;
    private boolean prepared = false;
    private boolean validate;
    private boolean ignoreSessionStaleFailure = false;

    private Deployment(LocalSession session, ApplicationRepository applicationRepository, Optional<Provisioner> hostProvisioner, Tenant tenant, Duration timeout, Clock clock, boolean prepared, boolean validate, Version version, boolean isBootstrap) {
        this.session = session;
        this.applicationRepository = applicationRepository;
        this.hostProvisioner = hostProvisioner;
        this.tenant = tenant;
        this.timeout = timeout;
        this.clock = clock;
        this.prepared = prepared;
        this.validate = validate;
        this.version = version;
        this.isBootstrap = isBootstrap;
    }

    public static Deployment unprepared(LocalSession session, ApplicationRepository applicationRepository, Optional<Provisioner> hostProvisioner, Tenant tenant, Duration timeout, Clock clock, boolean validate, Version version, boolean isBootstrap) {
        return new Deployment(session, applicationRepository, hostProvisioner, tenant, timeout, clock, false, validate, version, isBootstrap);
    }

    public static Deployment prepared(LocalSession session, ApplicationRepository applicationRepository, Optional<Provisioner> hostProvisioner, Tenant tenant, Duration timeout, Clock clock, boolean isBootstrap) {
        return new Deployment(session, applicationRepository, hostProvisioner, tenant, timeout, clock, true, true, session.getVespaVersion(), isBootstrap);
    }

    public void setIgnoreSessionStaleFailure(boolean ignoreSessionStaleFailure) {
        this.ignoreSessionStaleFailure = ignoreSessionStaleFailure;
    }

    public void prepare() {
        if (this.prepared) {
            return;
        }
        TimeoutBudget timeoutBudget = new TimeoutBudget(this.clock, this.timeout);
        this.session.prepare(this.logger, new PrepareParams.Builder().applicationId(this.session.getApplicationId()).timeoutBudget(timeoutBudget).ignoreValidationErrors(!this.validate).vespaVersion(this.version.toString()).isBootstrap(this.isBootstrap).build(), Optional.empty(), this.tenant.getPath(), this.clock.instant());
        this.prepared = true;
    }

    public void activate() {
        if (!this.prepared) {
            this.prepare();
        }
        TimeoutBudget timeoutBudget = new TimeoutBudget(this.clock, this.timeout);
        try (Lock lock = this.tenant.getApplicationRepo().lock(this.session.getApplicationId());){
            this.validateSessionStatus(this.session);
            NestedTransaction transaction = new NestedTransaction();
            transaction.add(this.deactivateCurrentActivateNew(this.applicationRepository.getActiveSession(this.session.getApplicationId()), this.session, this.ignoreSessionStaleFailure), new Class[0]);
            if (this.hostProvisioner.isPresent()) {
                this.hostProvisioner.get().activate(transaction, this.session.getApplicationId(), (Collection)this.session.getAllocatedHosts().getHosts());
            }
            transaction.commit();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new InternalServerException("Error activating application", e);
        }
        this.session.waitUntilActivated(timeoutBudget);
        log.log(LogLevel.INFO, this.session.logPre() + "Session " + this.session.getSessionId() + " activated successfully using " + (this.hostProvisioner.isPresent() ? this.hostProvisioner.get() : "no host provisioner") + ". Config generation " + this.session.getMetaData().getGeneration());
    }

    public void restart(HostFilter filter) {
        this.hostProvisioner.get().restart(this.session.getApplicationId(), filter);
    }

    public LocalSession session() {
        return this.session;
    }

    private long validateSessionStatus(LocalSession localSession) {
        long sessionId = localSession.getSessionId();
        if (Session.Status.NEW.equals((Object)localSession.getStatus())) {
            throw new IllegalStateException(localSession.logPre() + "Session " + sessionId + " is not prepared");
        }
        if (Session.Status.ACTIVATE.equals((Object)localSession.getStatus())) {
            throw new IllegalStateException(localSession.logPre() + "Session " + sessionId + " is already active");
        }
        return sessionId;
    }

    private Transaction deactivateCurrentActivateNew(LocalSession active, LocalSession prepared, boolean ignoreStaleSessionFailure) {
        Transaction transaction = prepared.createActivateTransaction();
        if (this.isValidSession(active)) {
            this.checkIfActiveHasChanged(prepared, active, ignoreStaleSessionFailure);
            this.checkIfActiveIsNewerThanSessionToBeActivated(prepared.getSessionId(), active.getSessionId());
            transaction.add(active.createDeactivateTransaction().operations());
        }
        return transaction;
    }

    private boolean isValidSession(LocalSession session) {
        return session != null;
    }

    private void checkIfActiveHasChanged(LocalSession session, LocalSession currentActiveSession, boolean ignoreStaleSessionFailure) {
        long activeSessionAtCreate = session.getActiveSessionAtCreate();
        log.log((Level)LogLevel.DEBUG, currentActiveSession.logPre() + "active session id at create time=" + activeSessionAtCreate);
        if (activeSessionAtCreate == 0L) {
            return;
        }
        long sessionId = session.getSessionId();
        long currentActiveSessionSessionId = currentActiveSession.getSessionId();
        log.log((Level)LogLevel.DEBUG, currentActiveSession.logPre() + "sessionId=" + sessionId + ", current active session=" + currentActiveSessionSessionId);
        if (currentActiveSession.isNewerThan(activeSessionAtCreate) && currentActiveSessionSessionId != sessionId) {
            String errMsg = currentActiveSession.logPre() + "Cannot activate session " + sessionId + " because the currently active session (" + currentActiveSessionSessionId + ") has changed since session " + sessionId + " was created (was " + activeSessionAtCreate + " at creation time)";
            if (ignoreStaleSessionFailure) {
                log.warning(errMsg + " (Continuing because of force.)");
            } else {
                throw new ActivationConflictException(errMsg);
            }
        }
    }

    private void checkIfActiveIsNewerThanSessionToBeActivated(long sessionId, long currentActiveSessionId) {
        if (sessionId < currentActiveSessionId) {
            throw new ActivationConflictException("It is not possible to activate session " + sessionId + ", because it is older than current active session (" + currentActiveSessionId + ")");
        }
    }
}

