/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.server;

import com.google.inject.Inject;
import com.yahoo.cloud.config.ConfigserverConfig;
import com.yahoo.component.Version;
import com.yahoo.component.Vtag;
import com.yahoo.config.FileReference;
import com.yahoo.config.application.api.ApplicationFile;
import com.yahoo.config.application.api.ApplicationMetaData;
import com.yahoo.config.application.api.DeployLogger;
import com.yahoo.config.model.api.HostInfo;
import com.yahoo.config.model.api.ServiceInfo;
import com.yahoo.config.model.api.container.ContainerServiceType;
import com.yahoo.config.provision.ApplicationId;
import com.yahoo.config.provision.Deployer;
import com.yahoo.config.provision.Environment;
import com.yahoo.config.provision.HostFilter;
import com.yahoo.config.provision.InfraDeployer;
import com.yahoo.config.provision.Provisioner;
import com.yahoo.config.provision.RegionName;
import com.yahoo.config.provision.SystemName;
import com.yahoo.config.provision.TenantName;
import com.yahoo.config.provision.Zone;
import com.yahoo.container.jdisc.HttpResponse;
import com.yahoo.io.IOUtils;
import com.yahoo.log.LogLevel;
import com.yahoo.path.Path;
import com.yahoo.slime.Slime;
import com.yahoo.transaction.NestedTransaction;
import com.yahoo.transaction.Transaction;
import com.yahoo.vespa.config.server.NotFoundException;
import com.yahoo.vespa.config.server.TimeoutBudget;
import com.yahoo.vespa.config.server.application.Application;
import com.yahoo.vespa.config.server.application.ApplicationSet;
import com.yahoo.vespa.config.server.application.CompressedApplicationInputStream;
import com.yahoo.vespa.config.server.application.ConfigConvergenceChecker;
import com.yahoo.vespa.config.server.application.FileDistributionStatus;
import com.yahoo.vespa.config.server.application.HttpProxy;
import com.yahoo.vespa.config.server.application.TenantApplications;
import com.yahoo.vespa.config.server.configchange.ConfigChangeActions;
import com.yahoo.vespa.config.server.configchange.RefeedActions;
import com.yahoo.vespa.config.server.configchange.RestartActions;
import com.yahoo.vespa.config.server.deploy.DeployHandlerLogger;
import com.yahoo.vespa.config.server.deploy.Deployment;
import com.yahoo.vespa.config.server.deploy.InfraDeployerProvider;
import com.yahoo.vespa.config.server.http.LogRetriever;
import com.yahoo.vespa.config.server.http.SimpleHttpFetcher;
import com.yahoo.vespa.config.server.http.v2.MetricsResponse;
import com.yahoo.vespa.config.server.http.v2.PrepareResult;
import com.yahoo.vespa.config.server.metrics.ClusterInfo;
import com.yahoo.vespa.config.server.metrics.MetricsAggregator;
import com.yahoo.vespa.config.server.metrics.MetricsRetriever;
import com.yahoo.vespa.config.server.provision.HostProvisionerProvider;
import com.yahoo.vespa.config.server.session.LocalSession;
import com.yahoo.vespa.config.server.session.LocalSessionRepo;
import com.yahoo.vespa.config.server.session.PrepareParams;
import com.yahoo.vespa.config.server.session.RemoteSession;
import com.yahoo.vespa.config.server.session.RemoteSessionRepo;
import com.yahoo.vespa.config.server.session.Session;
import com.yahoo.vespa.config.server.session.SessionFactory;
import com.yahoo.vespa.config.server.session.SilentDeployLogger;
import com.yahoo.vespa.config.server.tenant.Rotations;
import com.yahoo.vespa.config.server.tenant.Tenant;
import com.yahoo.vespa.config.server.tenant.TenantRepository;
import com.yahoo.vespa.curator.Lock;
import com.yahoo.vespa.orchestrator.Orchestrator;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;

public class ApplicationRepository
implements Deployer {
    private static final Logger log = Logger.getLogger(ApplicationRepository.class.getName());
    private final TenantRepository tenantRepository;
    private final Optional<Provisioner> hostProvisioner;
    private final Optional<InfraDeployer> infraDeployer;
    private final ConfigConvergenceChecker convergeChecker;
    private final HttpProxy httpProxy;
    private final Clock clock;
    private final DeployLogger logger = new SilentDeployLogger();
    private final ConfigserverConfig configserverConfig;
    private final FileDistributionStatus fileDistributionStatus;
    private final Orchestrator orchestrator;
    private final LogRetriever logRetriever;

    @Inject
    public ApplicationRepository(TenantRepository tenantRepository, HostProvisionerProvider hostProvisionerProvider, InfraDeployerProvider infraDeployerProvider, ConfigConvergenceChecker configConvergenceChecker, HttpProxy httpProxy, ConfigserverConfig configserverConfig, Orchestrator orchestrator) {
        this(tenantRepository, hostProvisionerProvider.getHostProvisioner(), infraDeployerProvider.getInfraDeployer(), configConvergenceChecker, httpProxy, configserverConfig, orchestrator, new LogRetriever(), new FileDistributionStatus(), Clock.systemUTC());
    }

    public ApplicationRepository(TenantRepository tenantRepository, Provisioner hostProvisioner, Orchestrator orchestrator, Clock clock) {
        this(tenantRepository, hostProvisioner, orchestrator, new ConfigserverConfig(new ConfigserverConfig.Builder()), new LogRetriever(), clock);
    }

    public ApplicationRepository(TenantRepository tenantRepository, Provisioner hostProvisioner, Orchestrator orchestrator, LogRetriever logRetriever, Clock clock) {
        this(tenantRepository, hostProvisioner, orchestrator, new ConfigserverConfig(new ConfigserverConfig.Builder()), logRetriever, clock);
    }

    public ApplicationRepository(TenantRepository tenantRepository, Provisioner hostProvisioner, Orchestrator orchestrator, ConfigserverConfig configserverConfig, LogRetriever logRetriever, Clock clock) {
        this(tenantRepository, Optional.of(hostProvisioner), Optional.empty(), new ConfigConvergenceChecker(), new HttpProxy(new SimpleHttpFetcher()), configserverConfig, orchestrator, logRetriever, new FileDistributionStatus(), clock);
    }

    private ApplicationRepository(TenantRepository tenantRepository, Optional<Provisioner> hostProvisioner, Optional<InfraDeployer> infraDeployer, ConfigConvergenceChecker configConvergenceChecker, HttpProxy httpProxy, ConfigserverConfig configserverConfig, Orchestrator orchestrator, LogRetriever logRetriever, FileDistributionStatus fileDistributionStatus, Clock clock) {
        this.tenantRepository = tenantRepository;
        this.hostProvisioner = hostProvisioner;
        this.infraDeployer = infraDeployer;
        this.convergeChecker = configConvergenceChecker;
        this.httpProxy = httpProxy;
        this.configserverConfig = configserverConfig;
        this.orchestrator = orchestrator;
        this.logRetriever = logRetriever;
        this.fileDistributionStatus = fileDistributionStatus;
        this.clock = clock;
    }

    public PrepareResult prepare(Tenant tenant, long sessionId, PrepareParams prepareParams, Instant now) {
        this.validateThatLocalSessionIsNotActive(tenant, sessionId);
        LocalSession session = this.getLocalSession(tenant, sessionId);
        ApplicationId applicationId = prepareParams.getApplicationId();
        Optional<ApplicationSet> currentActiveApplicationSet = this.getCurrentActiveApplicationSet(tenant, applicationId);
        Slime deployLog = this.createDeployLog();
        DeployHandlerLogger logger = new DeployHandlerLogger(deployLog.get().setArray("log"), prepareParams.isVerbose(), applicationId);
        ConfigChangeActions actions = session.prepare(logger, prepareParams, currentActiveApplicationSet, tenant.getPath(), now);
        ApplicationRepository.logConfigChangeActions(actions, logger);
        log.log(LogLevel.INFO, TenantRepository.logPre(applicationId) + "Session " + sessionId + " prepared successfully. ");
        return new PrepareResult(sessionId, actions, deployLog);
    }

    public PrepareResult prepareAndActivate(Tenant tenant, long sessionId, PrepareParams prepareParams, boolean ignoreSessionStaleFailure, Instant now) {
        PrepareResult result = this.prepare(tenant, sessionId, prepareParams, now);
        this.activate(tenant, sessionId, prepareParams.getTimeoutBudget(), ignoreSessionStaleFailure);
        return result;
    }

    public PrepareResult deploy(CompressedApplicationInputStream in, PrepareParams prepareParams) {
        return this.deploy(in, prepareParams, false, this.clock.instant());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PrepareResult deploy(CompressedApplicationInputStream in, PrepareParams prepareParams, boolean ignoreSessionStaleFailure, Instant now) {
        PrepareResult prepareResult;
        File tempDir = com.google.common.io.Files.createTempDir();
        try {
            prepareResult = this.deploy(this.decompressApplication(in, tempDir), prepareParams, ignoreSessionStaleFailure, now);
        }
        finally {
            this.cleanupTempDirectory(tempDir);
        }
        return prepareResult;
    }

    public PrepareResult deploy(File applicationPackage, PrepareParams prepareParams) {
        return this.deploy(applicationPackage, prepareParams, false, Instant.now());
    }

    public PrepareResult deploy(File applicationPackage, PrepareParams prepareParams, boolean ignoreSessionStaleFailure, Instant now) {
        ApplicationId applicationId = prepareParams.getApplicationId();
        long sessionId = this.createSession(applicationId, prepareParams.getTimeoutBudget(), applicationPackage);
        Tenant tenant = this.tenantRepository.getTenant(applicationId.tenant());
        return this.prepareAndActivate(tenant, sessionId, prepareParams, ignoreSessionStaleFailure, now);
    }

    public Optional<com.yahoo.config.provision.Deployment> deployFromLocalActive(ApplicationId application) {
        return this.deployFromLocalActive(application, false);
    }

    public Optional<com.yahoo.config.provision.Deployment> deployFromLocalActive(ApplicationId application, boolean bootstrap) {
        return this.deployFromLocalActive(application, Duration.ofSeconds(this.configserverConfig.zookeeper().barrierTimeout()).plus(Duration.ofSeconds(5L)), bootstrap);
    }

    public Optional<com.yahoo.config.provision.Deployment> deployFromLocalActive(ApplicationId application, Duration timeout, boolean bootstrap) {
        Optional<com.yahoo.config.provision.Deployment> infraDeployment = this.infraDeployer.flatMap(d -> d.getDeployment(application));
        if (infraDeployment.isPresent()) {
            return infraDeployment;
        }
        Tenant tenant = this.tenantRepository.getTenant(application.tenant());
        if (tenant == null) {
            return Optional.empty();
        }
        LocalSession activeSession = this.getActiveSession(tenant, application);
        if (activeSession == null) {
            return Optional.empty();
        }
        TimeoutBudget timeoutBudget = new TimeoutBudget(this.clock, timeout);
        LocalSession newSession = tenant.getSessionFactory().createSessionFromExisting(activeSession, this.logger, true, timeoutBudget);
        tenant.getLocalSessionRepo().addSession(newSession);
        Version version = ApplicationRepository.decideVersion(application, this.zone().environment(), newSession.getVespaVersion(), bootstrap);
        return Optional.of(Deployment.unprepared(newSession, this, this.hostProvisioner, tenant, timeout, this.clock, false, version, bootstrap));
    }

    public Optional<Instant> lastDeployTime(ApplicationId application) {
        Tenant tenant = this.tenantRepository.getTenant(application.tenant());
        if (tenant == null) {
            return Optional.empty();
        }
        LocalSession activeSession = this.getActiveSession(tenant, application);
        if (activeSession == null) {
            return Optional.empty();
        }
        return Optional.of(Instant.ofEpochSecond(activeSession.getCreateTime()));
    }

    public ApplicationId activate(Tenant tenant, long sessionId, TimeoutBudget timeoutBudget, boolean ignoreSessionStaleFailure) {
        LocalSession localSession = this.getLocalSession(tenant, sessionId);
        Deployment deployment = this.deployFromPreparedSession(localSession, tenant, timeoutBudget.timeLeft());
        deployment.setIgnoreSessionStaleFailure(ignoreSessionStaleFailure);
        deployment.activate();
        return localSession.getApplicationId();
    }

    private Deployment deployFromPreparedSession(LocalSession session, Tenant tenant, Duration timeout) {
        return Deployment.prepared(session, this, this.hostProvisioner, tenant, timeout, this.clock, false);
    }

    public boolean delete(ApplicationId applicationId) {
        Tenant tenant = this.tenantRepository.getTenant(applicationId.tenant());
        if (tenant == null) {
            return false;
        }
        TenantApplications tenantApplications = tenant.getApplicationRepo();
        try (Lock lock = tenantApplications.lock(applicationId);){
            if (!tenantApplications.exists(applicationId)) {
                boolean bl = false;
                return bl;
            }
            boolean sessionDeleted = tenantApplications.activeSessionOf(applicationId).map(sessionId -> {
                RemoteSession remoteSession = this.getRemoteSession(tenant, (long)sessionId);
                remoteSession.createDeleteTransaction().commit();
                log.log(LogLevel.INFO, TenantRepository.logPre(applicationId) + "Waiting for session " + sessionId + " to be deleted");
                Duration waitTime = Duration.ofSeconds(60L);
                if (this.localSessionHasBeenDeleted(applicationId, (long)sessionId, waitTime)) {
                    log.log(LogLevel.INFO, TenantRepository.logPre(applicationId) + "Session " + sessionId + " deleted");
                    return true;
                }
                log.log((Level)LogLevel.ERROR, TenantRepository.logPre(applicationId) + "Session " + sessionId + " was not deleted (waited " + waitTime + ")");
                return false;
            }).orElse(true);
            NestedTransaction transaction = new NestedTransaction();
            transaction.add((Transaction)new Rotations(tenant.getCurator(), tenant.getPath()).delete(applicationId), new Class[0]);
            transaction.add((Transaction)tenantApplications.createDeleteTransaction(applicationId), new Class[0]);
            this.hostProvisioner.ifPresent(provisioner -> provisioner.remove(transaction, applicationId));
            transaction.onCommitted(() -> log.log(LogLevel.INFO, "Deleted " + applicationId));
            transaction.commit();
            boolean bl = sessionDeleted;
            return bl;
        }
    }

    public HttpResponse clusterControllerStatusPage(ApplicationId applicationId, String hostName, String pathSuffix) {
        String relativePath = "clustercontroller-status/" + pathSuffix;
        return this.httpProxy.get(this.getApplication(applicationId), hostName, ContainerServiceType.CLUSTERCONTROLLER_CONTAINER.serviceName, relativePath);
    }

    public Long getApplicationGeneration(ApplicationId applicationId) {
        return this.getApplication(applicationId).getApplicationGeneration();
    }

    public void restart(ApplicationId applicationId, HostFilter hostFilter) {
        this.hostProvisioner.ifPresent(provisioner -> provisioner.restart(applicationId, hostFilter));
    }

    public boolean isSuspended(ApplicationId application) {
        return this.orchestrator.getAllSuspendedApplications().contains(application);
    }

    public HttpResponse filedistributionStatus(ApplicationId applicationId, Duration timeout) {
        return this.fileDistributionStatus.status(this.getApplication(applicationId), timeout);
    }

    public Set<String> deleteUnusedFiledistributionReferences(File fileReferencesPath) {
        if (!fileReferencesPath.isDirectory()) {
            throw new RuntimeException(fileReferencesPath + " is not a directory");
        }
        HashSet fileReferencesInUse = new HashSet();
        this.listApplications().stream().map(this::getOptionalApplication).map(Optional::get).forEach(application -> fileReferencesInUse.addAll(application.getModel().fileReferences().stream().map(FileReference::value).collect(Collectors.toSet())));
        log.log((Level)LogLevel.DEBUG, "File references in use : " + fileReferencesInUse);
        HashSet fileReferencesOnDisk = new HashSet();
        File[] filesOnDisk = fileReferencesPath.listFiles();
        if (filesOnDisk != null) {
            fileReferencesOnDisk.addAll(Arrays.stream(filesOnDisk).map(File::getName).collect(Collectors.toSet()));
        }
        log.log((Level)LogLevel.DEBUG, "File references on disk (in " + fileReferencesPath + "): " + fileReferencesOnDisk);
        Instant instant = Instant.now().minus(Duration.ofDays(14L));
        Set<String> fileReferencesToDelete = fileReferencesOnDisk.stream().filter(fileReference -> !fileReferencesInUse.contains(fileReference)).filter(fileReference -> this.isFileLastModifiedBefore(new File(fileReferencesPath, (String)fileReference), instant)).collect(Collectors.toSet());
        if (fileReferencesToDelete.size() > 0) {
            log.log(LogLevel.INFO, "Will delete file references not in use: " + fileReferencesToDelete);
            fileReferencesToDelete.forEach(fileReference -> {
                File file = new File(fileReferencesPath, (String)fileReference);
                if (!IOUtils.recursiveDeleteDir((File)file)) {
                    log.log(LogLevel.WARNING, "Could not delete " + file.getAbsolutePath());
                }
            });
        }
        return fileReferencesToDelete;
    }

    public ApplicationFile getApplicationFileFromSession(TenantName tenantName, long sessionId, String path, LocalSession.Mode mode) {
        Tenant tenant = this.tenantRepository.getTenant(tenantName);
        return this.getLocalSession(tenant, sessionId).getApplicationFile(Path.fromString((String)path), mode);
    }

    private Application getApplication(ApplicationId applicationId) {
        return this.getApplication(applicationId, Optional.empty());
    }

    private Application getApplication(ApplicationId applicationId, Optional<Version> version) {
        try {
            Tenant tenant = this.tenantRepository.getTenant(applicationId.tenant());
            if (tenant == null) {
                throw new NotFoundException("Tenant '" + applicationId.tenant() + "' not found");
            }
            long sessionId = this.getSessionIdForApplication(tenant, applicationId);
            RemoteSession session = (RemoteSession)tenant.getRemoteSessionRepo().getSession(sessionId);
            return session.ensureApplicationLoaded().getForVersionOrLatest(version, this.clock.instant());
        }
        catch (NotFoundException e) {
            log.log(LogLevel.WARNING, "Failed getting application for '" + applicationId + "': " + e.getMessage());
            throw e;
        }
        catch (Exception e) {
            log.log(LogLevel.WARNING, "Failed getting application for '" + applicationId + "'", e);
            throw e;
        }
    }

    private Optional<Application> getOptionalApplication(ApplicationId applicationId) {
        try {
            return Optional.of(this.getApplication(applicationId));
        }
        catch (Exception e) {
            return Optional.empty();
        }
    }

    Set<ApplicationId> listApplications() {
        return this.tenantRepository.getAllTenants().stream().flatMap(tenant -> tenant.getApplicationRepo().activeApplications().stream()).collect(Collectors.toSet());
    }

    private boolean isFileLastModifiedBefore(File fileReference, Instant instant) {
        try {
            BasicFileAttributes fileAttributes = Files.readAttributes(fileReference.toPath(), BasicFileAttributes.class, new LinkOption[0]);
            return fileAttributes.lastModifiedTime().toInstant().isBefore(instant);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private boolean localSessionHasBeenDeleted(ApplicationId applicationId, long sessionId, Duration waitTime) {
        RemoteSessionRepo remoteSessionRepo = this.tenantRepository.getTenant(applicationId.tenant()).getRemoteSessionRepo();
        Instant end = Instant.now().plus(waitTime);
        do {
            if (remoteSessionRepo.getSession(sessionId) == null) {
                return true;
            }
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        } while (Instant.now().isBefore(end));
        return false;
    }

    public HttpResponse checkServiceForConfigConvergence(ApplicationId applicationId, String hostAndPort, URI uri, Duration timeout, Optional<Version> vespaVersion) {
        return this.convergeChecker.checkService(this.getApplication(applicationId, vespaVersion), hostAndPort, uri, timeout);
    }

    public HttpResponse servicesToCheckForConfigConvergence(ApplicationId applicationId, URI uri, Duration timeoutPerService, Optional<Version> vespaVersion) {
        return this.convergeChecker.servicesToCheck(this.getApplication(applicationId, vespaVersion), uri, timeoutPerService);
    }

    public HttpResponse getLogs(ApplicationId applicationId, Optional<String> hostname, String apiParams) {
        String logServerURI = this.getLogServerURI(applicationId, hostname) + apiParams;
        return this.logRetriever.getLogs(logServerURI);
    }

    public LocalSession getActiveSession(ApplicationId applicationId) {
        return this.getActiveSession(this.tenantRepository.getTenant(applicationId.tenant()), applicationId);
    }

    public long getSessionIdForApplication(ApplicationId applicationId) {
        Tenant tenant = this.tenantRepository.getTenant(applicationId.tenant());
        if (tenant == null) {
            throw new NotFoundException("Tenant '" + applicationId.tenant() + "' not found");
        }
        return this.getSessionIdForApplication(tenant, applicationId);
    }

    private long getSessionIdForApplication(Tenant tenant, ApplicationId applicationId) {
        TenantApplications applicationRepo = tenant.getApplicationRepo();
        if (applicationRepo == null) {
            throw new NotFoundException("Application repo for tenant '" + tenant.getName() + "' not found");
        }
        return applicationRepo.requireActiveSessionOf(applicationId);
    }

    public void validateThatRemoteSessionIsNotActive(Tenant tenant, long sessionId) {
        RemoteSession session = this.getRemoteSession(tenant, sessionId);
        if (Session.Status.ACTIVATE.equals((Object)session.getStatus())) {
            throw new IllegalStateException("Session is active: " + sessionId);
        }
    }

    public void validateThatRemoteSessionIsPrepared(Tenant tenant, long sessionId) {
        RemoteSession session = this.getRemoteSession(tenant, sessionId);
        if (!Session.Status.PREPARE.equals((Object)session.getStatus())) {
            throw new IllegalStateException("Session not prepared: " + sessionId);
        }
    }

    public long createSessionFromExisting(ApplicationId applicationId, DeployLogger logger, boolean internalRedeploy, TimeoutBudget timeoutBudget) {
        Tenant tenant = this.tenantRepository.getTenant(applicationId.tenant());
        LocalSessionRepo localSessionRepo = tenant.getLocalSessionRepo();
        SessionFactory sessionFactory = tenant.getSessionFactory();
        LocalSession fromSession = this.getExistingSession(tenant, applicationId);
        LocalSession session = sessionFactory.createSessionFromExisting(fromSession, logger, internalRedeploy, timeoutBudget);
        localSessionRepo.addSession(session);
        return session.getSessionId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long createSession(ApplicationId applicationId, TimeoutBudget timeoutBudget, InputStream in, String contentType) {
        long sessionId;
        File tempDir = com.google.common.io.Files.createTempDir();
        try {
            sessionId = this.createSession(applicationId, timeoutBudget, this.decompressApplication(in, contentType, tempDir));
        }
        finally {
            this.cleanupTempDirectory(tempDir);
        }
        return sessionId;
    }

    public long createSession(ApplicationId applicationId, TimeoutBudget timeoutBudget, File applicationDirectory) {
        Tenant tenant = this.tenantRepository.getTenant(applicationId.tenant());
        tenant.getApplicationRepo().createApplication(applicationId);
        LocalSessionRepo localSessionRepo = tenant.getLocalSessionRepo();
        SessionFactory sessionFactory = tenant.getSessionFactory();
        LocalSession session = sessionFactory.createSession(applicationDirectory, applicationId, timeoutBudget);
        localSessionRepo.addSession(session);
        return session.getSessionId();
    }

    public void deleteExpiredLocalSessions() {
        this.tenantRepository.getAllTenants().forEach(tenant -> tenant.getLocalSessionRepo().purgeOldSessions());
    }

    public int deleteExpiredRemoteSessions(Duration expiryTime) {
        return this.tenantRepository.getAllTenants().stream().map(tenant -> tenant.getRemoteSessionRepo().deleteExpiredSessions(expiryTime)).mapToInt(i -> i).sum();
    }

    public Set<TenantName> deleteUnusedTenants(Duration ttlForUnusedTenant, Instant now) {
        return this.tenantRepository.getAllTenantNames().stream().filter(tenantName -> this.activeApplications((TenantName)tenantName).isEmpty()).filter(tenantName -> !tenantName.equals((Object)TenantName.defaultName())).filter(tenantName -> !tenantName.equals((Object)TenantRepository.HOSTED_VESPA_TENANT)).filter(tenantName -> this.tenantRepository.getTenant((TenantName)tenantName).getCreatedTime().isBefore(now.minus(ttlForUnusedTenant))).peek(this.tenantRepository::deleteTenant).collect(Collectors.toSet());
    }

    public void deleteTenant(TenantName tenantName) {
        List<ApplicationId> activeApplications = this.activeApplications(tenantName);
        if (!activeApplications.isEmpty()) {
            throw new IllegalArgumentException("Cannot delete tenant '" + tenantName + "', it has active applications: " + activeApplications);
        }
        this.tenantRepository.deleteTenant(tenantName);
    }

    private List<ApplicationId> activeApplications(TenantName tenantName) {
        return this.tenantRepository.getTenant(tenantName).getApplicationRepo().activeApplications();
    }

    public MetricsResponse getMetrics(ApplicationId applicationId) {
        MetricsRetriever metricsRetriever = new MetricsRetriever();
        Collection<ClusterInfo> clusters = this.getClustersOfApplication(applicationId);
        LinkedHashMap<ClusterInfo, MetricsAggregator> clusterMetrics = new LinkedHashMap<ClusterInfo, MetricsAggregator>();
        clusters.forEach(cluster -> {
            MetricsAggregator metrics = metricsRetriever.requestMetricsForCluster((ClusterInfo)cluster);
            clusterMetrics.put((ClusterInfo)cluster, metrics);
        });
        return new MetricsResponse(200, applicationId, clusterMetrics);
    }

    public ApplicationMetaData getMetadataFromSession(Tenant tenant, long sessionId) {
        return this.getLocalSession(tenant, sessionId).getMetaData();
    }

    public ConfigserverConfig configserverConfig() {
        return this.configserverConfig;
    }

    private void validateThatLocalSessionIsNotActive(Tenant tenant, long sessionId) {
        LocalSession session = this.getLocalSession(tenant, sessionId);
        if (Session.Status.ACTIVATE.equals((Object)session.getStatus())) {
            throw new IllegalStateException("Session is active: " + sessionId);
        }
    }

    private LocalSession getLocalSession(Tenant tenant, long sessionId) {
        LocalSession session = (LocalSession)tenant.getLocalSessionRepo().getSession(sessionId);
        if (session == null) {
            throw new NotFoundException("Session " + sessionId + " was not found");
        }
        return session;
    }

    private RemoteSession getRemoteSession(Tenant tenant, long sessionId) {
        RemoteSession session = (RemoteSession)tenant.getRemoteSessionRepo().getSession(sessionId);
        if (session == null) {
            throw new NotFoundException("Session " + sessionId + " was not found");
        }
        return session;
    }

    private Optional<ApplicationSet> getCurrentActiveApplicationSet(Tenant tenant, ApplicationId appId) {
        Optional<ApplicationSet> currentActiveApplicationSet = Optional.empty();
        TenantApplications applicationRepo = tenant.getApplicationRepo();
        try {
            long currentActiveSessionId = applicationRepo.requireActiveSessionOf(appId);
            RemoteSession currentActiveSession = this.getRemoteSession(tenant, currentActiveSessionId);
            if (currentActiveSession != null) {
                currentActiveApplicationSet = Optional.ofNullable(currentActiveSession.ensureApplicationLoaded());
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return currentActiveApplicationSet;
    }

    private File decompressApplication(InputStream in, String contentType, File tempDir) {
        File file;
        block8: {
            CompressedApplicationInputStream application = CompressedApplicationInputStream.createFromCompressedStream(in, contentType);
            try {
                file = this.decompressApplication(application, tempDir);
                if (application == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (application != null) {
                        try {
                            application.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new IllegalArgumentException("Unable to decompress data in body", e);
                }
            }
            application.close();
        }
        return file;
    }

    private File decompressApplication(CompressedApplicationInputStream in, File tempDir) {
        try {
            return in.decompress(tempDir);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Unable to decompress stream", e);
        }
    }

    private void cleanupTempDirectory(File tempDir) {
        this.logger.log((Level)LogLevel.DEBUG, "Deleting tmp dir '" + tempDir + "'");
        if (!IOUtils.recursiveDeleteDir((File)tempDir)) {
            this.logger.log(LogLevel.WARNING, "Not able to delete tmp dir '" + tempDir + "'");
        }
    }

    private LocalSession getExistingSession(Tenant tenant, ApplicationId applicationId) {
        TenantApplications applicationRepo = tenant.getApplicationRepo();
        return this.getLocalSession(tenant, applicationRepo.requireActiveSessionOf(applicationId));
    }

    private LocalSession getActiveSession(Tenant tenant, ApplicationId applicationId) {
        TenantApplications applicationRepo = tenant.getApplicationRepo();
        if (applicationRepo.activeApplications().contains(applicationId)) {
            return (LocalSession)tenant.getLocalSessionRepo().getSession(applicationRepo.requireActiveSessionOf(applicationId));
        }
        return null;
    }

    private static void logConfigChangeActions(ConfigChangeActions actions, DeployLogger logger) {
        RefeedActions refeedActions;
        RestartActions restartActions = actions.getRestartActions();
        if (!restartActions.isEmpty()) {
            logger.log(Level.WARNING, "Change(s) between active and new application that require restart:\n" + restartActions.format());
        }
        if (!(refeedActions = actions.getRefeedActions()).isEmpty()) {
            boolean allAllowed = refeedActions.getEntries().stream().allMatch(RefeedActions.Entry::allowed);
            logger.log(allAllowed ? Level.INFO : Level.WARNING, "Change(s) between active and new application that may require re-feed:\n" + refeedActions.format());
        }
    }

    private String getLogServerURI(ApplicationId applicationId, Optional<String> hostname) {
        if (hostname.isPresent()) {
            if (TenantRepository.HOSTED_VESPA_TENANT.equals((Object)applicationId.tenant())) {
                return "http://" + hostname.get() + ":8080/logs";
            }
            throw new IllegalArgumentException("Only hostname paramater unsupported for application " + applicationId);
        }
        Application application = this.getApplication(applicationId);
        Collection hostInfos = application.getModel().getHosts();
        HostInfo logServerHostInfo = hostInfos.stream().filter(host -> host.getServices().stream().anyMatch(serviceInfo -> serviceInfo.getServiceType().equalsIgnoreCase("logserver"))).findFirst().orElseThrow(() -> new IllegalArgumentException("Could not find HostInfo for LogServer"));
        ServiceInfo serviceInfo = logServerHostInfo.getServices().stream().filter(service -> List.of(ContainerServiceType.LOGSERVER_CONTAINER.serviceName, ContainerServiceType.CONTAINER.serviceName).contains(service.getServiceType())).findFirst().orElseThrow(() -> new IllegalArgumentException("No container running on logserver host"));
        int port = this.servicePort(serviceInfo);
        return "http://" + logServerHostInfo.getHostname() + ":" + port + "/logs";
    }

    private int servicePort(ServiceInfo serviceInfo) {
        int port = serviceInfo.getPorts().stream().filter(portInfo -> portInfo.getTags().stream().anyMatch(tag -> tag.equalsIgnoreCase("http"))).findFirst().orElseThrow(() -> new IllegalArgumentException("Could not find HTTP port")).getPort();
        return port;
    }

    private Collection<ClusterInfo> getClustersOfApplication(ApplicationId applicationId) {
        Application application = this.getApplication(applicationId);
        HashMap clusterHosts = new HashMap();
        HashMap clusters = new HashMap();
        application.getModel().getHosts().stream().filter(host -> host.getServices().stream().noneMatch(serviceInfo -> serviceInfo.getServiceType().equalsIgnoreCase("logserver"))).forEach(hostInfo -> {
            log.info(hostInfo.getHostname() + ": " + hostInfo.getServices().stream().map(ServiceInfo::getServiceType).collect(Collectors.joining(", ")));
            ServiceInfo serviceInfo = hostInfo.getServices().stream().filter(service -> ContainerServiceType.METRICS_PROXY_CONTAINER.serviceName.equals(service.getServiceType())).findFirst().orElseThrow(() -> new IllegalArgumentException("Unable to find service " + ContainerServiceType.METRICS_PROXY_CONTAINER.serviceName.toString()));
            String clusterName = serviceInfo.getProperty("clusterid").orElse("");
            String clusterTypeString = serviceInfo.getProperty("clustertype").orElse("");
            if (!ClusterInfo.ClusterType.isValidType(clusterTypeString)) {
                return;
            }
            ClusterInfo.ClusterType clusterType = ClusterInfo.ClusterType.valueOf(clusterTypeString);
            URI host = URI.create("http://" + hostInfo.getHostname() + ":" + this.servicePort(serviceInfo) + "/metrics/v1/values?consumer=Vespa");
            clusterHosts.computeIfAbsent(clusterName, l -> new ArrayList()).add(host);
            clusters.computeIfAbsent(clusterName, c -> new ClusterInfo(clusterName, clusterType)).addHost(host);
        });
        return clusters.values();
    }

    static Version decideVersion(ApplicationId application, Environment environment, Version sessionVersion, boolean bootstrap) {
        if (environment.isManuallyDeployed() && sessionVersion.getMajor() == Vtag.currentVersion.getMajor() && !TenantRepository.HOSTED_VESPA_TENANT.equals((Object)application.tenant()) && !application.instance().isTester() && !bootstrap) {
            return Vtag.currentVersion;
        }
        return sessionVersion;
    }

    public Slime createDeployLog() {
        Slime deployLog = new Slime();
        deployLog.setObject();
        return deployLog;
    }

    public Zone zone() {
        return new Zone(SystemName.from((String)this.configserverConfig.system()), Environment.from((String)this.configserverConfig.environment()), RegionName.from((String)this.configserverConfig.region()));
    }
}

