/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.server.metrics;

import com.yahoo.slime.Cursor;
import com.yahoo.slime.Inspector;
import com.yahoo.slime.Slime;
import com.yahoo.vespa.config.SlimeUtils;
import com.yahoo.vespa.config.server.metrics.ClusterInfo;
import com.yahoo.vespa.config.server.metrics.MetricsAggregator;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.net.URI;
import java.time.Instant;
import java.util.logging.Logger;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.HttpClientBuilder;

public class MetricsRetriever {
    private static final Logger log = Logger.getLogger(MetricsRetriever.class.getName());
    private final HttpClient httpClient = HttpClientBuilder.create().build();

    public MetricsAggregator requestMetricsForCluster(ClusterInfo clusterInfo) {
        MetricsAggregator aggregator = new MetricsAggregator();
        clusterInfo.getHostnames().forEach(host -> this.getHostMetrics((URI)host, aggregator));
        return aggregator;
    }

    private void getHostMetrics(URI hostURI, MetricsAggregator metrics) {
        Slime responseBody = this.doMetricsRequest(hostURI);
        Cursor parseError = responseBody.get().field("error_message");
        if (parseError.valid()) {
            log.info("Failed to retrieve metrics from " + hostURI + ": " + parseError.asString());
        }
        Cursor services = responseBody.get().field("services");
        services.traverse((i, servicesInspector) -> this.parseService(servicesInspector, metrics));
    }

    private Slime doMetricsRequest(URI hostURI) {
        HttpGet get = new HttpGet(hostURI);
        try {
            HttpResponse response = this.httpClient.execute((HttpUriRequest)get);
            InputStream is = response.getEntity().getContent();
            Slime slime = SlimeUtils.jsonToSlime((byte[])is.readAllBytes());
            is.close();
            return slime;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private void parseService(Inspector service, MetricsAggregator metrics) {
        String serviceName = service.field("name").asString();
        Instant timestamp = Instant.ofEpochSecond(service.field("timestamp").asLong());
        metrics.setTimestamp(timestamp);
        service.field("metrics").traverse((i, m) -> {
            Inspector values = m.field("values");
            switch (serviceName) {
                case "container": {
                    metrics.addContainerLatency(values.field("query_latency.sum").asDouble(), values.field("query_latency.count").asDouble());
                    metrics.addFeedLatency(values.field("feed_latency.sum").asDouble(), values.field("feed_latency.count").asDouble());
                    break;
                }
                case "qrserver": {
                    metrics.addQrLatency(values.field("query_latency.sum").asDouble(), values.field("query_latency.count").asDouble());
                    break;
                }
                case "distributor": {
                    metrics.addDocumentCount(values.field("vds.distributor.docsstored.average").asDouble());
                }
            }
        });
    }
}

