/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.server.metrics;

import java.time.Instant;
import java.util.Optional;

public class MetricsAggregator {
    private LatencyMetrics feed;
    private LatencyMetrics qr;
    private LatencyMetrics container;
    private Double documentCount;
    private Instant timestamp;

    public MetricsAggregator addFeedLatency(double sum, double count) {
        this.feed = this.combineLatency(this.feed, sum, count);
        return this;
    }

    public MetricsAggregator addQrLatency(double sum, double count) {
        this.qr = this.combineLatency(this.qr, sum, count);
        return this;
    }

    public MetricsAggregator addContainerLatency(double sum, double count) {
        this.container = this.combineLatency(this.container, sum, count);
        return this;
    }

    public MetricsAggregator addDocumentCount(double count) {
        this.documentCount = (this.documentCount == null ? 0.0 : this.documentCount) + count;
        return this;
    }

    public MetricsAggregator setTimestamp(Instant timestamp) {
        this.timestamp = timestamp;
        return this;
    }

    public Optional<Double> aggregateFeedLatency() {
        return Optional.ofNullable(this.feed).map(m -> m.latencySum / m.latencyCount);
    }

    public Optional<Double> aggregateFeedRate() {
        return Optional.ofNullable(this.feed).map(m -> m.latencyCount / 60.0);
    }

    public Optional<Double> aggregateQueryLatency() {
        if (this.container == null && this.qr == null) {
            return Optional.empty();
        }
        LatencyMetrics c = Optional.ofNullable(this.container).orElseGet(() -> new LatencyMetrics());
        LatencyMetrics q = Optional.ofNullable(this.qr).orElseGet(() -> new LatencyMetrics());
        return Optional.of((c.latencySum + q.latencySum) / (c.latencyCount + q.latencyCount));
    }

    public Optional<Double> aggregateQueryRate() {
        if (this.container == null && this.qr == null) {
            return Optional.empty();
        }
        LatencyMetrics c = Optional.ofNullable(this.container).orElseGet(() -> new LatencyMetrics());
        LatencyMetrics q = Optional.ofNullable(this.qr).orElseGet(() -> new LatencyMetrics());
        return Optional.of((c.latencyCount + q.latencyCount) / 60.0);
    }

    public Optional<Double> aggregateDocumentCount() {
        return Optional.ofNullable(this.documentCount);
    }

    public Instant getTimestamp() {
        return this.timestamp;
    }

    private LatencyMetrics combineLatency(LatencyMetrics metricsOrNull, double sum, double count) {
        LatencyMetrics metrics = Optional.ofNullable(metricsOrNull).orElseGet(() -> new LatencyMetrics());
        metrics.latencyCount += count;
        metrics.latencySum += sum;
        return metrics;
    }

    private static class LatencyMetrics {
        double latencySum;
        double latencyCount;

        private LatencyMetrics() {
        }
    }
}

