/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.server.application;

import com.yahoo.config.provision.ApplicationId;
import com.yahoo.config.provision.TenantName;
import com.yahoo.path.Path;
import com.yahoo.slime.Cursor;
import com.yahoo.slime.Inspector;
import com.yahoo.slime.Slime;
import com.yahoo.slime.SlimeUtils;
import com.yahoo.text.Utf8;
import com.yahoo.transaction.Transaction;
import com.yahoo.vespa.config.server.application.ApplicationReindexing;
import com.yahoo.vespa.config.server.tenant.TenantRepository;
import com.yahoo.vespa.curator.Curator;
import com.yahoo.vespa.curator.Lock;
import com.yahoo.vespa.curator.transaction.CuratorOperations;
import com.yahoo.vespa.curator.transaction.CuratorTransaction;
import com.yahoo.yolean.Exceptions;
import java.time.Duration;
import java.time.Instant;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;

public class ApplicationCuratorDatabase {
    final TenantName tenant;
    final Path applicationsPath;
    final Path locksPath;
    private final Curator curator;

    public ApplicationCuratorDatabase(TenantName tenant, Curator curator) {
        this.tenant = tenant;
        this.applicationsPath = TenantRepository.getApplicationsPath(tenant);
        this.locksPath = TenantRepository.getLocksPath(tenant);
        this.curator = curator;
    }

    public Lock lock(ApplicationId id) {
        return this.curator.lock(this.lockPath(id), Duration.ofMinutes(1L));
    }

    public void modifyReindexing(ApplicationId id, ApplicationReindexing emptyValue, UnaryOperator<ApplicationReindexing> modifications) {
        try (Lock lock = this.curator.lock(this.reindexingLockPath(id), Duration.ofMinutes(1L));){
            this.writeReindexingStatus(id, (ApplicationReindexing)modifications.apply(this.readReindexingStatus(id).orElse(emptyValue)));
        }
    }

    public boolean exists(ApplicationId id) {
        return this.curator.exists(this.applicationPath(id));
    }

    public void createApplication(ApplicationId id) {
        if (!id.tenant().equals((Object)this.tenant)) {
            throw new IllegalArgumentException("Cannot write application id '" + id + "' for tenant '" + this.tenant + "'");
        }
        try (Lock lock = this.lock(id);){
            if (this.curator.exists(this.applicationPath(id))) {
                return;
            }
            this.curator.create(this.applicationPath(id));
            this.modifyReindexing(id, ApplicationReindexing.empty(), UnaryOperator.identity());
        }
    }

    public Transaction createPutTransaction(ApplicationId applicationId, long sessionId) {
        return new CuratorTransaction(this.curator).add((Transaction.Operation)CuratorOperations.setData((String)this.applicationPath(applicationId).getAbsolute(), (byte[])Utf8.toAsciiBytes((long)sessionId)));
    }

    public CuratorTransaction createDeleteTransaction(ApplicationId applicationId) {
        return CuratorTransaction.from((List)CuratorOperations.deleteAll((String)this.applicationPath(applicationId).getAbsolute(), (Curator)this.curator), (Curator)this.curator);
    }

    public Optional<Long> activeSessionOf(ApplicationId id) {
        Optional data = this.curator.getData(this.applicationPath(id));
        return data.isEmpty() || ((byte[])data.get()).length == 0 ? Optional.empty() : data.map(bytes -> Long.parseLong(Utf8.toString((byte[])bytes)));
    }

    public List<ApplicationId> activeApplications() {
        return this.curator.getChildren(this.applicationsPath).stream().sorted().map(ApplicationId::fromSerializedForm).filter(id -> this.activeSessionOf((ApplicationId)id).isPresent()).collect(Collectors.toUnmodifiableList());
    }

    public Optional<ApplicationReindexing> readReindexingStatus(ApplicationId id) {
        return this.curator.getData(this.reindexingDataPath(id)).map(x$0 -> ReindexingStatusSerializer.fromBytes(x$0));
    }

    void writeReindexingStatus(ApplicationId id, ApplicationReindexing status) {
        this.curator.set(this.reindexingDataPath(id), ReindexingStatusSerializer.toBytes(status));
    }

    public Curator.DirectoryCache createApplicationsPathCache(ExecutorService zkCacheExecutor) {
        return this.curator.createDirectoryCache(this.applicationsPath.getAbsolute(), false, false, zkCacheExecutor);
    }

    private Path reindexingLockPath(ApplicationId id) {
        return this.locksPath.append(id.serializedForm()).append("reindexing");
    }

    private Path lockPath(ApplicationId id) {
        return this.locksPath.append(id.serializedForm());
    }

    private Path applicationPath(ApplicationId id) {
        return this.applicationsPath.append(id.serializedForm());
    }

    private Path dedicatedClusterControllerClusterPath(ApplicationId id) {
        return this.applicationPath(id).append("dedicatedClusterControllerCluster");
    }

    private Path reindexingDataPath(ApplicationId id) {
        return this.applicationPath(id).append("reindexing");
    }

    private static class ReindexingStatusSerializer {
        private static final String ENABLED = "enabled";
        private static final String CLUSTERS = "clusters";
        private static final String PENDING = "pending";
        private static final String READY = "ready";
        private static final String TYPE = "type";
        private static final String NAME = "name";
        private static final String GENERATION = "generation";
        private static final String EPOCH_MILLIS = "epochMillis";
        private static final String SPEED = "speed";

        private ReindexingStatusSerializer() {
        }

        private static byte[] toBytes(ApplicationReindexing reindexing) {
            Cursor root = new Slime().setObject();
            root.setBool(ENABLED, reindexing.enabled());
            Cursor clustersArray = root.setArray(CLUSTERS);
            reindexing.clusters().forEach((name, cluster) -> {
                Cursor clusterObject = clustersArray.addObject();
                clusterObject.setString(NAME, name);
                Cursor pendingArray = clusterObject.setArray(PENDING);
                cluster.pending().forEach((type, generation) -> {
                    Cursor pendingObject = pendingArray.addObject();
                    pendingObject.setString(TYPE, type);
                    pendingObject.setLong(GENERATION, generation.longValue());
                });
                Cursor readyArray = clusterObject.setArray(READY);
                cluster.ready().forEach((type, status) -> {
                    Cursor statusObject = readyArray.addObject();
                    statusObject.setString(TYPE, type);
                    ReindexingStatusSerializer.setStatus(statusObject, status);
                });
            });
            return (byte[])Exceptions.uncheck(() -> SlimeUtils.toJsonBytes((Inspector)root));
        }

        private static void setStatus(Cursor statusObject, ApplicationReindexing.Status status) {
            statusObject.setLong(EPOCH_MILLIS, status.ready().toEpochMilli());
            statusObject.setDouble(SPEED, status.speed());
        }

        private static ApplicationReindexing fromBytes(byte[] data) {
            Cursor root = SlimeUtils.jsonToSlimeOrThrow((byte[])data).get();
            return new ApplicationReindexing(root.field(ENABLED).valid() ? root.field(ENABLED).asBool() : true, SlimeUtils.entriesStream((Inspector)root.field(CLUSTERS)).collect(Collectors.toUnmodifiableMap(object -> object.field(NAME).asString(), object -> ReindexingStatusSerializer.getCluster(object))));
        }

        private static ApplicationReindexing.Cluster getCluster(Inspector object) {
            return new ApplicationReindexing.Cluster(SlimeUtils.entriesStream((Inspector)object.field(PENDING)).collect(Collectors.toUnmodifiableMap(entry -> entry.field(TYPE).asString(), entry -> entry.field(GENERATION).asLong())), SlimeUtils.entriesStream((Inspector)object.field(READY)).collect(Collectors.toUnmodifiableMap(entry -> entry.field(TYPE).asString(), entry -> ReindexingStatusSerializer.getStatus(entry))));
        }

        private static ApplicationReindexing.Status getStatus(Inspector statusObject) {
            return new ApplicationReindexing.Status(Instant.ofEpochMilli(statusObject.field(EPOCH_MILLIS).asLong()), statusObject.field(SPEED).valid() ? statusObject.field(SPEED).asDouble() : 0.2);
        }
    }
}

