/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.serviceview;

import ai.vespa.http.DomainName;
import ai.vespa.http.HttpURL;
import ai.vespa.util.http.VespaClientBuilderFactory;
import com.fasterxml.jackson.jaxrs.json.JacksonJsonProvider;
import com.google.inject.Inject;
import com.yahoo.cloud.config.ConfigserverConfig;
import com.yahoo.container.jdisc.ThreadedHttpRequestHandler;
import com.yahoo.restapi.RestApi;
import com.yahoo.restapi.RestApiRequestHandler;
import com.yahoo.vespa.serviceview.Service;
import com.yahoo.vespa.serviceview.ServiceModel;
import com.yahoo.vespa.serviceview.bindings.ApplicationView;
import com.yahoo.vespa.serviceview.bindings.ConfigClient;
import com.yahoo.vespa.serviceview.bindings.HealthClient;
import com.yahoo.vespa.serviceview.bindings.ModelResponse;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.WebTarget;
import org.glassfish.jersey.client.proxy.WebResourceFactory;

public class StateRequestHandler
extends RestApiRequestHandler<StateRequestHandler> {
    private static final String USER_AGENT = "service-view-config-server-client";
    private static final String SINGLE_API_LINK = "url";
    private final Client client = ((ClientBuilder)((ClientBuilder)((ClientBuilder)((ClientBuilder)new VespaClientBuilderFactory().newBuilder().property("jersey.config.client.connectTimeout", (Object)10000)).property("jersey.config.client.readTimeout", (Object)10000)).register(JacksonJsonProvider.class)).register(ctx -> ctx.getHeaders().put((Object)"User-Agent", List.of(USER_AGENT)))).build();
    private final int restApiPort;

    @Inject
    public StateRequestHandler(ThreadedHttpRequestHandler.Context context, ConfigserverConfig configserverConfig) {
        super(context, StateRequestHandler::createRestApiDefinition);
        this.restApiPort = configserverConfig.httpport();
    }

    protected void destroy() {
        this.client.close();
        super.destroy();
    }

    private static RestApi createRestApiDefinition(StateRequestHandler self) {
        return RestApi.builder().addRoute(RestApi.route((String)"/serviceview/v1").get(self::getDefaultUserInfo)).addRoute(RestApi.route((String)"/serviceview/v1/").get(self::getDefaultUserInfo)).addRoute(RestApi.route((String)"/serviceview/v1/tenant/{tenantName}/application/{applicationName}/environment/{environmentName}/region/{regionName}/instance/{instanceName}").get(self::getUserInfo)).addRoute(RestApi.route((String)"/serviceview/v1/tenant/{tenantName}/application/{applicationName}/environment/{environmentName}/region/{regionName}/instance/{instanceName}/service/{serviceIdentifier}/{*}").get(self::singleService)).registerJacksonResponseEntity(HashMap.class).registerJacksonResponseEntity(ApplicationView.class).build();
    }

    private ApplicationView getDefaultUserInfo(RestApi.RequestContext context) {
        return this.getUserInfo(context.baseRequestURL(), "default", "default", "default", "default", "default");
    }

    private ApplicationView getUserInfo(RestApi.RequestContext context) {
        String tenantName = context.pathParameters().getStringOrThrow("tenantName");
        String applicationName = context.pathParameters().getStringOrThrow("applicationName");
        String environmentName = context.pathParameters().getStringOrThrow("environmentName");
        String regionName = context.pathParameters().getStringOrThrow("regionName");
        String instanceName = context.pathParameters().getStringOrThrow("instanceName");
        return this.getUserInfo(context.baseRequestURL(), tenantName, applicationName, environmentName, regionName, instanceName);
    }

    public HashMap<?, ?> singleService(RestApi.RequestContext context) {
        String tenantName = context.pathParameters().getStringOrThrow("tenantName");
        String applicationName = context.pathParameters().getStringOrThrow("applicationName");
        String environmentName = context.pathParameters().getStringOrThrow("environmentName");
        String regionName = context.pathParameters().getStringOrThrow("regionName");
        String instanceName = context.pathParameters().getStringOrThrow("instanceName");
        String identifier = context.pathParameters().getStringOrThrow("serviceIdentifier");
        HttpURL.Path apiParams = context.pathParameters().getRest().orElse(HttpURL.Path.empty());
        HttpURL.Query apiQuery = context.queryParameters().getFullQuery();
        return this.singleService(context.baseRequestURL(), tenantName, applicationName, environmentName, regionName, instanceName, identifier, apiParams, apiQuery);
    }

    protected ApplicationView getUserInfo(HttpURL url, String tenantName, String applicationName, String environmentName, String regionName, String instanceName) {
        ServiceModel model = new ServiceModel(this.getModelConfig(tenantName, applicationName, environmentName, regionName, instanceName));
        return model.showAllClusters(StateRequestHandler.baseUri(url).toString(), this.applicationIdentifier(tenantName, applicationName, environmentName, regionName, instanceName));
    }

    protected ModelResponse getModelConfig(String tenant, String application, String environment, String region, String instance) {
        WebTarget target = this.client.target("http://localhost:" + this.restApiPort + "/");
        ConfigClient resource = (ConfigClient)WebResourceFactory.newResource(ConfigClient.class, (WebTarget)target);
        return resource.getServiceModel(tenant, application, environment, region, instance);
    }

    protected HashMap<?, ?> singleService(HttpURL url, String tenantName, String applicationName, String environmentName, String regionName, String instanceName, String identifier, HttpURL.Path path, HttpURL.Query query) {
        ServiceModel model = new ServiceModel(this.getModelConfig(tenantName, applicationName, environmentName, regionName, instanceName));
        Service s = model.getService(identifier);
        int requestedPort = s.matchIdentifierWithPort(identifier);
        HealthClient resource = this.getHealthClient(path, s, requestedPort, query, this.client);
        HashMap apiResult = resource.getHealthInfo();
        this.rewriteResourceLinks(url, apiResult, model, s, this.applicationIdentifier(tenantName, applicationName, environmentName, regionName, instanceName), identifier);
        return apiResult;
    }

    protected HealthClient getHealthClient(HttpURL.Path apiParams, Service s, int requestedPort, HttpURL.Query query, Client client) {
        URI uri = HttpURL.create((HttpURL.Scheme)HttpURL.Scheme.http, (DomainName)DomainName.of((String)s.host), (int)requestedPort, (HttpURL.Path)apiParams, (HttpURL.Query)query).asURI();
        WebTarget target = client.target(uri);
        return (HealthClient)WebResourceFactory.newResource(HealthClient.class, (WebTarget)target);
    }

    private String applicationIdentifier(String tenant, String application, String environment, String region, String instance) {
        return "tenant/" + tenant + "/application/" + application + "/environment/" + environment + "/region/" + region + "/instance/" + instance;
    }

    private void rewriteResourceLinks(HttpURL url, Object apiResult, ServiceModel model, Service self, String applicationIdentifier, String incomingIdentifier) {
        block9: {
            block10: {
                if (!(apiResult instanceof List)) break block10;
                ListIterator<String> i = ((List)apiResult).listIterator();
                while (i.hasNext()) {
                    Object resource = i.next();
                    if (resource instanceof String) {
                        try {
                            StringBuilder stringBuilder = this.linkBuffer(url, applicationIdentifier);
                            this.retarget(model, self, stringBuilder, (String)resource);
                            i.set(stringBuilder.toString());
                            continue;
                        }
                        catch (GiveUpLinkRetargetingException giveUpLinkRetargetingException) {
                            break block9;
                        }
                    }
                    this.rewriteResourceLinks(url, resource, model, self, applicationIdentifier, incomingIdentifier);
                }
                break block9;
            }
            if (!(apiResult instanceof Map)) break block9;
            Map api = (Map)apiResult;
            for (Map.Entry<Object, Object> entry : api.entrySet()) {
                if (SINGLE_API_LINK.equals(entry.getKey()) && entry.getValue() instanceof String) {
                    try {
                        this.rewriteSingleLink(entry, model, self, this.linkBuffer(url, applicationIdentifier));
                    }
                    catch (GiveUpLinkRetargetingException giveUpLinkRetargetingException) {}
                    continue;
                }
                if ("link".equals(entry.getKey()) && entry.getValue() instanceof String) {
                    this.buildSingleLink(entry, this.linkBuffer(url, applicationIdentifier), incomingIdentifier);
                    continue;
                }
                this.rewriteResourceLinks(url, entry.getValue(), model, self, applicationIdentifier, incomingIdentifier);
            }
        }
    }

    private void buildSingleLink(Map.Entry<Object, Object> entry, StringBuilder newUri, String incomingIdentifier) {
        newUri.append("/service/").append(incomingIdentifier);
        newUri.append(entry.getValue());
        entry.setValue(newUri.toString());
    }

    private void addQuery(String query, StringBuilder newUri) {
        if (query != null && query.length() > 0) {
            newUri.append('?').append(query);
        }
    }

    private StringBuilder linkBuffer(HttpURL url, String applicationIdentifier) {
        return new StringBuilder(StateRequestHandler.baseUri(url).appendPath(HttpURL.Path.parse((String)applicationIdentifier)).toString());
    }

    private void rewriteSingleLink(Map.Entry<Object, Object> entry, ServiceModel model, Service self, StringBuilder newUri) throws GiveUpLinkRetargetingException {
        String url = (String)entry.getValue();
        this.retarget(model, self, newUri, url);
        entry.setValue(newUri.toString());
    }

    private void retarget(ServiceModel model, Service self, StringBuilder newUri, String url) throws GiveUpLinkRetargetingException {
        Service s;
        URI link;
        try {
            link = new URI(url);
        }
        catch (URISyntaxException e) {
            throw new GiveUpLinkRetargetingException(e);
        }
        if (!link.isAbsolute()) {
            throw new GiveUpLinkRetargetingException("This rewriting only supports absolute URIs.");
        }
        int linkPort = link.getPort();
        if (linkPort == -1) {
            linkPort = 80;
        }
        try {
            s = model.resolve(link.getHost(), linkPort, self);
        }
        catch (IllegalArgumentException e) {
            throw new GiveUpLinkRetargetingException(e);
        }
        newUri.append("/service/").append(s.getIdentifier(linkPort));
        newUri.append(link.getRawPath());
    }

    private static HttpURL baseUri(HttpURL url) {
        return url.withPath(HttpURL.Path.parse((String)"/serviceview/v1/"));
    }

    private static class GiveUpLinkRetargetingException
    extends Exception {
        public GiveUpLinkRetargetingException(Throwable reason) {
            super(reason);
        }

        public GiveUpLinkRetargetingException(String message) {
            super(message);
        }
    }
}

