/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.server.filedistribution;

import com.yahoo.config.FileReference;
import com.yahoo.io.IOUtils;
import com.yahoo.path.Path;
import com.yahoo.vespa.config.server.filedistribution.AddFileInterface;
import com.yahoo.vespa.config.server.filedistribution.FileDirectory;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.channels.Channel;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Locale;
import net.jpountz.lz4.LZ4FrameOutputStream;

public class ApplicationFileManager
implements AddFileInterface {
    private final File applicationDir;
    private final FileDirectory fileDirectory;

    ApplicationFileManager(File applicationDir, FileDirectory fileDirectory) {
        this.applicationDir = applicationDir;
        this.fileDirectory = fileDirectory;
    }

    @Override
    public FileReference addFile(Path path) throws IOException {
        File file = new File(this.applicationDir, path.getRelative());
        return this.addFile(file);
    }

    private FileReference addFile(File file) throws IOException {
        return this.fileDirectory.addFile(file);
    }

    @Override
    public FileReference addUri(String uri, Path path) {
        TmpDir tmp = new TmpDir();
        try {
            FileReference fileReference = this.addFile(this.download(uri, tmp.dir, path));
            tmp.close();
            return fileReference;
        }
        catch (Throwable throwable) {
            try {
                try {
                    tmp.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new IllegalArgumentException(e);
            }
        }
    }

    @Override
    public FileReference addBlob(ByteBuffer blob, Path path) {
        TmpDir tmp = new TmpDir();
        try {
            FileReference fileReference = this.addFile(this.writeBlob(blob, tmp.dir, path));
            tmp.close();
            return fileReference;
        }
        catch (Throwable throwable) {
            try {
                try {
                    tmp.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new IllegalArgumentException(e);
            }
        }
    }

    private File writeBlob(ByteBuffer blob, File tmpDir, Path path) {
        FileOutputStream fos = null;
        File file = null;
        try {
            Object lz4;
            file = new File(tmpDir, path.getRelative());
            Files.createDirectories(file.getParentFile().toPath(), new FileAttribute[0]);
            fos = new FileOutputStream(file);
            if (path.last().endsWith(".lz4")) {
                lz4 = new LZ4FrameOutputStream((OutputStream)fos);
                lz4.write(blob.array(), blob.arrayOffset(), blob.remaining());
                lz4.close();
            } else {
                fos.write(blob.array(), blob.arrayOffset(), blob.remaining());
            }
            lz4 = file;
            return lz4;
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Failed creating temp file", e);
        }
        finally {
            try {
                if (fos != null) {
                    fos.close();
                }
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Failed closing down after writing blob of size " + blob.remaining() + " to " + file);
            }
        }
    }

    private File download(String uri, File tmpDir, Path path) {
        File file = null;
        FileOutputStream fos = null;
        Channel rbc = null;
        try {
            file = new File(tmpDir, path.getRelative());
            Files.createDirectories(file.getParentFile().toPath(), new FileAttribute[0]);
            URL website = new URL(uri);
            if (!List.of("http", "https").contains(website.getProtocol().toLowerCase(Locale.ROOT))) {
                throw new IllegalArgumentException("only HTTP(S) supported for URI type resources");
            }
            rbc = Channels.newChannel(website.openStream());
            fos = new FileOutputStream(file);
            fos.getChannel().transferFrom((ReadableByteChannel)rbc, 0L, Long.MAX_VALUE);
            File file2 = file;
            return file2;
        }
        catch (SocketTimeoutException e) {
            throw new IllegalArgumentException("Failed connecting to or reading from " + uri, e);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Failed creating " + file, e);
        }
        finally {
            try {
                if (fos != null) {
                    fos.close();
                }
                if (rbc != null) {
                    rbc.close();
                }
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Failed closing down after downloading " + uri + " to " + file);
            }
        }
    }

    private static class TmpDir
    implements Closeable {
        final File dir = Files.createTempDirectory("", new FileAttribute[0]).toFile();

        private TmpDir() throws IOException {
        }

        @Override
        public void close() {
            IOUtils.recursiveDeleteDir((File)this.dir);
        }
    }
}

