/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.server.filedistribution;

import com.yahoo.config.FileReference;
import com.yahoo.io.IOUtils;
import com.yahoo.vespa.config.server.filedistribution.AddFileInterface;
import com.yahoo.vespa.config.server.filedistribution.FileDirectory;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.channels.Channel;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import net.jpountz.lz4.LZ4FrameOutputStream;

public class ApplicationFileManager
implements AddFileInterface {
    private final File applicationDir;
    private final FileDirectory fileDirectory;

    ApplicationFileManager(File applicationDir, FileDirectory fileDirectory) {
        this.applicationDir = applicationDir;
        this.fileDirectory = fileDirectory;
    }

    @Override
    public FileReference addFile(String relativePath) throws IOException {
        Path path = Path.of(relativePath, new String[0]).normalize();
        if (path.isAbsolute()) {
            throw new IllegalArgumentException(relativePath + " is not relative");
        }
        File file = new File(this.applicationDir, relativePath);
        Path relative = this.applicationDir.toPath().relativize(file.toPath()).normalize();
        if (relative.isAbsolute() || relative.startsWith("..")) {
            throw new IllegalArgumentException(file + " is not a descendant of " + this.applicationDir);
        }
        return this.fileDirectory.addFile(file);
    }

    @Override
    public FileReference addFile(File file) throws IOException {
        return this.fileDirectory.addFile(file);
    }

    @Override
    public FileReference addUri(String uri, String relativePath) {
        File file = this.download(uri, relativePath);
        try {
            FileReference fileReference = this.addFile(file);
            return fileReference;
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
        finally {
            this.cleanup(file, relativePath);
        }
    }

    @Override
    public FileReference addBlob(ByteBuffer blob, String relativePath) {
        File file = this.writeBlob(blob, relativePath);
        try {
            FileReference fileReference = this.addFile(file);
            return fileReference;
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
        finally {
            this.cleanup(file, relativePath);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private File writeBlob(ByteBuffer blob, String relativePath) {
        File file2;
        FileOutputStream fos = null;
        File file = null;
        try {
            Path path = Files.createTempDirectory("", new FileAttribute[0]);
            file = new File(path.toFile(), relativePath);
            Files.createDirectories(file.getParentFile().toPath(), new FileAttribute[0]);
            fos = new FileOutputStream(file);
            if (relativePath.endsWith(".lz4")) {
                LZ4FrameOutputStream lz4 = new LZ4FrameOutputStream((OutputStream)fos);
                lz4.write(blob.array(), blob.arrayOffset(), blob.remaining());
                lz4.close();
            } else {
                fos.write(blob.array(), blob.arrayOffset(), blob.remaining());
            }
            file2 = file;
        }
        catch (IOException e) {
            try {
                throw new IllegalArgumentException("Failed creating temp file", e);
            }
            catch (Throwable throwable) {
                try {
                    if (fos == null) throw throwable;
                    fos.close();
                    throw throwable;
                }
                catch (IOException e2) {
                    throw new IllegalArgumentException("Failed closing down after writing blob of size " + blob.remaining() + " to " + file);
                }
            }
        }
        try {
            if (fos == null) return file2;
            fos.close();
            return file2;
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Failed closing down after writing blob of size " + blob.remaining() + " to " + file);
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private File download(String uri, String relativePath) {
        File file;
        File file2 = null;
        FileOutputStream fos = null;
        Channel rbc = null;
        try {
            Path path = Files.createTempDirectory("", new FileAttribute[0]);
            file2 = new File(path.toFile(), relativePath);
            Files.createDirectories(file2.getParentFile().toPath(), new FileAttribute[0]);
            URL website = new URL(uri);
            rbc = Channels.newChannel(website.openStream());
            fos = new FileOutputStream(file2);
            fos.getChannel().transferFrom((ReadableByteChannel)rbc, 0L, Long.MAX_VALUE);
            file = file2;
        }
        catch (SocketTimeoutException e) {
            try {
                throw new IllegalArgumentException("Failed connecting to or reading from " + uri, e);
                catch (IOException e2) {
                    throw new IllegalArgumentException("Failed creating " + file2, e2);
                }
            }
            catch (Throwable throwable) {
                try {
                    if (fos != null) {
                        fos.close();
                    }
                    if (rbc == null) throw throwable;
                    rbc.close();
                    throw throwable;
                }
                catch (IOException e3) {
                    throw new IllegalArgumentException("Failed closing down after downloading " + uri + " to " + file2);
                }
            }
        }
        try {
            if (fos != null) {
                fos.close();
            }
            if (rbc == null) return file;
            rbc.close();
            return file;
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Failed closing down after downloading " + uri + " to " + file2);
        }
    }

    private void cleanup(File file, String relativePath) {
        Path pathToDelete = file.toPath();
        for (int i = 0; i < Paths.get(relativePath, new String[0]).getNameCount(); ++i) {
            pathToDelete = pathToDelete.resolveSibling("");
        }
        IOUtils.recursiveDeleteDir((File)pathToDelete.toFile());
    }
}

