/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.serviceview;

import ai.vespa.util.http.VespaClientBuilderFactory;
import com.google.inject.Inject;
import com.yahoo.cloud.config.ConfigserverConfig;
import com.yahoo.container.jdisc.ThreadedHttpRequestHandler;
import com.yahoo.restapi.RestApi;
import com.yahoo.restapi.RestApiRequestHandler;
import com.yahoo.restapi.UriBuilder;
import com.yahoo.vespa.serviceview.Service;
import com.yahoo.vespa.serviceview.ServiceModel;
import com.yahoo.vespa.serviceview.bindings.ApplicationView;
import com.yahoo.vespa.serviceview.bindings.ConfigClient;
import com.yahoo.vespa.serviceview.bindings.HealthClient;
import com.yahoo.vespa.serviceview.bindings.ModelResponse;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.WebTarget;
import org.glassfish.jersey.client.proxy.WebResourceFactory;

public class StateRequestHandler
extends RestApiRequestHandler<StateRequestHandler> {
    private static final String USER_AGENT = "service-view-config-server-client";
    private static final String SINGLE_API_LINK = "url";
    private final Client client = ((ClientBuilder)((ClientBuilder)((ClientBuilder)new VespaClientBuilderFactory().newBuilder().property("jersey.config.client.connectTimeout", (Object)10000)).property("jersey.config.client.readTimeout", (Object)10000)).register(ctx -> ctx.getHeaders().put((Object)"User-Agent", List.of(USER_AGENT)))).build();
    private final int restApiPort;

    @Inject
    public StateRequestHandler(ThreadedHttpRequestHandler.Context context, ConfigserverConfig configserverConfig) {
        super(context, StateRequestHandler::createRestApiDefinition);
        this.restApiPort = configserverConfig.httpport();
    }

    protected void destroy() {
        this.client.close();
        super.destroy();
    }

    private static RestApi createRestApiDefinition(StateRequestHandler self) {
        return RestApi.builder().addRoute(RestApi.route((String)"/serviceview/v1").get(self::getDefaultUserInfo)).addRoute(RestApi.route((String)"/serviceview/v1/").get(self::getDefaultUserInfo)).addRoute(RestApi.route((String)"/serviceview/v1/tenant/{tenantName}/application/{applicationName}/environment/{environmentName}/region/{regionName}/instance/{instanceName}").get(self::getUserInfo)).addRoute(RestApi.route((String)"/serviceview/v1/tenant/{tenantName}/application/{applicationName}/environment/{environmentName}/region/{regionName}/instance/{instanceName}/service/{serviceIdentifier}/{*}").get(self::singleService)).registerJacksonResponseEntity(HashMap.class).registerJacksonResponseEntity(ApplicationView.class).build();
    }

    private ApplicationView getDefaultUserInfo(RestApi.RequestContext context) {
        return this.getUserInfo(context.uriBuilder(), "default", "default", "default", "default", "default");
    }

    private ApplicationView getUserInfo(RestApi.RequestContext context) {
        String tenantName = context.pathParameters().getStringOrThrow("tenantName");
        String applicationName = context.pathParameters().getStringOrThrow("applicationName");
        String environmentName = context.pathParameters().getStringOrThrow("environmentName");
        String regionName = context.pathParameters().getStringOrThrow("regionName");
        String instanceName = context.pathParameters().getStringOrThrow("instanceName");
        return this.getUserInfo(context.uriBuilder(), tenantName, applicationName, environmentName, regionName, instanceName);
    }

    public HashMap<?, ?> singleService(RestApi.RequestContext context) {
        String tenantName = context.pathParameters().getStringOrThrow("tenantName");
        String applicationName = context.pathParameters().getStringOrThrow("applicationName");
        String environmentName = context.pathParameters().getStringOrThrow("environmentName");
        String regionName = context.pathParameters().getStringOrThrow("regionName");
        String instanceName = context.pathParameters().getStringOrThrow("instanceName");
        String identifier = context.pathParameters().getStringOrThrow("serviceIdentifier");
        String apiParams = context.pathParameters().getString("*").orElse("");
        return this.singleService(context.uriBuilder(), context.request().getUri(), tenantName, applicationName, environmentName, regionName, instanceName, identifier, apiParams);
    }

    protected ApplicationView getUserInfo(UriBuilder uriBuilder, String tenantName, String applicationName, String environmentName, String regionName, String instanceName) {
        ServiceModel model = new ServiceModel(this.getModelConfig(tenantName, applicationName, environmentName, regionName, instanceName));
        return model.showAllClusters(StateRequestHandler.baseUri(uriBuilder).toString(), this.applicationIdentifier(tenantName, applicationName, environmentName, regionName, instanceName));
    }

    protected ModelResponse getModelConfig(String tenant, String application, String environment, String region, String instance) {
        WebTarget target = this.client.target("http://localhost:" + this.restApiPort + "/");
        ConfigClient resource = (ConfigClient)WebResourceFactory.newResource(ConfigClient.class, (WebTarget)target);
        return resource.getServiceModel(tenant, application, environment, region, instance);
    }

    protected HashMap<?, ?> singleService(UriBuilder uriBuilder, URI requestUri, String tenantName, String applicationName, String environmentName, String regionName, String instanceName, String identifier, String apiParams) {
        ServiceModel model = new ServiceModel(this.getModelConfig(tenantName, applicationName, environmentName, regionName, instanceName));
        Service s = model.getService(identifier);
        int requestedPort = s.matchIdentifierWithPort(identifier);
        HealthClient resource = this.getHealthClient(apiParams, s, requestedPort, requestUri.getRawQuery(), this.client);
        HashMap apiResult = resource.getHealthInfo();
        this.rewriteResourceLinks(uriBuilder, apiResult, model, s, this.applicationIdentifier(tenantName, applicationName, environmentName, regionName, instanceName), identifier);
        return apiResult;
    }

    protected HealthClient getHealthClient(String apiParams, Service s, int requestedPort, String uriQuery, Client client) {
        StringBuilder uriBuffer = new StringBuilder("http://").append(s.host).append(':').append(requestedPort).append('/').append(apiParams);
        this.addQuery(uriQuery, uriBuffer);
        WebTarget target = client.target(uriBuffer.toString());
        return (HealthClient)WebResourceFactory.newResource(HealthClient.class, (WebTarget)target);
    }

    private String applicationIdentifier(String tenant, String application, String environment, String region, String instance) {
        return "tenant/" + tenant + "/application/" + application + "/environment/" + environment + "/region/" + region + "/instance/" + instance;
    }

    private void rewriteResourceLinks(UriBuilder uriBuilder, Object apiResult, ServiceModel model, Service self, String applicationIdentifier, String incomingIdentifier) {
        block9: {
            block10: {
                if (!(apiResult instanceof List)) break block10;
                ListIterator<String> i = ((List)apiResult).listIterator();
                while (i.hasNext()) {
                    Object resource = i.next();
                    if (resource instanceof String) {
                        try {
                            StringBuilder stringBuilder = this.linkBuffer(uriBuilder, applicationIdentifier);
                            this.retarget(model, self, stringBuilder, (String)resource);
                            i.set(stringBuilder.toString());
                            continue;
                        }
                        catch (GiveUpLinkRetargetingException giveUpLinkRetargetingException) {
                            break block9;
                        }
                    }
                    this.rewriteResourceLinks(uriBuilder, resource, model, self, applicationIdentifier, incomingIdentifier);
                }
                break block9;
            }
            if (!(apiResult instanceof Map)) break block9;
            Map api = (Map)apiResult;
            for (Map.Entry<Object, Object> entry : api.entrySet()) {
                if (SINGLE_API_LINK.equals(entry.getKey()) && entry.getValue() instanceof String) {
                    try {
                        this.rewriteSingleLink(entry, model, self, this.linkBuffer(uriBuilder, applicationIdentifier));
                    }
                    catch (GiveUpLinkRetargetingException giveUpLinkRetargetingException) {}
                    continue;
                }
                if ("link".equals(entry.getKey()) && entry.getValue() instanceof String) {
                    this.buildSingleLink(entry, this.linkBuffer(uriBuilder, applicationIdentifier), incomingIdentifier);
                    continue;
                }
                this.rewriteResourceLinks(uriBuilder, entry.getValue(), model, self, applicationIdentifier, incomingIdentifier);
            }
        }
    }

    private void buildSingleLink(Map.Entry<Object, Object> entry, StringBuilder newUri, String incomingIdentifier) {
        newUri.append("/service/").append(incomingIdentifier);
        newUri.append(entry.getValue());
        entry.setValue(newUri.toString());
    }

    private void addQuery(String query, StringBuilder newUri) {
        if (query != null && query.length() > 0) {
            newUri.append('?').append(query);
        }
    }

    private StringBuilder linkBuffer(UriBuilder uriBuilder, String applicationIdentifier) {
        return StateRequestHandler.baseUri(uriBuilder).append(applicationIdentifier);
    }

    private void rewriteSingleLink(Map.Entry<Object, Object> entry, ServiceModel model, Service self, StringBuilder newUri) throws GiveUpLinkRetargetingException {
        String url = (String)entry.getValue();
        this.retarget(model, self, newUri, url);
        entry.setValue(newUri.toString());
    }

    private void retarget(ServiceModel model, Service self, StringBuilder newUri, String url) throws GiveUpLinkRetargetingException {
        Service s;
        URI link;
        try {
            link = new URI(url);
        }
        catch (URISyntaxException e) {
            throw new GiveUpLinkRetargetingException(e);
        }
        if (!link.isAbsolute()) {
            throw new GiveUpLinkRetargetingException("This rewriting only supports absolute URIs.");
        }
        int linkPort = link.getPort();
        if (linkPort == -1) {
            linkPort = 80;
        }
        try {
            s = model.resolve(link.getHost(), linkPort, self);
        }
        catch (IllegalArgumentException e) {
            throw new GiveUpLinkRetargetingException(e);
        }
        newUri.append("/service/").append(s.getIdentifier(linkPort));
        newUri.append(link.getRawPath());
    }

    private static StringBuilder baseUri(UriBuilder uriBuilder) {
        return new StringBuilder(uriBuilder.withPath("/serviceview/v1/").toString());
    }

    private static class GiveUpLinkRetargetingException
    extends Exception {
        public GiveUpLinkRetargetingException(Throwable reason) {
            super(reason);
        }

        public GiveUpLinkRetargetingException(String message) {
            super(message);
        }
    }
}

