/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.server.deploy;

import com.yahoo.cloud.config.ConfigserverConfig;
import com.yahoo.component.Version;
import com.yahoo.config.application.api.ApplicationPackage;
import com.yahoo.config.application.api.DeployLogger;
import com.yahoo.config.application.api.FileRegistry;
import com.yahoo.config.model.api.ConfigDefinitionRepo;
import com.yahoo.config.model.api.ContainerEndpoint;
import com.yahoo.config.model.api.EndpointCertificateSecrets;
import com.yahoo.config.model.api.HostProvisioner;
import com.yahoo.config.model.api.Model;
import com.yahoo.config.model.api.ModelContext;
import com.yahoo.config.model.api.Provisioned;
import com.yahoo.config.model.api.Quota;
import com.yahoo.config.model.api.Reindexing;
import com.yahoo.config.model.api.TenantSecretStore;
import com.yahoo.config.provision.ApplicationId;
import com.yahoo.config.provision.AthenzDomain;
import com.yahoo.config.provision.ClusterSpec;
import com.yahoo.config.provision.DockerImage;
import com.yahoo.config.provision.HostName;
import com.yahoo.config.provision.TenantName;
import com.yahoo.config.provision.Zone;
import com.yahoo.container.jdisc.secretstore.SecretStore;
import com.yahoo.vespa.config.server.ConfigServerSpec;
import com.yahoo.vespa.config.server.tenant.SecretStoreExternalIdRetriever;
import com.yahoo.vespa.flags.BooleanFlag;
import com.yahoo.vespa.flags.FetchVector;
import com.yahoo.vespa.flags.Flag;
import com.yahoo.vespa.flags.FlagSource;
import com.yahoo.vespa.flags.Flags;
import com.yahoo.vespa.flags.ListFlag;
import com.yahoo.vespa.flags.PermanentFlags;
import com.yahoo.vespa.flags.StringFlag;
import com.yahoo.vespa.flags.UnboundFlag;
import java.io.File;
import java.net.URI;
import java.security.cert.X509Certificate;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.function.ToIntFunction;

public class ModelContextImpl
implements ModelContext {
    private final ApplicationPackage applicationPackage;
    private final Optional<Model> previousModel;
    private final Optional<ApplicationPackage> permanentApplicationPackage;
    private final DeployLogger deployLogger;
    private final ConfigDefinitionRepo configDefinitionRepo;
    private final FileRegistry fileRegistry;
    private final ExecutorService executor;
    private final HostProvisioner hostProvisioner;
    private final Provisioned provisioned;
    private final Optional<? extends Reindexing> reindexing;
    private final ModelContext.Properties properties;
    private final Optional<File> appDir;
    private final Optional<DockerImage> wantedDockerImageRepository;
    private final Version modelVespaVersion;
    private final Version wantedNodeVespaVersion;

    public ModelContextImpl(ApplicationPackage applicationPackage, Optional<Model> previousModel, Optional<ApplicationPackage> permanentApplicationPackage, DeployLogger deployLogger, ConfigDefinitionRepo configDefinitionRepo, FileRegistry fileRegistry, ExecutorService executor, Optional<? extends Reindexing> reindexing, HostProvisioner hostProvisioner, Provisioned provisioned, ModelContext.Properties properties, Optional<File> appDir, Optional<DockerImage> wantedDockerImageRepository, Version modelVespaVersion, Version wantedNodeVespaVersion) {
        this.applicationPackage = applicationPackage;
        this.previousModel = previousModel;
        this.permanentApplicationPackage = permanentApplicationPackage;
        this.deployLogger = deployLogger;
        this.configDefinitionRepo = configDefinitionRepo;
        this.fileRegistry = fileRegistry;
        this.executor = executor;
        this.reindexing = reindexing;
        this.hostProvisioner = hostProvisioner;
        this.provisioned = provisioned;
        this.properties = properties;
        this.appDir = appDir;
        this.wantedDockerImageRepository = wantedDockerImageRepository;
        this.modelVespaVersion = modelVespaVersion;
        this.wantedNodeVespaVersion = wantedNodeVespaVersion;
    }

    public ApplicationPackage applicationPackage() {
        return this.applicationPackage;
    }

    public Optional<Model> previousModel() {
        return this.previousModel;
    }

    public Optional<ApplicationPackage> permanentApplicationPackage() {
        return this.permanentApplicationPackage;
    }

    public HostProvisioner getHostProvisioner() {
        return this.hostProvisioner;
    }

    public Provisioned provisioned() {
        return this.provisioned;
    }

    public DeployLogger deployLogger() {
        return this.deployLogger;
    }

    public ConfigDefinitionRepo configDefinitionRepo() {
        return this.configDefinitionRepo;
    }

    public FileRegistry getFileRegistry() {
        return this.fileRegistry;
    }

    public ExecutorService getExecutor() {
        return this.executor;
    }

    public Optional<? extends Reindexing> reindexing() {
        return this.reindexing;
    }

    public ModelContext.Properties properties() {
        return this.properties;
    }

    public Optional<File> appDir() {
        return this.appDir;
    }

    public Optional<DockerImage> wantedDockerImageRepo() {
        return this.wantedDockerImageRepository;
    }

    public Version modelVespaVersion() {
        return this.modelVespaVersion;
    }

    public Version wantedNodeVespaVersion() {
        return this.wantedNodeVespaVersion;
    }

    public static class Properties
    implements ModelContext.Properties {
        private final ModelContext.FeatureFlags featureFlags;
        private final ApplicationId applicationId;
        private final boolean multitenant;
        private final List<com.yahoo.config.model.api.ConfigServerSpec> configServerSpecs;
        private final HostName loadBalancerName;
        private final URI ztsUrl;
        private final String athenzDnsSuffix;
        private final boolean hostedVespa;
        private final Zone zone;
        private final Set<ContainerEndpoint> endpoints;
        private final boolean isBootstrap;
        private final boolean isFirstTimeDeployment;
        private final Optional<EndpointCertificateSecrets> endpointCertificateSecrets;
        private final Optional<AthenzDomain> athenzDomain;
        private final Quota quota;
        private final List<TenantSecretStore> tenantSecretStores;
        private final SecretStore secretStore;
        private final StringFlag jvmGCOptionsFlag;
        private final boolean allowDisableMtls;
        private final List<X509Certificate> operatorCertificates;
        private final List<String> tlsCiphersOverride;
        private final List<String> zoneDnsSuffixes;
        private final List<String> environmentVariables;

        public Properties(ApplicationId applicationId, ConfigserverConfig configserverConfig, Zone zone, Set<ContainerEndpoint> endpoints, boolean isBootstrap, boolean isFirstTimeDeployment, FlagSource flagSource, Optional<EndpointCertificateSecrets> endpointCertificateSecrets, Optional<AthenzDomain> athenzDomain, Optional<Quota> maybeQuota, List<TenantSecretStore> tenantSecretStores, SecretStore secretStore, List<X509Certificate> operatorCertificates) {
            this.featureFlags = new FeatureFlags(flagSource, applicationId);
            this.applicationId = applicationId;
            this.multitenant = configserverConfig.multitenant() || configserverConfig.hostedVespa() || Boolean.getBoolean("multitenant");
            this.configServerSpecs = ConfigServerSpec.fromConfig(configserverConfig);
            this.loadBalancerName = HostName.from((String)configserverConfig.loadBalancerAddress());
            this.ztsUrl = configserverConfig.ztsUrl() != null ? URI.create(configserverConfig.ztsUrl()) : null;
            this.athenzDnsSuffix = configserverConfig.athenzDnsSuffix();
            this.hostedVespa = configserverConfig.hostedVespa();
            this.zone = zone;
            this.endpoints = endpoints;
            this.isBootstrap = isBootstrap;
            this.isFirstTimeDeployment = isFirstTimeDeployment;
            this.endpointCertificateSecrets = endpointCertificateSecrets;
            this.athenzDomain = athenzDomain;
            this.quota = maybeQuota.orElseGet(Quota::unlimited);
            this.tenantSecretStores = tenantSecretStores;
            this.secretStore = secretStore;
            this.jvmGCOptionsFlag = (StringFlag)((StringFlag)PermanentFlags.JVM_GC_OPTIONS.bindTo(flagSource)).with(FetchVector.Dimension.APPLICATION_ID, applicationId.serializedForm());
            this.allowDisableMtls = ((BooleanFlag)((BooleanFlag)PermanentFlags.ALLOW_DISABLE_MTLS.bindTo(flagSource)).with(FetchVector.Dimension.APPLICATION_ID, applicationId.serializedForm())).value();
            this.operatorCertificates = operatorCertificates;
            this.tlsCiphersOverride = ((ListFlag)((ListFlag)PermanentFlags.TLS_CIPHERS_OVERRIDE.bindTo(flagSource)).with(FetchVector.Dimension.APPLICATION_ID, applicationId.serializedForm())).value();
            this.zoneDnsSuffixes = configserverConfig.zoneDnsSuffixes();
            this.environmentVariables = ((ListFlag)((ListFlag)PermanentFlags.ENVIRONMENT_VARIABLES.bindTo(flagSource)).with(FetchVector.Dimension.APPLICATION_ID, applicationId.serializedForm())).value();
        }

        public ModelContext.FeatureFlags featureFlags() {
            return this.featureFlags;
        }

        public boolean multitenant() {
            return this.multitenant;
        }

        public ApplicationId applicationId() {
            return this.applicationId;
        }

        public List<com.yahoo.config.model.api.ConfigServerSpec> configServerSpecs() {
            return this.configServerSpecs;
        }

        public HostName loadBalancerName() {
            return this.loadBalancerName;
        }

        public URI ztsUrl() {
            return this.ztsUrl;
        }

        public String athenzDnsSuffix() {
            return this.athenzDnsSuffix;
        }

        public boolean hostedVespa() {
            return this.hostedVespa;
        }

        public Zone zone() {
            return this.zone;
        }

        public Set<ContainerEndpoint> endpoints() {
            return this.endpoints;
        }

        public boolean isBootstrap() {
            return this.isBootstrap;
        }

        public boolean isFirstTimeDeployment() {
            return this.isFirstTimeDeployment;
        }

        public Optional<EndpointCertificateSecrets> endpointCertificateSecrets() {
            return this.endpointCertificateSecrets;
        }

        public Optional<AthenzDomain> athenzDomain() {
            return this.athenzDomain;
        }

        public Quota quota() {
            return this.quota;
        }

        public List<TenantSecretStore> tenantSecretStores() {
            return SecretStoreExternalIdRetriever.populateExternalId(this.secretStore, this.applicationId.tenant(), this.zone.system(), this.tenantSecretStores);
        }

        public String jvmGCOptions(Optional<ClusterSpec.Type> clusterType) {
            return this.flagValueForClusterType(this.jvmGCOptionsFlag, clusterType);
        }

        public boolean allowDisableMtls() {
            return this.allowDisableMtls;
        }

        public List<X509Certificate> operatorCertificates() {
            return this.operatorCertificates;
        }

        public List<String> tlsCiphersOverride() {
            return this.tlsCiphersOverride;
        }

        public List<String> zoneDnsSuffixes() {
            return this.zoneDnsSuffixes;
        }

        public String flagValueForClusterType(StringFlag flag, Optional<ClusterSpec.Type> clusterType) {
            return clusterType.map(type -> (StringFlag)flag.with(FetchVector.Dimension.CLUSTER_TYPE, type.name())).orElse(flag).value();
        }

        public List<String> environmentVariables() {
            return this.environmentVariables;
        }
    }

    public static class FeatureFlags
    implements ModelContext.FeatureFlags {
        private final double defaultTermwiseLimit;
        private final boolean useThreePhaseUpdates;
        private final String feedSequencer;
        private final int feedTaskLimit;
        private final int feedMasterTaskLimit;
        private final String sharedFieldWriterExecutor;
        private final String responseSequencer;
        private final int numResponseThreads;
        private final boolean skipCommunicationManagerThread;
        private final boolean skipMbusRequestThread;
        private final boolean skipMbusReplyThread;
        private final boolean useAsyncMessageHandlingOnSchedule;
        private final double feedConcurrency;
        private final List<String> allowedAthenzProxyIdentities;
        private final int maxActivationInhibitedOutOfSyncGroups;
        private final ToIntFunction<ClusterSpec.Type> jvmOmitStackTraceInFastThrow;
        private final int maxConcurrentMergesPerContentNode;
        private final int maxMergeQueueSize;
        private final double resourceLimitDisk;
        private final double resourceLimitMemory;
        private final double minNodeRatioPerGroup;
        private final int metricsproxyNumThreads;
        private final int availableProcessors;
        private final boolean containerDumpHeapOnShutdownTimeout;
        private final double containerShutdownTimeout;
        private final int maxUnCommittedMemory;
        private final boolean forwardIssuesAsErrors;
        private final boolean ignoreThreadStackSizes;
        private final boolean unorderedMergeChaining;
        private final boolean useV8GeoPositions;
        private final boolean useV8DocManagerCfg;
        private final int maxCompactBuffers;
        private final boolean failDeploymentWithInvalidJvmOptions;
        private final List<String> ignoredHttpUserAgents;
        private final boolean enableServerOcspStapling;
        private final String persistenceAsyncThrottling;
        private final String mergeThrottlingPolicy;
        private final double persistenceThrottlingWsDecrementFactor;
        private final double persistenceThrottlingWsBackoff;
        private final boolean inhibitDefaultMergesWhenGlobalMergesPending;
        private final boolean useQrserverServiceName;
        private final boolean avoidRenamingSummaryFeatures;

        public FeatureFlags(FlagSource source, ApplicationId appId) {
            this.defaultTermwiseLimit = (Double)FeatureFlags.flagValue(source, appId, Flags.DEFAULT_TERM_WISE_LIMIT);
            this.useThreePhaseUpdates = (Boolean)FeatureFlags.flagValue(source, appId, Flags.USE_THREE_PHASE_UPDATES);
            this.feedSequencer = (String)FeatureFlags.flagValue(source, appId, Flags.FEED_SEQUENCER_TYPE);
            this.feedTaskLimit = (Integer)FeatureFlags.flagValue(source, appId, Flags.FEED_TASK_LIMIT);
            this.feedMasterTaskLimit = (Integer)FeatureFlags.flagValue(source, appId, Flags.FEED_MASTER_TASK_LIMIT);
            this.sharedFieldWriterExecutor = (String)FeatureFlags.flagValue(source, appId, Flags.SHARED_FIELD_WRITER_EXECUTOR);
            this.responseSequencer = (String)FeatureFlags.flagValue(source, appId, Flags.RESPONSE_SEQUENCER_TYPE);
            this.numResponseThreads = (Integer)FeatureFlags.flagValue(source, appId, Flags.RESPONSE_NUM_THREADS);
            this.skipCommunicationManagerThread = (Boolean)FeatureFlags.flagValue(source, appId, Flags.SKIP_COMMUNICATIONMANAGER_THREAD);
            this.skipMbusRequestThread = (Boolean)FeatureFlags.flagValue(source, appId, Flags.SKIP_MBUS_REQUEST_THREAD);
            this.skipMbusReplyThread = (Boolean)FeatureFlags.flagValue(source, appId, Flags.SKIP_MBUS_REPLY_THREAD);
            this.useAsyncMessageHandlingOnSchedule = (Boolean)FeatureFlags.flagValue(source, appId, Flags.USE_ASYNC_MESSAGE_HANDLING_ON_SCHEDULE);
            this.feedConcurrency = (Double)FeatureFlags.flagValue(source, appId, Flags.FEED_CONCURRENCY);
            this.allowedAthenzProxyIdentities = (List)FeatureFlags.flagValue(source, appId, Flags.ALLOWED_ATHENZ_PROXY_IDENTITIES);
            this.maxActivationInhibitedOutOfSyncGroups = (Integer)FeatureFlags.flagValue(source, appId, Flags.MAX_ACTIVATION_INHIBITED_OUT_OF_SYNC_GROUPS);
            this.jvmOmitStackTraceInFastThrow = type -> FeatureFlags.flagValueAsInt(source, appId, type, PermanentFlags.JVM_OMIT_STACK_TRACE_IN_FAST_THROW);
            this.maxConcurrentMergesPerContentNode = (Integer)FeatureFlags.flagValue(source, appId, Flags.MAX_CONCURRENT_MERGES_PER_NODE);
            this.maxMergeQueueSize = (Integer)FeatureFlags.flagValue(source, appId, Flags.MAX_MERGE_QUEUE_SIZE);
            this.resourceLimitDisk = (Double)FeatureFlags.flagValue(source, appId, PermanentFlags.RESOURCE_LIMIT_DISK);
            this.resourceLimitMemory = (Double)FeatureFlags.flagValue(source, appId, PermanentFlags.RESOURCE_LIMIT_MEMORY);
            this.minNodeRatioPerGroup = (Double)FeatureFlags.flagValue(source, appId, Flags.MIN_NODE_RATIO_PER_GROUP);
            this.metricsproxyNumThreads = (Integer)FeatureFlags.flagValue(source, appId, Flags.METRICSPROXY_NUM_THREADS);
            this.availableProcessors = (Integer)FeatureFlags.flagValue(source, appId, Flags.AVAILABLE_PROCESSORS);
            this.containerDumpHeapOnShutdownTimeout = (Boolean)FeatureFlags.flagValue(source, appId, Flags.CONTAINER_DUMP_HEAP_ON_SHUTDOWN_TIMEOUT);
            this.containerShutdownTimeout = (Double)FeatureFlags.flagValue(source, appId, Flags.CONTAINER_SHUTDOWN_TIMEOUT);
            this.maxUnCommittedMemory = (Integer)FeatureFlags.flagValue(source, appId, Flags.MAX_UNCOMMITTED_MEMORY);
            this.forwardIssuesAsErrors = (Boolean)FeatureFlags.flagValue(source, appId, PermanentFlags.FORWARD_ISSUES_AS_ERRORS);
            this.ignoreThreadStackSizes = (Boolean)FeatureFlags.flagValue(source, appId, Flags.IGNORE_THREAD_STACK_SIZES);
            this.unorderedMergeChaining = (Boolean)FeatureFlags.flagValue(source, appId, Flags.UNORDERED_MERGE_CHAINING);
            this.useV8GeoPositions = (Boolean)FeatureFlags.flagValue(source, appId, Flags.USE_V8_GEO_POSITIONS);
            this.useV8DocManagerCfg = (Boolean)FeatureFlags.flagValue(source, appId, Flags.USE_V8_DOC_MANAGER_CFG);
            this.maxCompactBuffers = (Integer)FeatureFlags.flagValue(source, appId, Flags.MAX_COMPACT_BUFFERS);
            this.failDeploymentWithInvalidJvmOptions = (Boolean)FeatureFlags.flagValue(source, appId, Flags.FAIL_DEPLOYMENT_WITH_INVALID_JVM_OPTIONS);
            this.ignoredHttpUserAgents = (List)FeatureFlags.flagValue(source, appId, PermanentFlags.IGNORED_HTTP_USER_AGENTS);
            this.enableServerOcspStapling = (Boolean)FeatureFlags.flagValue(source, appId, Flags.ENABLE_SERVER_OCSP_STAPLING);
            this.persistenceAsyncThrottling = (String)FeatureFlags.flagValue(source, appId, Flags.PERSISTENCE_ASYNC_THROTTLING);
            this.mergeThrottlingPolicy = (String)FeatureFlags.flagValue(source, appId, Flags.MERGE_THROTTLING_POLICY);
            this.persistenceThrottlingWsDecrementFactor = (Double)FeatureFlags.flagValue(source, appId, Flags.PERSISTENCE_THROTTLING_WS_DECREMENT_FACTOR);
            this.persistenceThrottlingWsBackoff = (Double)FeatureFlags.flagValue(source, appId, Flags.PERSISTENCE_THROTTLING_WS_BACKOFF);
            this.inhibitDefaultMergesWhenGlobalMergesPending = (Boolean)FeatureFlags.flagValue(source, appId, Flags.INHIBIT_DEFAULT_MERGES_WHEN_GLOBAL_MERGES_PENDING);
            this.useQrserverServiceName = (Boolean)FeatureFlags.flagValue(source, appId, Flags.USE_QRSERVER_SERVICE_NAME);
            this.avoidRenamingSummaryFeatures = (Boolean)FeatureFlags.flagValue(source, appId, Flags.AVOID_RENAMING_SUMMARY_FEATURES);
        }

        public double defaultTermwiseLimit() {
            return this.defaultTermwiseLimit;
        }

        public boolean useThreePhaseUpdates() {
            return this.useThreePhaseUpdates;
        }

        public String feedSequencerType() {
            return this.feedSequencer;
        }

        public int feedTaskLimit() {
            return this.feedTaskLimit;
        }

        public int feedMasterTaskLimit() {
            return this.feedMasterTaskLimit;
        }

        public String sharedFieldWriterExecutor() {
            return this.sharedFieldWriterExecutor;
        }

        public String responseSequencerType() {
            return this.responseSequencer;
        }

        public int defaultNumResponseThreads() {
            return this.numResponseThreads;
        }

        public boolean skipCommunicationManagerThread() {
            return this.skipCommunicationManagerThread;
        }

        public boolean skipMbusRequestThread() {
            return this.skipMbusRequestThread;
        }

        public boolean skipMbusReplyThread() {
            return this.skipMbusReplyThread;
        }

        public boolean useAsyncMessageHandlingOnSchedule() {
            return this.useAsyncMessageHandlingOnSchedule;
        }

        public double feedConcurrency() {
            return this.feedConcurrency;
        }

        public List<String> allowedAthenzProxyIdentities() {
            return this.allowedAthenzProxyIdentities;
        }

        public int maxActivationInhibitedOutOfSyncGroups() {
            return this.maxActivationInhibitedOutOfSyncGroups;
        }

        public String jvmOmitStackTraceInFastThrowOption(ClusterSpec.Type type) {
            return this.translateJvmOmitStackTraceInFastThrowIntToString(this.jvmOmitStackTraceInFastThrow, type);
        }

        public int maxConcurrentMergesPerNode() {
            return this.maxConcurrentMergesPerContentNode;
        }

        public int maxMergeQueueSize() {
            return this.maxMergeQueueSize;
        }

        public double resourceLimitDisk() {
            return this.resourceLimitDisk;
        }

        public double resourceLimitMemory() {
            return this.resourceLimitMemory;
        }

        public double minNodeRatioPerGroup() {
            return this.minNodeRatioPerGroup;
        }

        public int defaultPoolNumThreads() {
            return this.metricsproxyNumThreads;
        }

        public int availableProcessors() {
            return this.availableProcessors;
        }

        public double containerShutdownTimeout() {
            return this.containerShutdownTimeout;
        }

        public boolean containerDumpHeapOnShutdownTimeout() {
            return this.containerDumpHeapOnShutdownTimeout;
        }

        public int maxUnCommittedMemory() {
            return this.maxUnCommittedMemory;
        }

        public boolean forwardIssuesAsErrors() {
            return this.forwardIssuesAsErrors;
        }

        public boolean ignoreThreadStackSizes() {
            return this.ignoreThreadStackSizes;
        }

        public boolean unorderedMergeChaining() {
            return this.unorderedMergeChaining;
        }

        public boolean useV8GeoPositions() {
            return this.useV8GeoPositions;
        }

        public boolean useV8DocManagerCfg() {
            return this.useV8DocManagerCfg;
        }

        public boolean failDeploymentWithInvalidJvmOptions() {
            return this.failDeploymentWithInvalidJvmOptions;
        }

        public int maxCompactBuffers() {
            return this.maxCompactBuffers;
        }

        public List<String> ignoredHttpUserAgents() {
            return this.ignoredHttpUserAgents;
        }

        public boolean enableServerOcspStapling() {
            return this.enableServerOcspStapling;
        }

        public String persistenceAsyncThrottling() {
            return this.persistenceAsyncThrottling;
        }

        public String mergeThrottlingPolicy() {
            return this.mergeThrottlingPolicy;
        }

        public double persistenceThrottlingWsDecrementFactor() {
            return this.persistenceThrottlingWsDecrementFactor;
        }

        public double persistenceThrottlingWsBackoff() {
            return this.persistenceThrottlingWsBackoff;
        }

        public boolean inhibitDefaultMergesWhenGlobalMergesPending() {
            return this.inhibitDefaultMergesWhenGlobalMergesPending;
        }

        public boolean useQrserverServiceName() {
            return this.useQrserverServiceName;
        }

        public boolean avoidRenamingSummaryFeatures() {
            return this.avoidRenamingSummaryFeatures;
        }

        private static <V> V flagValue(FlagSource source, ApplicationId appId, UnboundFlag<? extends V, ?, ?> flag) {
            return (V)((Flag)flag.bindTo(source).with(FetchVector.Dimension.APPLICATION_ID, appId.serializedForm())).boxedValue();
        }

        private static <V> V flagValue(FlagSource source, TenantName tenant, UnboundFlag<? extends V, ?, ?> flag) {
            return (V)((Flag)flag.bindTo(source).with(FetchVector.Dimension.TENANT_ID, tenant.value())).boxedValue();
        }

        private static <V> V flagValue(FlagSource source, ApplicationId appId, ClusterSpec.Type clusterType, UnboundFlag<? extends V, ?, ?> flag) {
            return (V)((Flag)((Flag)flag.bindTo(source).with(FetchVector.Dimension.APPLICATION_ID, appId.serializedForm())).with(FetchVector.Dimension.CLUSTER_TYPE, clusterType.name())).boxedValue();
        }

        static int flagValueAsInt(FlagSource source, ApplicationId appId, ClusterSpec.Type clusterType, UnboundFlag<? extends Boolean, ?, ?> flag) {
            return FeatureFlags.flagValue(source, appId, clusterType, flag) != false ? 1 : 0;
        }

        private String translateJvmOmitStackTraceInFastThrowIntToString(ToIntFunction<ClusterSpec.Type> function, ClusterSpec.Type clusterType) {
            return function.applyAsInt(clusterType) == 1 ? "" : "-XX:-OmitStackTraceInFastThrow";
        }
    }
}

