/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.server.http;

import com.yahoo.container.jdisc.HttpRequest;
import com.yahoo.container.jdisc.ThreadedHttpRequestHandler;
import com.yahoo.jdisc.application.BindingMatch;
import com.yahoo.vespa.config.server.ApplicationRepository;
import com.yahoo.vespa.config.server.TimeoutBudget;
import com.yahoo.vespa.config.server.http.BadRequestException;
import com.yahoo.vespa.config.server.http.HttpHandler;
import com.yahoo.vespa.config.server.http.Utils;
import java.time.Clock;
import java.time.Duration;

public class SessionHandler
extends HttpHandler {
    protected final ApplicationRepository applicationRepository;

    public SessionHandler(ThreadedHttpRequestHandler.Context ctx, ApplicationRepository applicationRepository) {
        super(ctx);
        this.applicationRepository = applicationRepository;
    }

    public static String getRawSessionIdV2(HttpRequest request) {
        String path = request.getUri().toString();
        BindingMatch<?> bm = Utils.getBindingMatch(request, "http://*/application/v2/tenant/*/session/*/*");
        if (bm.groupCount() < 4) {
            throw new IllegalArgumentException("Can not get session id from request '" + path + "'");
        }
        return bm.group(3);
    }

    public static Long getSessionIdV2(HttpRequest request) {
        try {
            return Long.parseLong(SessionHandler.getRawSessionIdV2(request));
        }
        catch (NumberFormatException e) {
            throw SessionHandler.createSessionException(request);
        }
    }

    private static BadRequestException createSessionException(HttpRequest request) {
        return new BadRequestException("Session id in request is not a number, request was '" + request.getUri().toString() + "'");
    }

    public static TimeoutBudget getTimeoutBudget(HttpRequest request, Duration defaultTimeout) {
        return SessionHandler.getTimeoutBudget(SessionHandler.getRequestTimeout(request, defaultTimeout));
    }

    public static TimeoutBudget getTimeoutBudget(Duration requestTimeout) {
        return new TimeoutBudget(Clock.systemUTC(), requestTimeout);
    }

    protected static boolean shouldIgnoreSessionStaleFailure(HttpRequest request) {
        return request.getBooleanProperty("force");
    }
}

