/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.server.http.v2;

import com.google.inject.Inject;
import com.yahoo.config.application.api.ApplicationFile;
import com.yahoo.config.provision.TenantName;
import com.yahoo.container.jdisc.HttpRequest;
import com.yahoo.container.jdisc.HttpResponse;
import com.yahoo.container.jdisc.ThreadedHttpRequestHandler;
import com.yahoo.vespa.config.server.ApplicationRepository;
import com.yahoo.vespa.config.server.http.ContentHandler;
import com.yahoo.vespa.config.server.http.ContentRequest;
import com.yahoo.vespa.config.server.http.SessionHandler;
import com.yahoo.vespa.config.server.http.Utils;
import com.yahoo.vespa.config.server.http.v2.request.SessionContentRequestV2;

public class SessionContentHandler
extends SessionHandler {
    private final ContentHandler contentHandler = new ContentHandler();

    @Inject
    public SessionContentHandler(ThreadedHttpRequestHandler.Context ctx, ApplicationRepository applicationRepository) {
        super(ctx, applicationRepository);
    }

    @Override
    public HttpResponse handleGET(HttpRequest request) {
        return this.contentHandler.get(this.getContentRequest(request));
    }

    @Override
    public HttpResponse handlePUT(HttpRequest request) {
        return this.contentHandler.put(this.getContentRequest(request));
    }

    @Override
    public HttpResponse handleDELETE(HttpRequest request) {
        return this.contentHandler.delete(this.getContentRequest(request));
    }

    private void validateRequest(TenantName tenantName) {
        Utils.checkThatTenantExists(this.applicationRepository.tenantRepository(), tenantName);
    }

    private SessionContentRequestV2 getContentRequest(HttpRequest request) {
        TenantName tenantName = Utils.getTenantNameFromSessionRequest(request);
        this.validateRequest(tenantName);
        long sessionId = SessionContentHandler.getSessionIdV2(request);
        String contentPath = SessionContentRequestV2.getContentPath(request);
        ApplicationFile applicationFile = this.applicationRepository.getApplicationFileFromSession(tenantName, sessionId, contentPath, ContentRequest.getApplicationFileMode(request.getMethod()));
        return new SessionContentRequestV2(request, sessionId, tenantName, contentPath, applicationFile);
    }
}

