/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.server.http.v2;

import com.google.inject.Inject;
import com.yahoo.cloud.config.ConfigserverConfig;
import com.yahoo.config.provision.TenantName;
import com.yahoo.container.jdisc.HttpRequest;
import com.yahoo.container.jdisc.HttpResponse;
import com.yahoo.container.jdisc.ThreadedHttpRequestHandler;
import com.yahoo.vespa.config.server.ApplicationRepository;
import com.yahoo.vespa.config.server.http.SessionHandler;
import com.yahoo.vespa.config.server.http.Utils;
import com.yahoo.vespa.config.server.http.v2.PrepareResult;
import com.yahoo.vespa.config.server.http.v2.response.SessionPrepareResponse;
import com.yahoo.vespa.config.server.session.PrepareParams;
import com.yahoo.vespa.config.server.tenant.Tenant;
import com.yahoo.vespa.config.server.tenant.TenantRepository;
import java.time.Duration;

public class SessionPrepareHandler
extends SessionHandler {
    private final TenantRepository tenantRepository;
    private final Duration zookeeperBarrierTimeout;

    @Inject
    public SessionPrepareHandler(ThreadedHttpRequestHandler.Context ctx, ApplicationRepository applicationRepository, ConfigserverConfig configserverConfig) {
        super(ctx, applicationRepository);
        this.tenantRepository = applicationRepository.tenantRepository();
        this.zookeeperBarrierTimeout = Duration.ofSeconds(configserverConfig.zookeeper().barrierTimeout());
    }

    @Override
    protected HttpResponse handlePUT(HttpRequest request) {
        long sessionId = SessionPrepareHandler.getSessionIdV2(request);
        TenantName tenantName = this.getExistingTenant(request).getName();
        PrepareParams prepareParams = PrepareParams.fromHttpRequest(request, tenantName, this.zookeeperBarrierTimeout);
        PrepareResult result = this.applicationRepository.prepare(sessionId, prepareParams);
        return new SessionPrepareResponse(result, tenantName, request);
    }

    @Override
    protected HttpResponse handleGET(HttpRequest request) {
        Tenant tenant = this.getExistingTenant(request);
        long sessionId = SessionPrepareHandler.getSessionIdV2(request);
        this.applicationRepository.validateThatSessionIsNotActive(tenant, sessionId);
        this.applicationRepository.validateThatSessionIsPrepared(tenant, sessionId);
        return new SessionPrepareResponse(tenant.getName(), request, sessionId);
    }

    public Duration getTimeout() {
        return this.zookeeperBarrierTimeout.plus(Duration.ofSeconds(10L));
    }

    private Tenant getExistingTenant(HttpRequest request) {
        TenantName tenantName = Utils.getTenantNameFromSessionRequest(request);
        Utils.checkThatTenantExists(this.tenantRepository, tenantName);
        return this.tenantRepository.getTenant(tenantName);
    }
}

