/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.server.http;

import com.google.inject.Inject;
import com.yahoo.config.provision.ApplicationId;
import com.yahoo.container.jdisc.HttpRequest;
import com.yahoo.container.jdisc.HttpResponse;
import com.yahoo.container.jdisc.ThreadedHttpRequestHandler;
import com.yahoo.slime.Cursor;
import com.yahoo.slime.JsonFormat;
import com.yahoo.slime.Slime;
import com.yahoo.vespa.config.ConfigKey;
import com.yahoo.vespa.config.server.RequestHandler;
import com.yahoo.vespa.config.server.http.HttpHandler;
import com.yahoo.vespa.config.server.http.Utils;
import com.yahoo.vespa.config.server.tenant.TenantRepository;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;

public class HttpListConfigsHandler
extends HttpHandler {
    static final String RECURSIVE_QUERY_PROPERTY = "recursive";
    private final RequestHandler requestHandler;

    @Inject
    public HttpListConfigsHandler(ThreadedHttpRequestHandler.Context ctx, TenantRepository tenantRepository) {
        this(ctx, tenantRepository.defaultTenant().getRequestHandler());
    }

    public HttpListConfigsHandler(ThreadedHttpRequestHandler.Context ctx, RequestHandler requestHandler) {
        super(ctx);
        this.requestHandler = requestHandler;
    }

    @Override
    public HttpResponse handleGET(HttpRequest req) {
        boolean recursive = req.getBooleanProperty(RECURSIVE_QUERY_PROPERTY);
        Set<ConfigKey<?>> configs = this.requestHandler.listConfigs(ApplicationId.defaultId(), Optional.empty(), recursive);
        String urlBase = Utils.getUrlBase(req, "/config/v1/");
        Set<ConfigKey<?>> allConfigs = this.requestHandler.allConfigsProduced(ApplicationId.defaultId(), Optional.empty());
        return new ListConfigsResponse(configs, allConfigs, urlBase, recursive);
    }

    static class ListConfigsResponse
    extends HttpResponse {
        private final List<ConfigKey<?>> configs;
        private final Set<ConfigKey<?>> allConfigs;
        private final String urlBase;
        private final boolean recursive;

        public ListConfigsResponse(Set<ConfigKey<?>> configs, Set<ConfigKey<?>> allConfigs, String urlBase, boolean recursive) {
            super(200);
            this.configs = new ArrayList(configs);
            Collections.sort(this.configs);
            this.allConfigs = allConfigs;
            this.urlBase = urlBase;
            this.recursive = recursive;
        }

        String toUrl(ConfigKey<?> key, boolean rec) {
            return this.urlBase + key.getNamespace() + "." + key.getName() + "/" + key.getConfigId() + (rec ? "" : "/");
        }

        public void render(OutputStream outputStream) throws IOException {
            Cursor array;
            Slime slime = new Slime();
            Cursor root = slime.setObject();
            if (!this.recursive) {
                array = root.setArray("children");
                for (ConfigKey<?> key : ListConfigsResponse.keysThatHaveAChildWithSameName(this.configs, this.allConfigs)) {
                    array.addString(this.toUrl(key, false));
                }
            }
            array = root.setArray("configs");
            for (ConfigKey<?> key : this.configs) {
                array.addString(this.toUrl(key, true));
            }
            new JsonFormat(true).encode(outputStream, slime);
        }

        static Set<ConfigKey<?>> keysThatHaveAChildWithSameName(Collection<ConfigKey<?>> keys, Set<ConfigKey<?>> allConfigs) {
            LinkedHashSet ret = new LinkedHashSet();
            for (ConfigKey<?> k : keys) {
                if (!ListConfigsResponse.hasAChild(k, allConfigs)) continue;
                ret.add(k);
            }
            return ret;
        }

        static boolean hasAChild(ConfigKey<?> key, Set<ConfigKey<?>> keys) {
            if ("".equals(key.getConfigId())) {
                return false;
            }
            for (ConfigKey<?> k : keys) {
                if (!k.getName().equals(key.getName()) || "".equals(k.getConfigId()) || k.getConfigId().equals(key.getConfigId()) || !k.getConfigId().startsWith(key.getConfigId())) continue;
                return true;
            }
            return false;
        }

        public String getContentType() {
            return "application/json";
        }
    }
}

