/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.server.modelfactory;

import com.google.inject.Inject;
import com.yahoo.component.Version;
import com.yahoo.component.provider.ComponentRegistry;
import com.yahoo.config.model.api.ModelFactory;
import com.yahoo.vespa.config.server.http.UnknownVespaVersionException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ModelFactoryRegistry {
    private final Map<Version, ModelFactory> factories = new HashMap<Version, ModelFactory>();

    @Inject
    public ModelFactoryRegistry(ComponentRegistry<ModelFactory> factories) {
        this(factories.allComponents());
    }

    public ModelFactoryRegistry(List<ModelFactory> modelFactories) {
        if (modelFactories.isEmpty()) {
            throw new IllegalArgumentException("No ModelFactory instances registered, cannot build config models");
        }
        for (ModelFactory factory : modelFactories) {
            this.factories.put(factory.version(), factory);
        }
    }

    public Set<Version> allVersions() {
        return this.factories.keySet();
    }

    public ModelFactory getFactory(Version version) {
        if (!this.factories.containsKey(version)) {
            throw new UnknownVespaVersionException("Unknown Vespa version '" + version + "', cannot build config model for this version, known versions: " + this.allVersions());
        }
        return this.factories.get(version);
    }

    public Collection<ModelFactory> getFactories() {
        return Collections.unmodifiableCollection(this.factories.values());
    }
}

