/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.server.monitoring;

import com.google.inject.Inject;
import com.yahoo.cloud.config.ZookeeperServerConfig;
import com.yahoo.component.AbstractComponent;
import com.yahoo.concurrent.DaemonThreadFactory;
import com.yahoo.config.provision.ApplicationId;
import com.yahoo.config.provision.TenantName;
import com.yahoo.container.jdisc.config.HealthMonitorConfig;
import com.yahoo.docproc.jdisc.metric.NullMetric;
import com.yahoo.jdisc.Metric;
import com.yahoo.vespa.config.server.monitoring.MetricUpdater;
import com.yahoo.vespa.config.server.monitoring.MetricUpdaterFactory;
import com.yahoo.vespa.config.server.monitoring.ZKMetricUpdater;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Metrics
extends AbstractComponent
implements MetricUpdaterFactory,
Runnable {
    private static final Logger log = Logger.getLogger(Metrics.class.getName());
    private static final String METRIC_REQUESTS = Metrics.getMetricName("requests");
    private static final String METRIC_FAILED_REQUESTS = Metrics.getMetricName("failedRequests");
    private static final String METRIC_FREE_MEMORY = Metrics.getMetricName("freeMemory");
    private static final String METRIC_LATENCY = Metrics.getMetricName("latency");
    private final Metric metric;
    private final Optional<ZKMetricUpdater> zkMetricUpdater;
    private final Map<Map<String, String>, MetricUpdater> metricUpdaters = new ConcurrentHashMap<Map<String, String>, MetricUpdater>();
    private final Optional<ScheduledExecutorService> executorService;

    @Inject
    public Metrics(Metric metric, HealthMonitorConfig healthMonitorConfig, ZookeeperServerConfig zkServerConfig) {
        this(metric, healthMonitorConfig, zkServerConfig, true);
    }

    private Metrics(Metric metric, HealthMonitorConfig healthMonitorConfig, ZookeeperServerConfig zkServerConfig, boolean createZkMetricUpdater) {
        this.metric = metric;
        if (createZkMetricUpdater) {
            log.log(Level.FINE, () -> "Metric update interval is " + healthMonitorConfig.snapshot_interval() + " seconds");
            long intervalMs = (long)(healthMonitorConfig.snapshot_interval() * 1000.0);
            this.executorService = Optional.of(new ScheduledThreadPoolExecutor(1, (ThreadFactory)new DaemonThreadFactory("configserver-metrics")));
            this.executorService.get().scheduleAtFixedRate(this, 20000L, intervalMs, TimeUnit.MILLISECONDS);
            this.zkMetricUpdater = Optional.of(new ZKMetricUpdater(zkServerConfig, 19500L, intervalMs));
        } else {
            this.executorService = Optional.empty();
            this.zkMetricUpdater = Optional.empty();
        }
    }

    public static Metrics createTestMetrics() {
        NullMetric metric = new NullMetric();
        HealthMonitorConfig.Builder builder = new HealthMonitorConfig.Builder();
        builder.snapshot_interval(60.0);
        ZookeeperServerConfig.Builder zkBuilder = new ZookeeperServerConfig.Builder().myid(1);
        return new Metrics((Metric)metric, new HealthMonitorConfig(builder), new ZookeeperServerConfig(zkBuilder), false);
    }

    void incrementRequests(Metric.Context metricContext) {
        this.metric.add(METRIC_REQUESTS, (Number)1, metricContext);
    }

    void incrementFailedRequests(Metric.Context metricContext) {
        this.metric.add(METRIC_FAILED_REQUESTS, (Number)1, metricContext);
    }

    void incrementProcTime(long increment, Metric.Context metricContext) {
        this.metric.set(METRIC_LATENCY, (Number)increment, metricContext);
    }

    public Metric getMetric() {
        return this.metric;
    }

    public MetricUpdater removeMetricUpdater(Map<String, String> dimensions) {
        return this.metricUpdaters.remove(dimensions);
    }

    public static Map<String, String> createDimensions(ApplicationId applicationId) {
        LinkedHashMap<String, String> properties = new LinkedHashMap<String, String>();
        properties.put("tenantName", applicationId.tenant().value());
        properties.put("applicationName", applicationId.application().value());
        properties.put("applicationInstance", applicationId.instance().value());
        return properties;
    }

    public static Map<String, String> createDimensions(TenantName tenant) {
        LinkedHashMap<String, String> properties = new LinkedHashMap<String, String>();
        properties.put("tenantName", tenant.value());
        return properties;
    }

    @Override
    public synchronized MetricUpdater getOrCreateMetricUpdater(Map<String, String> dimensions) {
        if (this.metricUpdaters.containsKey(dimensions)) {
            return this.metricUpdaters.get(dimensions);
        }
        MetricUpdater metricUpdater = new MetricUpdater(this, dimensions);
        this.metricUpdaters.put(dimensions, metricUpdater);
        return metricUpdater;
    }

    @Override
    public void run() {
        for (MetricUpdater metricUpdater : this.metricUpdaters.values()) {
            log.log(Level.FINE, () -> "Running metric updater for static values for " + metricUpdater.getDimensions());
            for (Map.Entry<String, Number> fixedMetric : metricUpdater.getStaticMetrics().entrySet()) {
                log.log(Level.FINE, () -> "Setting " + (String)fixedMetric.getKey());
                this.metric.set(fixedMetric.getKey(), fixedMetric.getValue(), metricUpdater.getMetricContext());
            }
        }
        this.setRegularMetrics();
        this.zkMetricUpdater.ifPresent(updater -> updater.getZKMetrics().forEach((attr, val) -> this.metric.set(attr, (Number)val, null)));
    }

    public void deconstruct() {
        this.executorService.ifPresent(ExecutorService::shutdown);
        this.zkMetricUpdater.ifPresent(ZKMetricUpdater::shutdown);
    }

    private void setRegularMetrics() {
        this.metric.set(METRIC_FREE_MEMORY, (Number)Runtime.getRuntime().freeMemory(), null);
    }

    void increment(String metricName, Metric.Context context) {
        this.metric.add(metricName, (Number)1, context);
    }

    void set(String metricName, Number value, Metric.Context context) {
        this.metric.set(metricName, value, context);
    }

    static String getMetricName(String name) {
        return "configserver." + name;
    }
}

