/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.server.rpc.security;

import com.google.inject.Inject;
import com.yahoo.concurrent.DaemonThreadFactory;
import com.yahoo.config.FileReference;
import com.yahoo.config.provision.ApplicationId;
import com.yahoo.config.provision.TenantName;
import com.yahoo.config.provision.security.NodeIdentifier;
import com.yahoo.config.provision.security.NodeIdentifierException;
import com.yahoo.config.provision.security.NodeIdentity;
import com.yahoo.jrt.Request;
import com.yahoo.jrt.SecurityContext;
import com.yahoo.log.LogLevel;
import com.yahoo.security.tls.MixedMode;
import com.yahoo.security.tls.TransportSecurityUtils;
import com.yahoo.vespa.config.ConfigKey;
import com.yahoo.vespa.config.protocol.JRTServerConfigRequestV3;
import com.yahoo.vespa.config.server.RequestHandler;
import com.yahoo.vespa.config.server.host.HostRegistries;
import com.yahoo.vespa.config.server.host.HostRegistry;
import com.yahoo.vespa.config.server.rpc.security.AuthorizationException;
import com.yahoo.vespa.config.server.rpc.security.GlobalConfigAuthorizationPolicy;
import com.yahoo.vespa.config.server.rpc.security.RpcAuthorizer;
import com.yahoo.vespa.config.server.tenant.Tenant;
import com.yahoo.vespa.config.server.tenant.TenantRepository;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.function.BiConsumer;
import java.util.logging.Logger;

public class MultiTenantRpcAuthorizer
implements RpcAuthorizer {
    private static final Logger log = Logger.getLogger(MultiTenantRpcAuthorizer.class.getName());
    private final NodeIdentifier nodeIdentifier;
    private final HostRegistry<TenantName> hostRegistry;
    private final TenantRepository tenantRepository;
    private final Executor executor;
    private final Mode mode;

    @Inject
    public MultiTenantRpcAuthorizer(NodeIdentifier nodeIdentifier, HostRegistries hostRegistries, TenantRepository tenantRepository) {
        this(nodeIdentifier, hostRegistries.getTenantHostRegistry(), tenantRepository, Executors.newFixedThreadPool(4, (ThreadFactory)new DaemonThreadFactory("RPC-Authorizer-")), Mode.LOG_ONLY);
    }

    MultiTenantRpcAuthorizer(NodeIdentifier nodeIdentifier, HostRegistry<TenantName> hostRegistry, TenantRepository tenantRepository, Executor executor, Mode mode) {
        this.nodeIdentifier = nodeIdentifier;
        this.hostRegistry = hostRegistry;
        this.tenantRepository = tenantRepository;
        this.executor = executor;
        this.mode = mode;
    }

    @Override
    public CompletableFuture<Void> authorizeConfigRequest(Request request) {
        return this.doAsyncAuthorization(request, this::doConfigRequestAuthorization);
    }

    @Override
    public CompletableFuture<Void> authorizeFileRequest(Request request) {
        return this.doAsyncAuthorization(request, this::doFileRequestAuthorization);
    }

    private CompletableFuture<Void> doAsyncAuthorization(Request request, BiConsumer<Request, NodeIdentity> authorizer) {
        return CompletableFuture.runAsync(() -> this.getPeerIdentity(request).ifPresent(peerIdentity -> {
            try {
                authorizer.accept(request, (NodeIdentity)peerIdentity);
            }
            catch (Throwable t) {
                this.handleAuthorizationFailure(request, t);
            }
        }), this.executor);
    }

    private void doConfigRequestAuthorization(Request request, NodeIdentity peerIdentity) {
        switch (peerIdentity.nodeType()) {
            case config: {
                return;
            }
            case proxy: 
            case tenant: 
            case host: {
                JRTServerConfigRequestV3 configRequest = JRTServerConfigRequestV3.createFromRequest((Request)request);
                ConfigKey configKey = configRequest.getConfigKey();
                if (MultiTenantRpcAuthorizer.isConfigKeyForGlobalConfig(configKey)) {
                    GlobalConfigAuthorizationPolicy.verifyAccessAllowed(configKey, peerIdentity.nodeType());
                    return;
                }
                String hostname = configRequest.getClientHostName();
                Optional tenantHandler = Optional.of(this.hostRegistry.getKeyForHost(hostname)).flatMap(this::getTenantHandler);
                if (tenantHandler.isEmpty()) {
                    return;
                }
                ApplicationId resolvedApplication = ((RequestHandler)tenantHandler.get()).resolveApplicationId(hostname);
                ApplicationId peerOwner = MultiTenantRpcAuthorizer.applicationId(peerIdentity);
                if (peerOwner.equals((Object)resolvedApplication)) {
                    return;
                }
                throw new AuthorizationException(String.format("Peer is not allowed to access config for owned by %s. Peer is owned by %s", resolvedApplication.toShortString(), peerOwner.toShortString()));
            }
        }
        throw new AuthorizationException(String.format("'%s' nodes are not allowed to access config", peerIdentity.nodeType()));
    }

    private void doFileRequestAuthorization(Request request, NodeIdentity peerIdentity) {
        switch (peerIdentity.nodeType()) {
            case config: {
                return;
            }
            case proxy: 
            case tenant: 
            case host: {
                ApplicationId peerOwner = MultiTenantRpcAuthorizer.applicationId(peerIdentity);
                FileReference requestedFile = new FileReference(request.parameters().get(0).asString());
                RequestHandler tenantHandler = this.getTenantHandler(peerOwner.tenant()).orElseThrow(() -> new AuthorizationException(String.format("Application '%s' does not exist - unable to verify file ownership for '%s'", peerOwner.toShortString(), requestedFile.value())));
                Set<FileReference> filesOwnedByApplication = tenantHandler.listFileReferences(peerOwner);
                if (filesOwnedByApplication.contains(requestedFile)) {
                    return;
                }
                throw new AuthorizationException("Peer is not allowed to access file " + requestedFile.value());
            }
        }
        throw new AuthorizationException(String.format("'%s' nodes are not allowed to access files", peerIdentity.nodeType()));
    }

    private void handleAuthorizationFailure(Request request, Throwable throwable) {
        String errorMessage = String.format("For request from '%s': %s", request.target().toString(), throwable.getMessage());
        log.log(LogLevel.WARNING, errorMessage, throwable);
        if (this.mode == Mode.ENFORCE) {
            JrtErrorCode error = throwable instanceof AuthorizationException ? JrtErrorCode.UNAUTHORIZED : JrtErrorCode.AUTHORIZATION_FAILED;
            request.setError(error.code, errorMessage);
            request.returnRequest();
            MultiTenantRpcAuthorizer.throwUnchecked(throwable);
        }
    }

    private Optional<NodeIdentity> getPeerIdentity(Request request) {
        Optional securityContext = request.target().getSecurityContext();
        if (securityContext.isEmpty()) {
            if (TransportSecurityUtils.getInsecureMixedMode() == MixedMode.DISABLED) {
                throw new IllegalStateException("Security context missing");
            }
            return Optional.empty();
        }
        List certChain = ((SecurityContext)securityContext.get()).peerCertificateChain();
        if (certChain.isEmpty()) {
            throw new IllegalStateException("Client authentication is not enforced!");
        }
        try {
            return Optional.of(this.nodeIdentifier.identifyNode(certChain));
        }
        catch (NodeIdentifierException e) {
            throw new AuthorizationException("Failed to identity peer: " + e.getMessage(), e);
        }
    }

    private static boolean isConfigKeyForGlobalConfig(ConfigKey<?> configKey) {
        return "*".equals(configKey.getConfigId());
    }

    private static ApplicationId applicationId(NodeIdentity peerIdentity) {
        return (ApplicationId)peerIdentity.applicationId().orElseThrow(() -> new AuthorizationException("Peer node is not associated with an application"));
    }

    private Optional<RequestHandler> getTenantHandler(TenantName tenantName) {
        return Optional.ofNullable(this.tenantRepository.getTenant(tenantName)).map(Tenant::getRequestHandler);
    }

    private static <T extends Throwable> void throwUnchecked(Throwable t) throws T {
        throw t;
    }

    private static enum JrtErrorCode {
        UNAUTHORIZED(1),
        AUTHORIZATION_FAILED(2);

        final int code;

        private JrtErrorCode(int errorOffset) {
            this.code = 131072 + errorOffset;
        }
    }

    public static enum Mode {
        LOG_ONLY,
        ENFORCE;

    }
}

