/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.server.maintenance;

import com.yahoo.cloud.config.ConfigserverConfig;
import com.yahoo.config.FileReference;
import com.yahoo.config.provision.ApplicationId;
import com.yahoo.config.subscription.ConfigSourceSet;
import com.yahoo.jrt.Supervisor;
import com.yahoo.jrt.Transport;
import com.yahoo.vespa.config.JRTConnectionPool;
import com.yahoo.vespa.config.server.ApplicationRepository;
import com.yahoo.vespa.config.server.filedistribution.FileDistributionUtil;
import com.yahoo.vespa.config.server.maintenance.ConfigServerMaintainer;
import com.yahoo.vespa.config.server.session.Session;
import com.yahoo.vespa.config.server.session.SessionRepository;
import com.yahoo.vespa.config.server.tenant.Tenant;
import com.yahoo.vespa.curator.Curator;
import com.yahoo.vespa.defaults.Defaults;
import com.yahoo.vespa.filedistribution.FileDistributionConnectionPool;
import com.yahoo.vespa.filedistribution.FileDownloader;
import com.yahoo.vespa.filedistribution.FileReferenceDownload;
import com.yahoo.vespa.flags.BooleanFlag;
import com.yahoo.vespa.flags.FlagSource;
import com.yahoo.vespa.flags.Flags;
import java.io.File;
import java.time.Duration;
import java.util.List;
import java.util.logging.Logger;

public class ApplicationPackageMaintainer
extends ConfigServerMaintainer {
    private static final Logger log = Logger.getLogger(ApplicationPackageMaintainer.class.getName());
    private final ApplicationRepository applicationRepository;
    private final File downloadDirectory;
    private final ConfigserverConfig configserverConfig;
    private final Supervisor supervisor = new Supervisor(new Transport("filedistribution-pool")).setDropEmptyBuffers(true);
    private final FileDownloader fileDownloader;

    ApplicationPackageMaintainer(ApplicationRepository applicationRepository, Curator curator, Duration interval, FlagSource flagSource) {
        super(applicationRepository, curator, flagSource, applicationRepository.clock().instant(), interval, false);
        this.applicationRepository = applicationRepository;
        this.configserverConfig = applicationRepository.configserverConfig();
        this.downloadDirectory = new File(Defaults.getDefaults().underVespaHome(this.configserverConfig.fileReferencesDir()));
        boolean useFileDistributionConnectionPool = ((BooleanFlag)Flags.USE_FILE_DISTRIBUTION_CONNECTION_POOL.bindTo(flagSource)).value();
        this.fileDownloader = ApplicationPackageMaintainer.createFileDownloader(this.configserverConfig, useFileDistributionConnectionPool, this.downloadDirectory, this.supervisor);
    }

    protected double maintain() {
        if (FileDistributionUtil.getOtherConfigServersInCluster(this.configserverConfig).isEmpty()) {
            return 1.0;
        }
        int attempts = 0;
        int failures = 0;
        for (ApplicationId applicationId : this.applicationRepository.listApplications()) {
            FileReference appFileReference;
            log.finest(() -> "Verifying application package for " + applicationId);
            Session session = this.applicationRepository.getActiveSession(applicationId);
            if (session == null || (appFileReference = session.getApplicationPackageReference()) == null) continue;
            long sessionId = session.getSessionId();
            ++attempts;
            if (!FileDistributionUtil.fileReferenceExistsOnDisk(this.downloadDirectory, appFileReference)) {
                log.fine(() -> "Downloading application package for " + applicationId + " (session " + sessionId + ")");
                FileReferenceDownload download = new FileReferenceDownload(appFileReference, false, ((Object)((Object)this)).getClass().getSimpleName());
                if (this.fileDownloader.getFile(download).isEmpty()) {
                    ++failures;
                    log.info("Failed downloading application package (" + appFileReference + ") for " + applicationId + " (session " + sessionId + ")");
                    continue;
                }
            }
            this.createLocalSessionIfMissing(applicationId, sessionId);
        }
        return this.asSuccessFactor(attempts, failures);
    }

    private static FileDownloader createFileDownloader(ConfigserverConfig configserverConfig, boolean useFileDistributionConnectionPool, File downloadDirectory, Supervisor supervisor) {
        List<String> otherConfigServersInCluster = FileDistributionUtil.getOtherConfigServersInCluster(configserverConfig);
        ConfigSourceSet configSourceSet = new ConfigSourceSet(otherConfigServersInCluster);
        Object connectionPool = otherConfigServersInCluster.isEmpty() ? FileDownloader.emptyConnectionPool() : (useFileDistributionConnectionPool ? new FileDistributionConnectionPool(configSourceSet, supervisor) : new JRTConnectionPool(configSourceSet, supervisor));
        return new FileDownloader(connectionPool, supervisor, downloadDirectory, Duration.ofSeconds(30L));
    }

    public void awaitShutdown() {
        this.supervisor.transport().shutdown().join();
        this.fileDownloader.close();
        super.awaitShutdown();
    }

    private void createLocalSessionIfMissing(ApplicationId applicationId, long sessionId) {
        Tenant tenant = this.applicationRepository.getTenant(applicationId);
        SessionRepository sessionRepository = tenant.getSessionRepository();
        if (sessionRepository.getLocalSession(sessionId) == null) {
            sessionRepository.createLocalSessionFromDistributedApplicationPackage(sessionId);
        }
    }
}

