/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.server.http.v1;

import com.google.inject.Inject;
import com.yahoo.config.provision.ApplicationId;
import com.yahoo.config.provision.Deployer;
import com.yahoo.container.jdisc.LoggingRequestHandler;
import com.yahoo.jdisc.http.HttpRequest;
import com.yahoo.path.Path;
import com.yahoo.restapi.RestApi;
import com.yahoo.restapi.RestApiException;
import com.yahoo.restapi.RestApiRequestHandler;
import com.yahoo.restapi.SlimeJsonResponse;
import com.yahoo.slime.Cursor;
import com.yahoo.slime.Slime;
import com.yahoo.slime.SlimeUtils;
import com.yahoo.vespa.curator.Curator;
import com.yahoo.yolean.Exceptions;
import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;

public class RoutingStatusApiHandler
extends RestApiRequestHandler<RoutingStatusApiHandler> {
    private static final Logger log = Logger.getLogger(RoutingStatusApiHandler.class.getName());
    private static final Path ROUTING_ROOT = Path.fromString((String)"/routing/v1/");
    private static final Path DEPLOYMENT_STATUS_ROOT = ROUTING_ROOT.append("status");
    private static final Path ZONE_STATUS_ROOT = ROUTING_ROOT.append("zone-inactive");
    private final Curator curator;
    private final Clock clock;
    private final Deployer deployer;

    @Inject
    public RoutingStatusApiHandler(LoggingRequestHandler.Context context, Curator curator, Deployer deployer) {
        this(context, curator, Clock.systemUTC(), deployer);
    }

    RoutingStatusApiHandler(LoggingRequestHandler.Context context, Curator curator, Clock clock, Deployer deployer) {
        super(context, RoutingStatusApiHandler::createRestApiDefinition);
        this.curator = Objects.requireNonNull(curator);
        this.clock = Objects.requireNonNull(clock);
        this.deployer = Objects.requireNonNull(deployer);
    }

    private static RestApi createRestApiDefinition(RoutingStatusApiHandler self) {
        return RestApi.builder().addRoute(RestApi.route((String)"/routing/v1/status").get(self::listInactiveDeployments)).addRoute(RestApi.route((String)"/routing/v1/status/zone").get(self::zoneStatus).put(self::changeZoneStatus).delete(self::changeZoneStatus)).addRoute(RestApi.route((String)"/routing/v1/status/{upstreamName}").get(self::getDeploymentStatus).put(self::changeDeploymentStatus)).build();
    }

    private SlimeJsonResponse listInactiveDeployments(RestApi.RequestContext context) {
        List<String> inactiveDeployments = this.curator.getChildren(DEPLOYMENT_STATUS_ROOT).stream().filter(upstreamName -> this.deploymentStatus((String)upstreamName).status() == RoutingStatus.out).collect(Collectors.toUnmodifiableList());
        Slime slime = new Slime();
        Cursor rootArray = slime.setArray();
        inactiveDeployments.forEach(arg_0 -> ((Cursor)rootArray).addString(arg_0));
        return new SlimeJsonResponse(slime);
    }

    private SlimeJsonResponse getDeploymentStatus(RestApi.RequestContext context) {
        String upstreamName = RoutingStatusApiHandler.upstreamName(context);
        DeploymentRoutingStatus deploymentRoutingStatus = this.deploymentStatus(upstreamName);
        if (this.zoneStatus() == RoutingStatus.out) {
            String reason = String.format("Rotation is OUT because the zone is OUT (actual deployment status is %s)", deploymentRoutingStatus.status().name().toUpperCase(Locale.ENGLISH));
            deploymentRoutingStatus = new DeploymentRoutingStatus(RoutingStatus.out, "operator", reason, this.clock.instant());
        }
        return new SlimeJsonResponse(this.toSlime(deploymentRoutingStatus));
    }

    private SlimeJsonResponse changeDeploymentStatus(RestApi.RequestContext context) {
        String upstreamName = RoutingStatusApiHandler.upstreamName(context);
        ApplicationId instance = RoutingStatusApiHandler.instance(context);
        Path path = this.deploymentStatusPath(upstreamName);
        RestApi.RequestContext.RequestContent requestContent = context.requestContentOrThrow();
        Slime requestBody = (Slime)Exceptions.uncheck(() -> SlimeUtils.jsonToSlime((byte[])requestContent.content().readAllBytes()));
        DeploymentRoutingStatus wantedStatus = RoutingStatusApiHandler.deploymentRoutingStatusFromSlime(requestBody, this.clock.instant());
        DeploymentRoutingStatus currentStatus = this.deploymentStatus(upstreamName);
        if (wantedStatus.status() == currentStatus.status()) {
            return new SlimeJsonResponse(this.toSlime(currentStatus));
        }
        this.curator.set(path, this.toJsonBytes(wantedStatus));
        try {
            this.deployer.deployFromLocalActive(instance, Duration.ofMinutes(1L));
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "Failed to redeploy " + instance + ". Reverting routing status to " + currentStatus.status(), e);
            this.curator.set(path, this.toJsonBytes(currentStatus));
            throw new RestApiException.InternalServerError("Failed to change status to " + wantedStatus.status() + ", reverting to " + currentStatus.status() + " because redeployment of " + instance + " failed: " + Exceptions.toMessageString((Throwable)e));
        }
        return new SlimeJsonResponse(this.toSlime(wantedStatus));
    }

    private SlimeJsonResponse changeZoneStatus(RestApi.RequestContext context) {
        boolean in;
        boolean bl = in = context.request().getMethod() == HttpRequest.Method.DELETE;
        if (in) {
            this.curator.delete(ZONE_STATUS_ROOT);
            return new SlimeJsonResponse(RoutingStatusApiHandler.toSlime(RoutingStatus.in));
        }
        this.curator.create(ZONE_STATUS_ROOT);
        return new SlimeJsonResponse(RoutingStatusApiHandler.toSlime(RoutingStatus.out));
    }

    private SlimeJsonResponse zoneStatus(RestApi.RequestContext context) {
        return new SlimeJsonResponse(RoutingStatusApiHandler.toSlime(this.zoneStatus()));
    }

    private DeploymentRoutingStatus deploymentStatus(String upstreamName) {
        Instant changedAt = this.clock.instant();
        Path path = this.deploymentStatusPath(upstreamName);
        Optional data = this.curator.getData(path);
        if (data.isEmpty()) {
            return new DeploymentRoutingStatus(RoutingStatus.in, "", "", changedAt);
        }
        String agent = "";
        String reason = "";
        RoutingStatus status = RoutingStatus.out;
        if (((byte[])data.get()).length > 0) {
            Slime slime = SlimeUtils.jsonToSlime((byte[])((byte[])data.get()));
            Cursor root = slime.get();
            status = RoutingStatusApiHandler.asRoutingStatus(root.field("status").asString());
            agent = root.field("agent").asString();
            reason = root.field("cause").asString();
            changedAt = Instant.ofEpochSecond(root.field("lastUpdate").asLong());
        }
        return new DeploymentRoutingStatus(status, agent, reason, changedAt);
    }

    private RoutingStatus zoneStatus() {
        return this.curator.exists(ZONE_STATUS_ROOT) ? RoutingStatus.out : RoutingStatus.in;
    }

    protected Path deploymentStatusPath(String upstreamName) {
        return DEPLOYMENT_STATUS_ROOT.append(upstreamName);
    }

    private static String upstreamName(RestApi.RequestContext context) {
        String upstreamName = context.pathParameters().getStringOrThrow("upstreamName");
        if (upstreamName.contains(" ")) {
            throw new RestApiException.BadRequest("Invalid upstream name: '" + upstreamName + "'");
        }
        return upstreamName;
    }

    private static ApplicationId instance(RestApi.RequestContext context) {
        return context.queryParameters().getString("application").map(ApplicationId::fromSerializedForm).orElseThrow(() -> new RestApiException.BadRequest("Missing application parameter"));
    }

    private byte[] toJsonBytes(DeploymentRoutingStatus status) {
        return (byte[])Exceptions.uncheck(() -> SlimeUtils.toJsonBytes((Slime)this.toSlime(status)));
    }

    private Slime toSlime(DeploymentRoutingStatus status) {
        Slime slime = new Slime();
        Cursor root = slime.setObject();
        root.setString("status", RoutingStatusApiHandler.asString(status.status()));
        root.setString("cause", status.reason());
        root.setString("agent", status.agent());
        root.setLong("lastUpdate", status.changedAt().getEpochSecond());
        return slime;
    }

    private static Slime toSlime(RoutingStatus status) {
        Slime slime = new Slime();
        Cursor root = slime.setObject();
        root.setString("status", RoutingStatusApiHandler.asString(status));
        return slime;
    }

    private static RoutingStatus asRoutingStatus(String s) {
        switch (s) {
            case "IN": {
                return RoutingStatus.in;
            }
            case "OUT": {
                return RoutingStatus.out;
            }
        }
        throw new IllegalArgumentException("Unknown status: '" + s + "'");
    }

    private static String asString(RoutingStatus status) {
        switch (status) {
            case in: {
                return "IN";
            }
            case out: {
                return "OUT";
            }
        }
        throw new IllegalArgumentException("Unknown status: " + status);
    }

    private static DeploymentRoutingStatus deploymentRoutingStatusFromSlime(Slime slime, Instant changedAt) {
        Cursor root = slime.get();
        return new DeploymentRoutingStatus(RoutingStatusApiHandler.asRoutingStatus(root.field("status").asString()), root.field("agent").asString(), root.field("cause").asString(), changedAt);
    }

    private static enum RoutingStatus {
        in,
        out;

    }

    private static class DeploymentRoutingStatus {
        private final RoutingStatus status;
        private final String agent;
        private final String reason;
        private final Instant changedAt;

        public DeploymentRoutingStatus(RoutingStatus status, String agent, String reason, Instant changedAt) {
            this.status = Objects.requireNonNull(status);
            this.agent = Objects.requireNonNull(agent);
            this.reason = Objects.requireNonNull(reason);
            this.changedAt = Objects.requireNonNull(changedAt);
        }

        public RoutingStatus status() {
            return this.status;
        }

        public String agent() {
            return this.agent;
        }

        public String reason() {
            return this.reason;
        }

        public Instant changedAt() {
            return this.changedAt;
        }
    }
}

