/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.server.tenant;

import com.yahoo.config.model.api.ApplicationClusterEndpoint;
import com.yahoo.config.model.api.ContainerEndpoint;
import com.yahoo.slime.Cursor;
import com.yahoo.slime.Inspector;
import com.yahoo.slime.Slime;
import com.yahoo.slime.SlimeUtils;
import java.util.ArrayList;
import java.util.List;

public class ContainerEndpointSerializer {
    private static final String clusterIdField = "clusterId";
    private static final String scopeField = "scope";
    private static final String namesField = "names";

    private ContainerEndpointSerializer() {
    }

    public static ContainerEndpoint endpointFromSlime(Inspector inspector) {
        String clusterId = inspector.field(clusterIdField).asString();
        String scope = SlimeUtils.optionalString((Inspector)inspector.field(scopeField)).orElse(ApplicationClusterEndpoint.Scope.global.name());
        Inspector namesInspector = inspector.field(namesField);
        if (clusterId.isEmpty()) {
            throw new IllegalStateException("'clusterId' missing on serialized ContainerEndpoint");
        }
        if (scope.isEmpty()) {
            throw new IllegalStateException("'scope' missing on serialized ContainerEndpoint");
        }
        if (!namesInspector.valid()) {
            throw new IllegalStateException("'names' missing on serialized ContainerEndpoint");
        }
        ArrayList names = new ArrayList();
        namesInspector.traverse((idx, nameInspector) -> {
            String containerName = nameInspector.asString();
            names.add(containerName);
        });
        return new ContainerEndpoint(clusterId, ApplicationClusterEndpoint.Scope.valueOf((String)scope), names);
    }

    public static List<ContainerEndpoint> endpointListFromSlime(Slime slime) {
        Cursor inspector = slime.get();
        return ContainerEndpointSerializer.endpointListFromSlime((Inspector)inspector);
    }

    public static List<ContainerEndpoint> endpointListFromSlime(Inspector inspector) {
        ArrayList<ContainerEndpoint> endpoints = new ArrayList<ContainerEndpoint>();
        inspector.traverse((idx, endpointInspector) -> {
            ContainerEndpoint containerEndpoint = ContainerEndpointSerializer.endpointFromSlime(endpointInspector);
            endpoints.add(containerEndpoint);
        });
        return endpoints;
    }

    public static void endpointToSlime(Cursor cursor, ContainerEndpoint endpoint) {
        cursor.setString(clusterIdField, endpoint.clusterId());
        cursor.setString(scopeField, endpoint.scope().name());
        Cursor namesInspector = cursor.setArray(namesField);
        endpoint.names().forEach(arg_0 -> ((Cursor)namesInspector).addString(arg_0));
    }

    public static Slime endpointListToSlime(List<ContainerEndpoint> endpoints) {
        Slime slime = new Slime();
        Cursor cursor = slime.setArray();
        endpoints.forEach(endpoint -> {
            Cursor endpointCursor = cursor.addObject();
            ContainerEndpointSerializer.endpointToSlime(endpointCursor, endpoint);
        });
        return slime;
    }
}

