/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.server.filedistribution;

import com.google.inject.Inject;
import com.yahoo.cloud.config.ConfigserverConfig;
import com.yahoo.concurrent.DaemonThreadFactory;
import com.yahoo.config.FileReference;
import com.yahoo.config.subscription.ConfigSourceSet;
import com.yahoo.jrt.Int32Value;
import com.yahoo.jrt.Request;
import com.yahoo.jrt.StringValue;
import com.yahoo.jrt.Supervisor;
import com.yahoo.jrt.Transport;
import com.yahoo.jrt.Value;
import com.yahoo.vespa.config.ConnectionPool;
import com.yahoo.vespa.config.JRTConnectionPool;
import com.yahoo.vespa.config.server.filedistribution.FileDirectory;
import com.yahoo.vespa.config.server.filedistribution.FileDistributionUtil;
import com.yahoo.vespa.defaults.Defaults;
import com.yahoo.vespa.filedistribution.CompressedFileReference;
import com.yahoo.vespa.filedistribution.EmptyFileReferenceData;
import com.yahoo.vespa.filedistribution.FileDistributionConnectionPool;
import com.yahoo.vespa.filedistribution.FileDownloader;
import com.yahoo.vespa.filedistribution.FileReferenceData;
import com.yahoo.vespa.filedistribution.FileReferenceDownload;
import com.yahoo.vespa.filedistribution.LazyFileReferenceData;
import com.yahoo.vespa.filedistribution.LazyTemporaryStorageFileReferenceData;
import com.yahoo.vespa.flags.BooleanFlag;
import com.yahoo.vespa.flags.FlagSource;
import com.yahoo.vespa.flags.Flags;
import com.yahoo.yolean.Exceptions;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.logging.Level;
import java.util.logging.Logger;

public class FileServer {
    private static final Logger log = Logger.getLogger(FileServer.class.getName());
    private final FileDirectory root;
    private final ExecutorService executor;
    private final FileDownloader downloader;

    @Inject
    public FileServer(ConfigserverConfig configserverConfig, FlagSource flagSource) {
        this(new File(Defaults.getDefaults().underVespaHome(configserverConfig.fileReferencesDir())), FileServer.createFileDownloader(FileDistributionUtil.getOtherConfigServersInCluster(configserverConfig), ((BooleanFlag)Flags.USE_FILE_DISTRIBUTION_CONNECTION_POOL.bindTo(flagSource)).value()));
    }

    public FileServer(File rootDir) {
        this(rootDir, FileServer.createFileDownloader(List.of(), true));
    }

    public FileServer(File rootDir, FileDownloader fileDownloader) {
        this.downloader = fileDownloader;
        this.root = new FileDirectory(rootDir);
        this.executor = Executors.newFixedThreadPool(Math.max(8, Runtime.getRuntime().availableProcessors()), (ThreadFactory)new DaemonThreadFactory("file-server-"));
    }

    boolean hasFile(String fileReference) {
        return this.hasFile(new FileReference(fileReference));
    }

    private boolean hasFile(FileReference reference) {
        try {
            return this.root.getFile(reference).exists();
        }
        catch (IllegalArgumentException e) {
            log.log(Level.FINE, () -> "Failed locating file reference '" + reference + "' with error " + e.toString());
            return false;
        }
    }

    FileDirectory getRootDir() {
        return this.root;
    }

    void startFileServing(String fileName, Receiver target) {
        FileReference reference = new FileReference(fileName);
        File file = this.root.getFile(reference);
        if (file.exists()) {
            this.serveFile(reference, target);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void serveFile(FileReference reference, Receiver target) {
        File file = this.root.getFile(reference);
        log.log(Level.FINE, () -> "Start serving reference '" + reference.value() + "' with file '" + file.getAbsolutePath() + "'");
        boolean success = false;
        Object errorDescription = "OK";
        FileReferenceData fileData = EmptyFileReferenceData.empty((FileReference)reference, (String)file.getName());
        try {
            fileData = this.readFileReferenceData(reference);
            success = true;
        }
        catch (IOException e) {
            errorDescription = "For file reference '" + reference.value() + "': failed reading file '" + file.getAbsolutePath() + "'";
            log.warning((String)errorDescription + " for sending to '" + target.toString() + "'. " + e.toString());
        }
        try {
            target.receive(fileData, new ReplayStatus(success ? 0 : 1, (String)(success ? "OK" : errorDescription)));
            log.log(Level.FINE, () -> "Done serving file reference '" + reference.value() + "' with file '" + file.getAbsolutePath() + "'");
        }
        catch (Exception e) {
            log.log(Level.WARNING, "Failed serving file reference '" + reference.value() + "': " + Exceptions.toMessageString((Throwable)e));
        }
        finally {
            fileData.close();
        }
    }

    private FileReferenceData readFileReferenceData(FileReference reference) throws IOException {
        File file = this.root.getFile(reference);
        if (file.isDirectory()) {
            Path tempFile = Files.createTempFile("filereferencedata", reference.value(), new FileAttribute[0]);
            File compressedFile = CompressedFileReference.compress((File)file.getParentFile(), (File)tempFile.toFile());
            return new LazyTemporaryStorageFileReferenceData(reference, file.getName(), FileReferenceData.Type.compressed, compressedFile);
        }
        return new LazyFileReferenceData(reference, file.getName(), FileReferenceData.Type.file, file);
    }

    public void serveFile(String fileReference, boolean downloadFromOtherSourceIfNotFound, Request request, Receiver receiver) {
        if (this.executor instanceof ThreadPoolExecutor) {
            log.log(Level.FINE, () -> "Active threads is now " + ((ThreadPoolExecutor)this.executor).getActiveCount());
        }
        this.executor.execute(() -> this.serveFileInternal(fileReference, downloadFromOtherSourceIfNotFound, request, receiver));
    }

    private void serveFileInternal(String fileReference, boolean downloadFromOtherSourceIfNotFound, Request request, Receiver receiver) {
        boolean fileExists;
        log.log(Level.FINE, () -> "Received request for reference '" + fileReference + "' from " + request.target());
        try {
            String client = request.target().toString();
            FileReferenceDownload fileReferenceDownload = new FileReferenceDownload(new FileReference(fileReference), downloadFromOtherSourceIfNotFound, client);
            fileExists = this.hasFileDownloadIfNeeded(fileReferenceDownload);
            if (fileExists) {
                this.startFileServing(fileReference, receiver);
            }
        }
        catch (IllegalArgumentException e) {
            fileExists = false;
            log.warning("Failed serving file reference '" + fileReference + "', request was from " + request.target() + ", with error " + e.toString());
        }
        FileApiErrorCodes result = fileExists ? FileApiErrorCodes.OK : FileApiErrorCodes.NOT_FOUND;
        request.returnValues().add((Value)new Int32Value(result.getCode())).add((Value)new StringValue(result.getDescription()));
        request.returnRequest();
    }

    boolean hasFileDownloadIfNeeded(FileReferenceDownload fileReferenceDownload) {
        FileReference fileReference = fileReferenceDownload.fileReference();
        if (this.hasFile(fileReference)) {
            return true;
        }
        if (fileReferenceDownload.downloadFromOtherSourceIfNotFound()) {
            log.log(Level.FINE, "File not found, downloading from another source");
            FileReferenceDownload newDownload = new FileReferenceDownload(fileReference, false, fileReferenceDownload.client());
            return this.downloader.getFile(newDownload).isPresent();
        }
        log.log(Level.FINE, "File not found, will not download from another source, since request came from another config server");
        return false;
    }

    public FileDownloader downloader() {
        return this.downloader;
    }

    public void close() {
        this.downloader.close();
        this.executor.shutdown();
    }

    private static FileDownloader createFileDownloader(List<String> configServers, boolean useFileDistributionConnectionPool) {
        Supervisor supervisor = new Supervisor(new Transport("filedistribution-pool")).setDropEmptyBuffers(true);
        return new FileDownloader(configServers.isEmpty() ? FileDownloader.emptyConnectionPool() : FileServer.createConnectionPool(configServers, supervisor, useFileDistributionConnectionPool), supervisor);
    }

    private static ConnectionPool createConnectionPool(List<String> configServers, Supervisor supervisor, boolean useFileDistributionConnectionPool) {
        ConfigSourceSet configSourceSet = new ConfigSourceSet(configServers);
        if (configServers.size() == 0) {
            return FileDownloader.emptyConnectionPool();
        }
        return useFileDistributionConnectionPool ? new FileDistributionConnectionPool(configSourceSet, supervisor) : new JRTConnectionPool(configSourceSet, supervisor);
    }

    public static interface Receiver {
        public void receive(FileReferenceData var1, ReplayStatus var2);
    }

    public static class ReplayStatus {
        private final int code;
        private final String description;

        ReplayStatus(int code, String description) {
            this.code = code;
            this.description = description;
        }

        public boolean ok() {
            return this.code == 0;
        }

        public int getCode() {
            return this.code;
        }

        public String getDescription() {
            return this.description;
        }
    }

    private static enum FileApiErrorCodes {
        OK(0, "OK"),
        NOT_FOUND(1, "Filereference not found");

        private final int code;
        private final String description;

        private FileApiErrorCodes(int code, String description) {
            this.code = code;
            this.description = description;
        }

        int getCode() {
            return this.code;
        }

        String getDescription() {
            return this.description;
        }
    }
}

