/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.server.maintenance;

import com.yahoo.cloud.config.ConfigserverConfig;
import com.yahoo.config.FileReference;
import com.yahoo.config.provision.ApplicationId;
import com.yahoo.config.subscription.ConfigSourceSet;
import com.yahoo.jrt.Supervisor;
import com.yahoo.jrt.Transport;
import com.yahoo.vespa.config.ConnectionPool;
import com.yahoo.vespa.config.JRTConnectionPool;
import com.yahoo.vespa.config.server.ApplicationRepository;
import com.yahoo.vespa.config.server.filedistribution.FileDistributionUtil;
import com.yahoo.vespa.config.server.maintenance.ConfigServerMaintainer;
import com.yahoo.vespa.config.server.session.Session;
import com.yahoo.vespa.config.server.session.SessionRepository;
import com.yahoo.vespa.config.server.tenant.Tenant;
import com.yahoo.vespa.curator.Curator;
import com.yahoo.vespa.defaults.Defaults;
import com.yahoo.vespa.filedistribution.FileDownloader;
import com.yahoo.vespa.filedistribution.FileReferenceDownload;
import com.yahoo.vespa.flags.FlagSource;
import java.io.File;
import java.time.Duration;
import java.util.logging.Logger;

public class ApplicationPackageMaintainer
extends ConfigServerMaintainer {
    private static final Logger log = Logger.getLogger(ApplicationPackageMaintainer.class.getName());
    private final ApplicationRepository applicationRepository;
    private final File downloadDirectory;
    private final ConfigserverConfig configserverConfig;
    private final Supervisor supervisor;

    ApplicationPackageMaintainer(ApplicationRepository applicationRepository, Curator curator, Duration interval, FlagSource flagSource) {
        super(applicationRepository, curator, flagSource, applicationRepository.clock().instant(), interval, false);
        this.applicationRepository = applicationRepository;
        this.configserverConfig = applicationRepository.configserverConfig();
        this.supervisor = new Supervisor(new Transport("filedistribution-pool")).setDropEmptyBuffers(true);
        this.downloadDirectory = new File(Defaults.getDefaults().underVespaHome(this.configserverConfig.fileReferencesDir()));
    }

    protected double maintain() {
        if (FileDistributionUtil.getOtherConfigServersInCluster(this.configserverConfig).isEmpty()) {
            return 1.0;
        }
        int attempts = 0;
        int failures = 0;
        try (FileDownloader fileDownloader = this.createFileDownloader();){
            for (ApplicationId applicationId : this.applicationRepository.listApplications()) {
                FileReference appFileReference;
                log.finest(() -> "Verifying application package for " + applicationId);
                Session session = this.applicationRepository.getActiveSession(applicationId);
                if (session == null || (appFileReference = session.getApplicationPackageReference()) == null) continue;
                long sessionId = session.getSessionId();
                ++attempts;
                if (!FileDistributionUtil.fileReferenceExistsOnDisk(this.downloadDirectory, appFileReference)) {
                    log.fine(() -> "Downloading application package for " + applicationId + " (session " + sessionId + ")");
                    FileReferenceDownload download = new FileReferenceDownload(appFileReference, false, ((Object)((Object)this)).getClass().getSimpleName());
                    if (fileDownloader.getFile(download).isEmpty()) {
                        ++failures;
                        log.warning("Failed to download application package (" + appFileReference + ") for " + applicationId + " (session " + sessionId + ")");
                        continue;
                    }
                }
                this.createLocalSessionIfMissing(applicationId, sessionId);
            }
        }
        return this.asSuccessFactor(attempts, failures);
    }

    private FileDownloader createFileDownloader() {
        return new FileDownloader((ConnectionPool)new JRTConnectionPool(new ConfigSourceSet(FileDistributionUtil.getOtherConfigServersInCluster(this.configserverConfig)), this.supervisor), this.supervisor, this.downloadDirectory);
    }

    public void awaitShutdown() {
        this.supervisor.transport().shutdown().join();
        super.awaitShutdown();
    }

    private void createLocalSessionIfMissing(ApplicationId applicationId, long sessionId) {
        Tenant tenant = this.applicationRepository.getTenant(applicationId);
        SessionRepository sessionRepository = tenant.getSessionRepository();
        if (sessionRepository.getLocalSession(sessionId) == null) {
            sessionRepository.createLocalSessionFromDistributedApplicationPackage(sessionId);
        }
    }
}

