/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.server.tenant;

import com.yahoo.component.Version;
import com.yahoo.config.provision.ApplicationId;
import com.yahoo.config.provision.TenantName;
import com.yahoo.log.LogLevel;
import com.yahoo.vespa.config.ConfigKey;
import com.yahoo.vespa.config.GetConfigRequest;
import com.yahoo.vespa.config.protocol.ConfigResponse;
import com.yahoo.vespa.config.server.NotFoundException;
import com.yahoo.vespa.config.server.ReloadHandler;
import com.yahoo.vespa.config.server.ReloadListener;
import com.yahoo.vespa.config.server.RequestHandler;
import com.yahoo.vespa.config.server.application.Application;
import com.yahoo.vespa.config.server.application.ApplicationMapper;
import com.yahoo.vespa.config.server.application.ApplicationSet;
import com.yahoo.vespa.config.server.application.TenantApplications;
import com.yahoo.vespa.config.server.application.VersionDoesNotExistException;
import com.yahoo.vespa.config.server.host.HostRegistries;
import com.yahoo.vespa.config.server.host.HostRegistry;
import com.yahoo.vespa.config.server.host.HostValidator;
import com.yahoo.vespa.config.server.monitoring.MetricUpdater;
import com.yahoo.vespa.config.server.monitoring.Metrics;
import com.yahoo.vespa.config.server.rpc.ConfigResponseFactory;
import com.yahoo.vespa.config.server.tenant.TenantRepository;
import com.yahoo.vespa.curator.Curator;
import com.yahoo.vespa.curator.Lock;
import java.time.Clock;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class TenantRequestHandler
implements RequestHandler,
ReloadHandler,
HostValidator<ApplicationId> {
    private static final Logger log = Logger.getLogger(TenantRequestHandler.class.getName());
    private final Metrics metrics;
    private final TenantName tenant;
    private final List<ReloadListener> reloadListeners;
    private final ConfigResponseFactory responseFactory;
    private final HostRegistry<ApplicationId> hostRegistry;
    private final ApplicationMapper applicationMapper = new ApplicationMapper();
    private final MetricUpdater tenantMetricUpdater;
    private final Clock clock = Clock.systemUTC();
    private final TenantApplications applications;

    public TenantRequestHandler(Metrics metrics, TenantName tenant, List<ReloadListener> reloadListeners, ConfigResponseFactory responseFactory, HostRegistries hostRegistries, Curator curator) {
        this.metrics = metrics;
        this.tenant = tenant;
        this.reloadListeners = List.copyOf(reloadListeners);
        this.responseFactory = responseFactory;
        this.tenantMetricUpdater = metrics.getOrCreateMetricUpdater(Metrics.createDimensions(tenant));
        this.hostRegistry = hostRegistries.createApplicationHostRegistry(tenant);
        this.applications = TenantApplications.create(curator, this, tenant);
    }

    @Override
    public ConfigResponse resolveConfig(ApplicationId appId, GetConfigRequest req, Optional<Version> vespaVersion) {
        Application application = this.getApplication(appId, vespaVersion);
        if (log.isLoggable((Level)LogLevel.DEBUG)) {
            log.log((Level)LogLevel.DEBUG, TenantRepository.logPre(appId) + "Resolving for tenant '" + this.tenant + "' with handler for application '" + application + "'");
        }
        return application.resolveConfig(req, this.responseFactory);
    }

    long getApplicationGeneration(ApplicationId appId, Optional<Version> vespaVersion) {
        Application application = this.getApplication(appId, vespaVersion);
        return application.getApplicationGeneration();
    }

    private void notifyReloadListeners(ApplicationSet applicationSet) {
        for (ReloadListener reloadListener : this.reloadListeners) {
            reloadListener.hostsUpdated(this.tenant, this.hostRegistry.getAllHosts());
            reloadListener.configActivated(applicationSet);
        }
    }

    @Override
    public void reloadConfig(ApplicationSet applicationSet) {
        ApplicationId id = applicationSet.getId();
        try (Lock lock = this.applications.lock(id);){
            if (!this.applications.exists(id)) {
                return;
            }
            if (applicationSet.getApplicationGeneration() != this.applications.requireActiveSessionOf(id)) {
                return;
            }
            this.setLiveApp(applicationSet);
            this.notifyReloadListeners(applicationSet);
        }
    }

    @Override
    public void removeApplication(ApplicationId applicationId) {
        try (Lock lock = this.applications.lock(applicationId);){
            if (this.applications.exists(applicationId)) {
                return;
            }
            if (this.applicationMapper.hasApplication(applicationId, this.clock.instant())) {
                this.applicationMapper.remove(applicationId);
                this.hostRegistry.removeHostsForKey(applicationId);
                this.reloadListenersOnRemove(applicationId);
                this.tenantMetricUpdater.setApplications(this.applicationMapper.numApplications());
                this.metrics.removeMetricUpdater(Metrics.createDimensions(applicationId));
            }
        }
    }

    @Override
    public void removeApplicationsExcept(Set<ApplicationId> applications) {
        for (ApplicationId activeApplication : this.applicationMapper.listApplicationIds()) {
            if (applications.contains(activeApplication)) continue;
            log.log(LogLevel.INFO, "Will remove deleted application " + activeApplication.toShortString());
            this.removeApplication(activeApplication);
        }
    }

    private void reloadListenersOnRemove(ApplicationId applicationId) {
        for (ReloadListener listener : this.reloadListeners) {
            listener.hostsUpdated(this.tenant, this.hostRegistry.getAllHosts());
            listener.applicationRemoved(applicationId);
        }
    }

    private void setLiveApp(ApplicationSet applicationSet) {
        ApplicationId id = applicationSet.getId();
        Collection<String> hostsForApp = applicationSet.getAllHosts();
        this.hostRegistry.update(id, hostsForApp);
        applicationSet.updateHostMetrics();
        this.tenantMetricUpdater.setApplications(this.applicationMapper.numApplications());
        this.applicationMapper.register(id, applicationSet);
    }

    @Override
    public Set<ConfigKey<?>> listNamedConfigs(ApplicationId appId, Optional<Version> vespaVersion, ConfigKey<?> keyToMatch, boolean recursive) {
        Application application = this.getApplication(appId, vespaVersion);
        return this.listConfigs(application, keyToMatch, recursive);
    }

    /*
     * WARNING - void declaration
     */
    private Set<ConfigKey<?>> listConfigs(Application application, ConfigKey<?> keyToMatch, boolean recursive) {
        LinkedHashSet ret = new LinkedHashSet();
        for (ConfigKey<?> configKey : application.allConfigsProduced()) {
            void var6_10;
            String configId = configKey.getConfigId();
            if (recursive) {
                ConfigKey configKey2 = new ConfigKey(configKey.getName(), configId, configKey.getNamespace());
            } else {
                ConfigKey configKey3 = new ConfigKey(configKey.getName(), configId.split("/")[0], configKey.getNamespace());
            }
            if (keyToMatch != null) {
                void var6_6;
                String n = var6_10.getName();
                String ns = var6_10.getNamespace();
                if (!n.equals(keyToMatch.getName()) || !ns.equals(keyToMatch.getNamespace()) || !configId.startsWith(keyToMatch.getConfigId()) || configId.equals(keyToMatch.getConfigId())) continue;
                if (!recursive) {
                    ConfigKey configKey4 = new ConfigKey(var6_10.getName(), this.appendOneLevelOfId(keyToMatch.getConfigId(), configId), var6_10.getNamespace());
                }
                ret.add((ConfigKey<?>)var6_6);
                continue;
            }
            ret.add((ConfigKey<?>)var6_10);
        }
        return ret;
    }

    @Override
    public Set<ConfigKey<?>> listConfigs(ApplicationId appId, Optional<Version> vespaVersion, boolean recursive) {
        Application application = this.getApplication(appId, vespaVersion);
        return this.listConfigs(application, null, recursive);
    }

    String appendOneLevelOfId(String baseIdSegment, String id) {
        if ("".equals(baseIdSegment)) {
            return id.split("/")[0];
        }
        String theRest = id.substring(baseIdSegment.length());
        if ("".equals(theRest)) {
            return id;
        }
        theRest = theRest.replaceFirst("/", "");
        String theRestFirstSeg = theRest.split("/")[0];
        return baseIdSegment + "/" + theRestFirstSeg;
    }

    @Override
    public Set<ConfigKey<?>> allConfigsProduced(ApplicationId appId, Optional<Version> vespaVersion) {
        Application application = this.getApplication(appId, vespaVersion);
        return application.allConfigsProduced();
    }

    private Application getApplication(ApplicationId appId, Optional<Version> vespaVersion) {
        try {
            return this.applicationMapper.getForVersion(appId, vespaVersion, this.clock.instant());
        }
        catch (VersionDoesNotExistException ex) {
            throw new NotFoundException(String.format("%sNo such application (id %s): %s", TenantRepository.logPre(this.tenant), appId, ex.getMessage()));
        }
    }

    @Override
    public Set<String> allConfigIds(ApplicationId appId, Optional<Version> vespaVersion) {
        Application application = this.getApplication(appId, vespaVersion);
        return application.allConfigIds();
    }

    @Override
    public boolean hasApplication(ApplicationId appId, Optional<Version> vespaVersion) {
        return this.hasHandler(appId, vespaVersion);
    }

    private boolean hasHandler(ApplicationId appId, Optional<Version> vespaVersion) {
        return this.applicationMapper.hasApplicationForVersion(appId, vespaVersion, this.clock.instant());
    }

    @Override
    public ApplicationId resolveApplicationId(String hostName) {
        ApplicationId applicationId = this.hostRegistry.getKeyForHost(hostName);
        if (applicationId == null) {
            applicationId = ApplicationId.defaultId();
        }
        return applicationId;
    }

    @Override
    public void verifyHosts(ApplicationId key, Collection<String> newHosts) {
        this.hostRegistry.verifyHosts(key, newHosts);
        for (ReloadListener reloadListener : this.reloadListeners) {
            reloadListener.verifyHostsAreAvailable(this.tenant, newHosts);
        }
    }

    TenantApplications applications() {
        return this.applications;
    }
}

