/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.server.deploy;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.yahoo.config.FileReference;
import com.yahoo.config.application.api.DeployLogger;
import com.yahoo.config.model.api.ServiceInfo;
import com.yahoo.config.provision.ActivationContext;
import com.yahoo.config.provision.ApplicationId;
import com.yahoo.config.provision.ApplicationTransaction;
import com.yahoo.config.provision.HostFilter;
import com.yahoo.config.provision.ProvisionLock;
import com.yahoo.config.provision.Provisioner;
import com.yahoo.config.provision.TransientException;
import com.yahoo.transaction.NestedTransaction;
import com.yahoo.vespa.config.server.ApplicationRepository;
import com.yahoo.vespa.config.server.TimeoutBudget;
import com.yahoo.vespa.config.server.configchange.ConfigChangeActions;
import com.yahoo.vespa.config.server.configchange.ReindexActions;
import com.yahoo.vespa.config.server.configchange.RestartActions;
import com.yahoo.vespa.config.server.session.PrepareParams;
import com.yahoo.vespa.config.server.session.Session;
import com.yahoo.vespa.config.server.tenant.Tenant;
import java.time.Clock;
import java.time.Duration;
import java.util.Collection;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;

public class Deployment
implements com.yahoo.config.provision.Deployment {
    private static final Logger log = Logger.getLogger(Deployment.class.getName());
    private static final Duration durationBetweenResourceReadyChecks = Duration.ofSeconds(60L);
    private final Session session;
    private final ApplicationRepository applicationRepository;
    private final Supplier<PrepareParams> params;
    private final Optional<Provisioner> provisioner;
    private final Tenant tenant;
    private final DeployLogger deployLogger;
    private final Clock clock;
    private final boolean internalRedeploy;
    private boolean prepared;
    private ConfigChangeActions configChangeActions;

    private Deployment(Session session, ApplicationRepository applicationRepository, Supplier<PrepareParams> params, Optional<Provisioner> provisioner, Tenant tenant, DeployLogger deployLogger, Clock clock, boolean internalRedeploy, boolean prepared) {
        this.session = session;
        this.applicationRepository = applicationRepository;
        this.params = params;
        this.provisioner = provisioner;
        this.tenant = tenant;
        this.deployLogger = deployLogger;
        this.clock = clock;
        this.internalRedeploy = internalRedeploy;
        this.prepared = prepared;
    }

    public static Deployment unprepared(Session session, ApplicationRepository applicationRepository, Optional<Provisioner> provisioner, Tenant tenant, PrepareParams params, DeployLogger logger, Clock clock) {
        return new Deployment(session, applicationRepository, (Supplier<PrepareParams>)((Supplier)() -> params), provisioner, tenant, logger, clock, false, false);
    }

    public static Deployment unprepared(Session session, ApplicationRepository applicationRepository, Optional<Provisioner> provisioner, Tenant tenant, DeployLogger logger, Duration timeout, Clock clock, boolean validate, boolean isBootstrap) {
        Supplier<PrepareParams> params = Deployment.createPrepareParams(clock, timeout, session, isBootstrap, !validate, false, true);
        return new Deployment(session, applicationRepository, params, provisioner, tenant, logger, clock, true, false);
    }

    public static Deployment prepared(Session session, ApplicationRepository applicationRepository, Optional<Provisioner> provisioner, Tenant tenant, DeployLogger logger, Duration timeout, Clock clock, boolean isBootstrap, boolean force) {
        Supplier<PrepareParams> params = Deployment.createPrepareParams(clock, timeout, session, isBootstrap, false, force, false);
        return new Deployment(session, applicationRepository, params, provisioner, tenant, logger, clock, false, true);
    }

    public void prepare() {
        if (this.prepared) {
            return;
        }
        PrepareParams params = (PrepareParams)this.params.get();
        ApplicationId applicationId = params.getApplicationId();
        try (ApplicationRepository.ActionTimer timer = this.applicationRepository.timerFor(applicationId, "deployment.prepareMillis");){
            this.configChangeActions = this.tenant.getSessionRepository().prepareLocalSession(this.session, this.deployLogger, params, this.clock.instant());
            this.prepared = true;
        }
        Deployment.waitForResourcesOrTimeout(params, this.session, this.provisioner);
    }

    public long activate() {
        this.prepare();
        this.validateSessionStatus(this.session);
        PrepareParams params = (PrepareParams)this.params.get();
        ApplicationId applicationId = this.session.getApplicationId();
        try (ApplicationRepository.ActionTimer timer = this.applicationRepository.timerFor(applicationId, "deployment.activateMillis");){
            TimeoutBudget timeoutBudget = params.getTimeoutBudget();
            timeoutBudget.assertNotTimedOut(() -> "Timeout exceeded when trying to activate '" + applicationId + "'");
            ApplicationRepository.Activation activation = this.applicationRepository.activate(this.session, applicationId, this.tenant, params.force());
            activation.awaitCompletion(timeoutBudget.timeLeft());
            this.logActivatedMessage(applicationId, activation);
            if (this.provisioner.isPresent() && this.configChangeActions != null) {
                this.restartServices(applicationId);
            }
            this.storeReindexing(applicationId, this.session.getMetaData().getGeneration());
            long l = this.session.getMetaData().getGeneration();
            return l;
        }
    }

    private void logActivatedMessage(ApplicationId applicationId, ApplicationRepository.Activation activation) {
        Set<FileReference> fileReferences = this.applicationRepository.getFileReferences(applicationId);
        String fileReferencesText = fileReferences.size() > 10 ? " " + fileReferences.size() + " file references" : "File references: " + fileReferences;
        log.log(Level.INFO, this.session.logPre() + "Session " + this.session.getSessionId() + " activated successfully using " + this.provisioner.map(provisioner -> provisioner.getClass().getSimpleName()).orElse("no host provisioner") + ". Config generation " + this.session.getMetaData().getGeneration() + activation.sourceSessionId().stream().mapToObj(id -> ". Based on session " + id).findFirst().orElse("") + ". " + fileReferencesText);
    }

    private void restartServices(ApplicationId applicationId) {
        RestartActions restartActions = this.configChangeActions.getRestartActions().useForInternalRestart(this.internalRedeploy);
        if (!restartActions.isEmpty()) {
            Set hostnames = restartActions.getEntries().stream().flatMap(entry -> entry.getServices().stream()).map(ServiceInfo::getHostName).collect(Collectors.toUnmodifiableSet());
            this.provisioner.get().restart(applicationId, HostFilter.from(hostnames, Set.of(), Set.of(), Set.of()));
            this.deployLogger.log(Level.INFO, String.format("Scheduled service restart of %d nodes: %s", hostnames.size(), hostnames.stream().sorted().collect(Collectors.joining(", "))));
            log.info(String.format("%sScheduled service restart of %d nodes: %s", this.session.logPre(), hostnames.size(), restartActions.format()));
            this.configChangeActions = new ConfigChangeActions(new RestartActions(), this.configChangeActions.getRefeedActions(), this.configChangeActions.getReindexActions());
        }
    }

    private void storeReindexing(ApplicationId applicationId, long requiredSession) {
        this.applicationRepository.modifyReindexing(applicationId, reindexing -> {
            if (this.configChangeActions != null) {
                for (ReindexActions.Entry entry : this.configChangeActions.getReindexActions().getEntries()) {
                    reindexing = reindexing.withPending(entry.getClusterName(), entry.getDocumentType(), requiredSession);
                }
            }
            return reindexing;
        });
    }

    public void restart(HostFilter filter) {
        this.provisioner.get().restart(this.session.getApplicationId(), filter);
    }

    public Session session() {
        return this.session;
    }

    public ConfigChangeActions configChangeActions() {
        if (this.configChangeActions != null) {
            return this.configChangeActions;
        }
        throw new IllegalArgumentException("No config change actions: " + (this.prepared ? "was already prepared" : "not yet prepared"));
    }

    private void validateSessionStatus(Session session) {
        long sessionId = session.getSessionId();
        if (Session.Status.NEW.equals((Object)session.getStatus())) {
            throw new IllegalArgumentException(session.logPre() + "Session " + sessionId + " is not prepared");
        }
        if (Session.Status.ACTIVATE.equals((Object)session.getStatus())) {
            throw new IllegalArgumentException(session.logPre() + "Session " + sessionId + " is already active");
        }
    }

    private static Supplier<PrepareParams> createPrepareParams(Clock clock, Duration timeout, Session session, boolean isBootstrap, boolean ignoreValidationErrors, boolean force, boolean waitForResourcesInPrepare) {
        return Suppliers.memoize(() -> {
            TimeoutBudget timeoutBudget = new TimeoutBudget(clock, timeout);
            PrepareParams.Builder params = new PrepareParams.Builder().applicationId(session.getApplicationId()).vespaVersion(session.getVespaVersion().toString()).timeoutBudget(timeoutBudget).ignoreValidationErrors(ignoreValidationErrors).isBootstrap(isBootstrap).force(force).waitForResourcesInPrepare(waitForResourcesInPrepare).tenantSecretStores(session.getTenantSecretStores());
            session.getDockerImageRepository().ifPresent(params::dockerImageRepository);
            session.getAthenzDomain().ifPresent(params::athenzDomain);
            return params.build();
        });
    }

    private static void waitForResourcesOrTimeout(PrepareParams params, Session session, Optional<Provisioner> provisioner) {
        if (!params.waitForResourcesInPrepare() || provisioner.isEmpty()) {
            return;
        }
        Set preparedHosts = session.getAllocatedHosts().getHosts();
        ActivationContext context = new ActivationContext(session.getSessionId());
        ProvisionLock lock = new ProvisionLock(session.getApplicationId(), () -> {});
        AtomicReference<TransientException> lastException = new AtomicReference<TransientException>();
        while (true) {
            params.getTimeoutBudget().assertNotTimedOut(() -> "Timeout exceeded while waiting for application resources of '" + session.getApplicationId() + "'" + Optional.ofNullable((TransientException)((Object)lastException.get())).map(e -> ". Last exception: " + e.getMessage()).orElse(""));
            try {
                ApplicationTransaction transaction = new ApplicationTransaction(lock, new NestedTransaction());
                provisioner.get().activate((Collection)preparedHosts, context, transaction);
                return;
            }
            catch (TransientException e) {
                lastException.set(e);
                try {
                    Thread.sleep(durationBetweenResourceReadyChecks.toMillis());
                }
                catch (InterruptedException e1) {
                    throw new RuntimeException(e1);
                }
            }
        }
    }
}

