/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.server.metrics;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

public class DeploymentMetricsAggregator {
    private LatencyMetrics feed;
    private LatencyMetrics qr;
    private LatencyMetrics container;
    private Double documentCount;
    private ResourceUsage memoryUsage;
    private ResourceUsage diskUsage;
    private Map<String, Double> reindexingProgress;

    public synchronized DeploymentMetricsAggregator addFeedLatency(double sum, double count) {
        this.feed = DeploymentMetricsAggregator.combineLatency(this.feed, sum, count);
        return this;
    }

    public synchronized DeploymentMetricsAggregator addQrLatency(double sum, double count) {
        this.qr = DeploymentMetricsAggregator.combineLatency(this.qr, sum, count);
        return this;
    }

    public synchronized DeploymentMetricsAggregator addContainerLatency(double sum, double count) {
        this.container = DeploymentMetricsAggregator.combineLatency(this.container, sum, count);
        return this;
    }

    public synchronized DeploymentMetricsAggregator addDocumentCount(double count) {
        this.documentCount = (this.documentCount == null ? 0.0 : this.documentCount) + count;
        return this;
    }

    public synchronized DeploymentMetricsAggregator addDiskUsage(double feedBlockUtil, double feedBlockLimit) {
        this.diskUsage = DeploymentMetricsAggregator.combineResourceUtil(this.diskUsage, feedBlockUtil, feedBlockLimit);
        return this;
    }

    public synchronized DeploymentMetricsAggregator addMemoryUsage(double feedBlockUtil, double feedBlockLimit) {
        this.memoryUsage = DeploymentMetricsAggregator.combineResourceUtil(this.memoryUsage, feedBlockUtil, feedBlockLimit);
        return this;
    }

    public synchronized DeploymentMetricsAggregator addReindexingProgress(String documentType, double progress) {
        if (this.reindexingProgress == null) {
            this.reindexingProgress = new HashMap<String, Double>();
        }
        this.reindexingProgress.put(documentType, progress);
        return this;
    }

    public Optional<Double> aggregateFeedLatency() {
        return Optional.ofNullable(this.feed).map(m -> m.sum / m.count).filter(num -> !num.isNaN());
    }

    public Optional<Double> aggregateFeedRate() {
        return Optional.ofNullable(this.feed).map(m -> m.count / 60.0);
    }

    public Optional<Double> aggregateQueryLatency() {
        if (this.container == null && this.qr == null) {
            return Optional.empty();
        }
        LatencyMetrics c = Optional.ofNullable(this.container).orElseGet(() -> new LatencyMetrics());
        LatencyMetrics q = Optional.ofNullable(this.qr).orElseGet(() -> new LatencyMetrics());
        return Optional.of((c.sum + q.sum) / (c.count + q.count)).filter(num -> !num.isNaN());
    }

    public Optional<Double> aggregateQueryRate() {
        if (this.container == null && this.qr == null) {
            return Optional.empty();
        }
        LatencyMetrics c = Optional.ofNullable(this.container).orElseGet(() -> new LatencyMetrics());
        LatencyMetrics q = Optional.ofNullable(this.qr).orElseGet(() -> new LatencyMetrics());
        return Optional.of((c.count + q.count) / 60.0);
    }

    public Optional<Double> aggregateDocumentCount() {
        return Optional.ofNullable(this.documentCount);
    }

    public Optional<ResourceUsage> memoryUsage() {
        return Optional.ofNullable(this.memoryUsage);
    }

    public Optional<ResourceUsage> diskUsage() {
        return Optional.ofNullable(this.diskUsage);
    }

    public Optional<Map<String, Double>> reindexingProgress() {
        return Optional.ofNullable(this.reindexingProgress);
    }

    private static LatencyMetrics combineLatency(LatencyMetrics metricsOrNull, double sum, double count) {
        return Optional.ofNullable(metricsOrNull).orElseGet(() -> new LatencyMetrics()).combine(sum, count);
    }

    private static ResourceUsage combineResourceUtil(ResourceUsage resourceUsageOrNull, double util, double limit) {
        return Optional.ofNullable(resourceUsageOrNull).orElseGet(ResourceUsage::new).combine(util, limit);
    }

    public static class ResourceUsage {
        private double feedBlockUtil;
        private double feedBlockLimit;

        private ResourceUsage combine(double feedBlockUtil, double feedBlockLimit) {
            if (feedBlockUtil > this.feedBlockUtil) {
                this.feedBlockUtil = feedBlockUtil;
            }
            if (feedBlockLimit > this.feedBlockLimit) {
                this.feedBlockLimit = feedBlockLimit;
            }
            return this;
        }

        public double util() {
            return this.feedBlockUtil * this.feedBlockLimit;
        }

        public double feedBlockLimit() {
            return this.feedBlockLimit;
        }
    }

    private static class LatencyMetrics {
        private double sum;
        private double count;

        private LatencyMetrics() {
        }

        private LatencyMetrics combine(double sum, double count) {
            this.sum += sum;
            this.count += count;
            return this;
        }
    }
}

