/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.server.maintenance;

import com.yahoo.vespa.config.server.ApplicationRepository;
import com.yahoo.vespa.config.server.maintenance.ConfigServerMaintainer;
import com.yahoo.vespa.curator.Curator;
import com.yahoo.vespa.flags.FlagSource;
import java.time.Duration;
import java.util.logging.Level;

public class SessionsMaintainer
extends ConfigServerMaintainer {
    private final boolean hostedVespa;

    SessionsMaintainer(ApplicationRepository applicationRepository, Curator curator, Duration interval, FlagSource flagSource) {
        super(applicationRepository, curator, flagSource, applicationRepository.clock().instant(), interval);
        this.hostedVespa = applicationRepository.configserverConfig().hostedVespa();
    }

    protected double maintain() {
        this.log.log(Level.FINE, () -> "Running " + SessionsMaintainer.class.getSimpleName());
        this.applicationRepository.deleteExpiredLocalSessions();
        if (this.hostedVespa) {
            Duration expiryTime = Duration.ofMinutes(90L);
            int deleted = this.applicationRepository.deleteExpiredRemoteSessions(expiryTime);
            this.log.log(Level.FINE, () -> "Deleted " + deleted + " expired remote sessions older than " + expiryTime);
        }
        return 1.0;
    }
}

