/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.server.rpc;

import com.yahoo.cloud.config.ConfigserverConfig;
import com.yahoo.text.AbstractUtf8Array;
import com.yahoo.vespa.config.PayloadChecksum;
import com.yahoo.vespa.config.PayloadChecksums;
import com.yahoo.vespa.config.protocol.ConfigResponse;
import com.yahoo.vespa.config.server.rpc.LZ4ConfigResponseFactory;
import com.yahoo.vespa.config.server.rpc.UncompressedConfigResponseFactory;
import com.yahoo.vespa.config.util.ConfigUtils;

public interface ConfigResponseFactory {
    public static ConfigResponseFactory create(ConfigserverConfig configserverConfig) {
        switch (configserverConfig.payloadCompressionType()) {
            case LZ4: {
                return new LZ4ConfigResponseFactory();
            }
            case UNCOMPRESSED: {
                return new UncompressedConfigResponseFactory();
            }
        }
        throw new IllegalArgumentException("Unknown payload compression type " + configserverConfig.payloadCompressionType());
    }

    public ConfigResponse createResponse(AbstractUtf8Array var1, long var2, boolean var4, PayloadChecksums var5);

    default public PayloadChecksums generatePayloadChecksums(AbstractUtf8Array rawPayload, PayloadChecksums requestsPayloadChecksums) {
        PayloadChecksum requestChecksumMd5 = requestsPayloadChecksums.getForType(PayloadChecksum.Type.MD5);
        PayloadChecksum requestChecksumXxhash64 = requestsPayloadChecksums.getForType(PayloadChecksum.Type.XXHASH64);
        PayloadChecksum md5 = PayloadChecksum.empty((PayloadChecksum.Type)PayloadChecksum.Type.MD5);
        PayloadChecksum xxhash64 = PayloadChecksum.empty((PayloadChecksum.Type)PayloadChecksum.Type.XXHASH64);
        if (requestChecksumMd5.isEmpty() && requestChecksumXxhash64.isEmpty() || !requestChecksumMd5.isEmpty() && !requestChecksumXxhash64.isEmpty()) {
            md5 = new PayloadChecksum(ConfigUtils.getMd5((AbstractUtf8Array)rawPayload), PayloadChecksum.Type.MD5);
            xxhash64 = new PayloadChecksum(ConfigUtils.getXxhash64((AbstractUtf8Array)rawPayload), PayloadChecksum.Type.XXHASH64);
        } else if (!requestChecksumMd5.isEmpty()) {
            md5 = new PayloadChecksum(ConfigUtils.getMd5((AbstractUtf8Array)rawPayload), PayloadChecksum.Type.MD5);
        } else {
            xxhash64 = new PayloadChecksum(ConfigUtils.getXxhash64((AbstractUtf8Array)rawPayload), PayloadChecksum.Type.XXHASH64);
        }
        return PayloadChecksums.from((PayloadChecksum[])new PayloadChecksum[]{md5, xxhash64});
    }
}

